/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc10;

import java.util.Vector;
import jmunit.framework.cldc10.PerformanceMeasurement;
import jmunit.framework.cldc10.Test;
import jmunit.framework.cldc10.TestResult;

public abstract class TestCase
extends Test {
    private int totalOfTests;
    private Vector perfMeasurements;
    private boolean perfMeasurementsRunning;

    public TestCase(int n, String string) {
        super(string);
        this.totalOfTests = n;
        this.perfMeasurements = new Vector();
    }

    public abstract void test(int var1) throws Throwable;

    public void setUp() throws Throwable {
    }

    public void tearDown() {
    }

    public final void run(TestResult testResult) {
        for (int i = 0; i < this.totalOfTests; ++i) {
            String string = this.name + "#" + i;
            testResult.startTest(((Object)((Object)this)).getClass(), string);
            try {
                this.setUp();
                this.startPerformanceMeasurements();
                this.test(i);
                this.endPerformanceMeasurements();
            }
            catch (Throwable throwable) {
                testResult.addError(((Object)((Object)this)).getClass(), string, throwable);
            }
            try {
                this.tearDown();
            }
            catch (Throwable throwable) {
                testResult.addError(((Object)((Object)this)).getClass(), string, throwable);
            }
            testResult.endTest(((Object)((Object)this)).getClass(), string);
        }
    }

    public int countTestCases() {
        return this.totalOfTests;
    }

    protected final void addPerformanceMeasurement(PerformanceMeasurement performanceMeasurement) {
        this.perfMeasurements.addElement(performanceMeasurement);
    }

    protected final void removePerformanceMeasurement(PerformanceMeasurement performanceMeasurement) {
        this.perfMeasurements.removeElement(performanceMeasurement);
    }

    protected final void removeAllPerformanceMeasurements() {
        this.perfMeasurements.removeAllElements();
    }

    protected final void startPerformanceMeasurements() {
        this.perfMeasurementsRunning = true;
        for (int i = 0; i < this.perfMeasurements.size(); ++i) {
            ((PerformanceMeasurement)this.perfMeasurements.elementAt(i)).startMeasurement();
        }
    }

    protected final void endPerformanceMeasurements() {
        if (!this.perfMeasurementsRunning) {
            return;
        }
        this.perfMeasurementsRunning = false;
        for (int i = this.perfMeasurements.size() - 1; i >= 0; --i) {
            ((PerformanceMeasurement)this.perfMeasurements.elementAt(i)).endMeasurement();
        }
    }
}

