/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.bridge;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.api.server.CommonServerUIs;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstanceLookup;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.CustomizerAction;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class BridgingServerInstance
implements ServerInstanceImplementation,
Node.Cookie {
    private final ServerInstance instance;
    private org.netbeans.api.server.ServerInstance commonInstance;

    private BridgingServerInstance(ServerInstance serverInstance) {
        assert (serverInstance != null) : "ServerInstance must not be null";
        this.instance = serverInstance;
    }

    public static BridgingServerInstance createInstance(ServerInstance serverInstance) {
        BridgingServerInstance bridgingServerInstance = new BridgingServerInstance(serverInstance);
        bridgingServerInstance.commonInstance = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)bridgingServerInstance);
        return bridgingServerInstance;
    }

    public String getDisplayName() {
        return this.instance.getDisplayName();
    }

    public String getServerDisplayName() {
        return this.instance.getServer().getDisplayName();
    }

    public Node getFullNode() {
        StartServer startServer = this.instance.getStartServer();
        if (startServer == null) {
            return null;
        }
        Node node = startServer.isAlsoTargetServer(null) ? this.instance.getServer().getNodeProvider().createInstanceTargetNode(this.instance) : this.instance.getServer().getNodeProvider().createInstanceNode(this.instance);
        this.instance.refresh();
        return new InstanceNode(node, this);
    }

    public Node getBasicNode() {
        Node node = this.instance.getServer().getRegistryNodeFactory().getManagerNode(new ServerInstanceLookup(this.instance, this.instance.getServer().getDeploymentFactory(), null));
        return new ManagerNode(node, this.instance.getDisplayName());
    }

    public JComponent getCustomizer() {
        Node node = this.getBasicNode();
        if (node == null || !node.hasCustomizer()) {
            return null;
        }
        Component component = node.getCustomizer();
        if (!(component instanceof JComponent)) {
            return null;
        }
        return (JComponent)component;
    }

    public boolean isRemovable() {
        return !this.instance.isRemoveForbidden();
    }

    public void remove() {
        this.instance.remove();
    }

    public org.netbeans.api.server.ServerInstance getCommonInstance() {
        return this.commonInstance;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BridgingServerInstance bridgingServerInstance = (BridgingServerInstance)object;
        return this.instance == bridgingServerInstance.instance || this.instance != null && this.instance.equals(bridgingServerInstance.instance);
    }

    public int hashCode() {
        int n = 7;
        return n;
    }

    private static class BridgingCustomizerAction
    extends NodeAction {
        private BridgingCustomizerAction() {
        }

        public void performAction(Node[] nodeArray) {
            BridgingServerInstance bridgingServerInstance = (BridgingServerInstance)nodeArray[0].getCookie(BridgingServerInstance.class);
            CommonServerUIs.showCustomizer((org.netbeans.api.server.ServerInstance)bridgingServerInstance.getCommonInstance());
        }

        protected boolean enable(Node[] nodeArray) {
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(BridgingServerInstance.class, (String)"LBL_Properties");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class InstanceNode
    extends FilterNode {
        private final BridgingServerInstance instance;

        public InstanceNode(Node node, BridgingServerInstance bridgingServerInstance) {
            super(node);
            this.instance = bridgingServerInstance;
        }

        public Node.Cookie getCookie(Class clazz) {
            if (BridgingServerInstance.class.isAssignableFrom(clazz)) {
                return this.instance;
            }
            return super.getCookie(clazz);
        }

        public Action[] getActions(boolean bl) {
            boolean bl2 = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Action[] actionArray = this.getOriginal().getActions(bl);
            for (int i = 0; i < actionArray.length; ++i) {
                if (actionArray[i] instanceof CustomizerAction) {
                    arrayList.add(SystemAction.get(BridgingCustomizerAction.class));
                    bl2 = true;
                    continue;
                }
                arrayList.add(actionArray[i]);
            }
            if (!bl2) {
                arrayList.add(null);
                arrayList.add(SystemAction.get(BridgingCustomizerAction.class));
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }
    }

    private static class ManagerNode
    extends FilterNode {
        public ManagerNode(Node node, String string) {
            super(node);
            this.disableDelegation(396);
            this.setDisplayName(string);
        }
    }
}

