/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.marshal;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.marshal.MarshalStream;

public class MarshalCache {
    private final Map linkCache = new IdentityHashMap();
    private final Map symbolCache = new IdentityHashMap();

    public boolean isRegistered(IRubyObject value) {
        return this.selectCache(value).containsKey(value);
    }

    public void register(IRubyObject value) {
        Map cache = this.selectCache(value);
        cache.put(value, new Integer(cache.size()));
    }

    private int registeredIndex(IRubyObject value) {
        return (Integer)this.selectCache(value).get(value);
    }

    private Map selectCache(IRubyObject value) {
        return value instanceof RubySymbol ? this.symbolCache : this.linkCache;
    }

    public void writeLink(MarshalStream output, IRubyObject value) throws IOException {
        output.write(MarshalCache.linkType(value));
        output.writeInt(this.registeredIndex(value));
    }

    private static char linkType(IRubyObject value) {
        return value instanceof RubySymbol ? (char)';' : '@';
    }
}

