/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.project.ui.CDCFoldersListSettings;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.PanelConfigurePlatform;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class NewCDCProjectWizardIterator
implements TemplateWizard.Iterator {
    public static final int TYPE_APP = 0;
    public static final int TYPE_LIB = 1;
    public static final int TYPE_EXT = 2;
    public static final int TYPE_SAMPLE = 3;
    static final String PROP_NAME_INDEX = "nameIndex";
    static final String MANIFEST_FILE = "manifest.mf";
    private static final long serialVersionUID = 1L;
    private int type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;

    public NewCDCProjectWizardIterator() {
        this(0);
    }

    public NewCDCProjectWizardIterator(int type) {
        this.type = type;
    }

    public static NewCDCProjectWizardIterator library() {
        return new NewCDCProjectWizardIterator(1);
    }

    public static NewCDCProjectWizardIterator existing() {
        return new NewCDCProjectWizardIterator(2);
    }

    private WizardDescriptor.Panel[] createPanels() {
        WizardDescriptor.Panel[] panelArray;
        int i = NewCDCProjectWizardIterator.getNumberOfCdcPlatforms();
        if (i != 0) {
            WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[2];
            panelArray2[0] = new PanelConfigureProject(this.type);
            panelArray = panelArray2;
            panelArray2[1] = new PanelConfigurePlatform();
        } else {
            WizardDescriptor.Panel[] panelArray3 = new WizardDescriptor.Panel[3];
            panelArray3[0] = new PlatformInstallPanel.WizardPanel("cdc");
            panelArray3[1] = new PanelConfigureProject(this.type);
            panelArray = panelArray3;
            panelArray3[2] = new PanelConfigurePlatform();
        }
        return panelArray;
    }

    private String[] createSteps() {
        String[] stringArray;
        int i = NewCDCProjectWizardIterator.getNumberOfCdcPlatforms();
        if (i != 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_ConfigureProject");
            stringArray = stringArray2;
            stringArray2[1] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_SelectPlatform");
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_Step_AddPlatform");
            stringArray3[1] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_ConfigureProject");
            stringArray = stringArray3;
            stringArray3[2] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_SelectPlatform");
        }
        return stringArray;
    }

    private static String createMainClass(String mainClassName, FileObject srcFolder, String platformType) throws IOException {
        DataFolder pDf;
        DataObject doj;
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0 || platformType == null) {
            return null;
        }
        FileObject mainTemplate = FileUtil.getConfigFile((String)("MainTemplates/org.netbeans.modules.kjava.j2meproject/" + platformType));
        if (mainTemplate == null) {
            return null;
        }
        String templateName = (String)mainTemplate.getAttribute("templateName");
        String templateType = (String)mainTemplate.getAttribute("templateType");
        if (templateName == null || templateType == null) {
            return null;
        }
        mainTemplate = FileUtil.getConfigFile((String)templateName);
        if (mainTemplate == null) {
            return null;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        if ((doj = mt.createFromTemplate(pDf = DataFolder.findFolder((FileObject)pkgFolder), mName)) != null) {
            doj.getPrimaryFile().setAttribute("justCreatedByNewWizard", (Object)Boolean.TRUE);
        }
        return templateType;
    }

    private static String normalizePath(File path, File jdkHome, String propName) {
        String loc;
        String jdkLoc = jdkHome.getAbsolutePath();
        if (!jdkLoc.endsWith(File.separator)) {
            jdkLoc = jdkLoc + File.separator;
        }
        if ((loc = path.getAbsolutePath()).startsWith(jdkLoc)) {
            return "${" + propName + "}" + File.separator + loc.substring(jdkLoc.length());
        }
        return loc;
    }

    public static void generatePlatformProperties(CDCPlatform platform, String activeDevice, String activeProfile, EditableProperties props) {
        Collection installFolders = platform.getInstallFolders();
        if (installFolders.size() > 0) {
            File jdkHome = FileUtil.toFile((FileObject)((FileObject)installFolders.iterator().next()));
            StringBuffer sbootcp = new StringBuffer();
            ClassPath bootCP = platform.getBootstrapLibrariesForProfile(activeDevice, activeProfile);
            for (ClassPath.Entry entry : bootCP.entries()) {
                URL url = entry.getURL();
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                File root = new File(URI.create(url.toExternalForm()));
                if (sbootcp.length() > 0) {
                    sbootcp.append(File.pathSeparator);
                }
                sbootcp.append(NewCDCProjectWizardIterator.normalizePath(root, jdkHome, "platform.home"));
            }
            props.setProperty("platform.fat.jar", Boolean.toString(platform.isFatJar()));
            props.setProperty("platform.bootclasspath", sbootcp.toString());
            props.setProperty("javac.source", platform.getClassVersion());
            props.setProperty("javac.target", platform.getClassVersion());
        }
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        HashSet<DataObject> resultSet = new HashSet<DataObject>();
        File dirF = (File)wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        String name = (String)wiz.getProperty("name");
        final String mainClass = (String)wiz.getProperty("mainClass");
        String appName = (String)wiz.getProperty("appName");
        final String activePlatform = (String)wiz.getProperty("activePlatform");
        final String activeDevice = (String)wiz.getProperty("activeDevice");
        final String activeProfile = (String)wiz.getProperty("activeProfile");
        Properties props = (Properties)wiz.getProperty("additionalProperties");
        PlatformSelectionPanel.PlatformDescription pd = (PlatformSelectionPanel.PlatformDescription)wiz.getProperty("PlatformDescription");
        AntProjectHelper h = J2MEProjectGenerator.createProject((File)dirF, (String)name, (PlatformSelectionPanel.PlatformDescription)pd, (J2MEProjectGenerator.ProjectGeneratorCallback)new J2MEProjectGenerator.ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper helper, FileObject projectLocation, File projectLocationFile, ArrayList<String> configurations) throws IOException {
                EditableProperties ep;
                CDCPlatform cdcplatform;
                FileObject src = projectLocation.createFolder("src");
                JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(activePlatform, new Specification("cdc", null));
                if (platforms.length != 0) {
                    cdcplatform = (CDCPlatform)platforms[0];
                    ep = helper.getProperties("nbproject/project.properties");
                    if (mainClass != null) {
                        String templateType = NewCDCProjectWizardIterator.createMainClass(mainClass, src, cdcplatform.getType());
                        ep.setProperty("main.class", mainClass);
                        if (templateType != null) {
                            ep.setProperty("main.class.class", templateType);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("No CDC platform installed");
                }
                ep.setProperty("application.name", project.getProjectDirectory().getNameExt());
                ep.setProperty("platform.active", cdcplatform.getAntName());
                ep.setProperty("platform.active.description", cdcplatform.getDisplayName());
                ep.setProperty("platform.trigger", "CDC");
                ep.setProperty("platform.type", cdcplatform.getType());
                String classVersion = cdcplatform.getClassVersion();
                ep.setProperty("platform.device", activeDevice);
                ep.setProperty("platform.profile", activeProfile);
                NewCDCProjectWizardIterator.generatePlatformProperties(cdcplatform, activeDevice, activeProfile, ep);
                ep.setProperty("javac.source", classVersion != null ? classVersion : "1.2");
                ep.setProperty("javac.target", classVersion != null ? classVersion : "1.2");
                helper.putProperties("nbproject/project.properties", ep);
            }
        });
        if (mainClass != null && mainClass.length() > 0) {
            try {
                FileObject sourcesRoot = h.getProjectDirectory().getFileObject("src");
                FileObject mainClassFo = this.getMainClassFO(sourcesRoot, mainClass);
                assert (mainClassFo != null) : "sourcesRoot: " + sourcesRoot + ", mainClass: " + mainClass;
                resultSet.add(DataObject.find((FileObject)mainClassFo));
            }
            catch (Exception x) {
                ErrorManager.getDefault().notify((Throwable)x);
            }
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        if (this.type == 0 || this.type == 2) {
            NewCDCProjectWizardIterator.createManifest(dir, MANIFEST_FILE);
        }
        Integer index = (Integer)wiz.getProperty(PROP_NAME_INDEX);
        switch (this.type) {
            case 0: {
                CDCFoldersListSettings.setNewApplicationCount(index);
                break;
            }
            case 1: {
                CDCFoldersListSettings.setNewLibraryCount(index);
                break;
            }
            case 2: {
                CDCFoldersListSettings.setNewProjectCount(index);
            }
        }
        resultSet.add(DataObject.find((FileObject)h.getProjectDirectory()));
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        return resultSet;
    }

    public void initialize(TemplateWizard wiz) {
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        wiz.putProperty("additionalProperties", (Object)new Properties());
    }

    public void uninitialize(TemplateWizard wiz) {
        if (wiz != null) {
            wiz.putProperty("additionalProperties", null);
            wiz.putProperty("projdir", null);
            wiz.putProperty("name", null);
            wiz.putProperty("mainClass", null);
            if (this.type == 2) {
                wiz.putProperty("sourceRoot", null);
                wiz.putProperty("testRoot", null);
            }
        }
        wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private FileObject getMainClassFO(FileObject sourcesRoot, String mainClass) {
        mainClass = mainClass.replace('.', '/');
        return sourcesRoot.getFileObject(mainClass + ".java");
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createManifest(FileObject dir, String path) throws IOException {
        FileObject manifest = dir.createData(MANIFEST_FILE);
        FileLock lock = manifest.lock();
        try {
            OutputStream os = manifest.getOutputStream(lock);
            try {
                PrintWriter pw = new PrintWriter(os);
                pw.println("Manifest-Version: 1.0");
                pw.println("X-COMMENT: Main-Class will be added automatically by build");
                pw.println();
                pw.flush();
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    static int getNumberOfCdcPlatforms() {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
        int cnt = platforms.length;
        for (JavaPlatform javaPlatform : platforms) {
            if (javaPlatform.getInstallFolders().size() != 0) continue;
            --cnt;
        }
        return cnt;
    }
}

