/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;

public final class RubyLineConvertorFactory
implements ExecutionDescriptor.LineConvertorFactory {
    private static final Logger LOGGER = Logger.getLogger(RubyLineConvertorFactory.class.getName());
    private static final String WINDOWS_DRIVE = "(?:\\S{1}:[\\\\/])";
    private static final String FILE_CHAR = "[^\\s\\[\\]\\:\\\"]";
    private static final String FILE = "((?:[^\\s\\[\\]\\:\\\"]*))";
    private static final String FILE_WIN = "((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))";
    private static final String LINE = "([1-9][0-9]*)";
    private static final String ROL = ".*\\s?";
    private static final String SEP = "\\:";
    private static final String STD_SUFFIX = "((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?";
    static final Pattern RUBY_COMPILER = Pattern.compile(".*?((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
    static final Pattern JRUBY_COMPILER = Pattern.compile(":.*:\\s.*?((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
    static final Pattern RUBY_COMPILER_WIN_MY = Pattern.compile(".*?((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))\\:([1-9][0-9]*).*\\s?");
    private static final String TIME_PATTERN = "(\\d{1,2}:\\d{1,2}:\\d{1,2})";
    private static final String NUMERIC_URL_PATTERN = "(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}.\\d{1,3})";
    private static final String HTTP_URL_PATTERN = "(?:https?://.*?)";
    private static final String URL_PORT = "(?::(\\d{1,5}))";
    static final Pattern TIME_MATCHER = Pattern.compile("(\\d{1,2}:\\d{1,2}:\\d{1,2})");
    static final Pattern URL_MATCHER = Pattern.compile("((?:https?://.*?)|(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}.\\d{1,3}))(?::(\\d{1,5}))");
    static final Pattern RUBY_COMPILER_WIN = Pattern.compile("^(?:(?:\\[|\\]|\\-|\\:|[0-9]|\\s|\\,)*)(?:\\s*from )?((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))\\:([1-9][0-9]*).*\\s?");
    public static final Pattern RAILS_RECOGNIZER = Pattern.compile(".*#\\{RAILS_ROOT\\}/((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
    public static final Pattern RUBY_TEST_OUTPUT = Pattern.compile("\\s*test.*\\[((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
    public static final Pattern EXT_RE = Pattern.compile(".*\\.(rb|rake|mab|rjs|rxml|builder|erb)");
    private final LineConvertors.FileLocator locator;
    private final LineConvertor[] convertors;
    private final boolean stdConvertors;

    public static RubyLineConvertorFactory create(LineConvertors.FileLocator locator, LineConvertor ... convertors) {
        return new RubyLineConvertorFactory(locator, false, convertors);
    }

    public static RubyLineConvertorFactory withStandardConvertors(LineConvertors.FileLocator locator, LineConvertor ... convertors) {
        return new RubyLineConvertorFactory(locator, true, convertors);
    }

    private RubyLineConvertorFactory(LineConvertors.FileLocator locator, boolean stdConvertors, LineConvertor ... convertors) {
        this.locator = locator;
        this.convertors = convertors;
        this.stdConvertors = stdConvertors;
    }

    public static List<LineConvertor> getStandardConvertors(LineConvertors.FileLocator locator) {
        ArrayList<LineConvertor> result = new ArrayList<LineConvertor>(4);
        result.add(new ShortCircuitConvertor(TIME_MATCHER));
        result.add(new ShortCircuitConvertor(URL_MATCHER));
        result.add(LineConvertors.filePattern((LineConvertors.FileLocator)locator, (Pattern)RAILS_RECOGNIZER, null, (int)1, (int)2));
        result.add(LineConvertors.filePattern((LineConvertors.FileLocator)locator, (Pattern)RUBY_COMPILER_WIN_MY, null, (int)1, (int)2));
        result.add(LineConvertors.filePattern((LineConvertors.FileLocator)locator, (Pattern)JRUBY_COMPILER, null, (int)1, (int)2));
        result.add(LineConvertors.filePattern((LineConvertors.FileLocator)locator, (Pattern)RUBY_COMPILER, null, (int)1, (int)2));
        result.add(LineConvertors.filePattern((LineConvertors.FileLocator)locator, (Pattern)RUBY_COMPILER_WIN, null, (int)1, (int)2));
        return result;
    }

    public LineConvertor newLineConvertor() {
        ArrayList<LineConvertor> convertorList = new ArrayList<LineConvertor>();
        if (this.convertors != null) {
            for (LineConvertor each : this.convertors) {
                if (each == null) continue;
                convertorList.add(each);
            }
        }
        if (this.stdConvertors) {
            convertorList.addAll(RubyLineConvertorFactory.getStandardConvertors(this.locator));
        }
        return LineConvertors.proxy((LineConvertor[])convertorList.toArray(new LineConvertor[convertorList.size()]));
    }

    private static class ShortCircuitConvertor
    implements LineConvertor {
        private final Pattern linePattern;

        public ShortCircuitConvertor(Pattern linePattern) {
            this.linePattern = linePattern;
        }

        public List<ConvertedLine> convert(String line) {
            if (line.length() > 400) {
                return null;
            }
            Matcher matcher = this.linePattern.matcher(line);
            if (matcher.find()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    StringBuilder builder = new StringBuilder(line.length());
                    builder.append("[ ");
                    for (int i = 1; i < matcher.groupCount(); ++i) {
                        String match = matcher.group(i);
                        if (match == null) continue;
                        if (builder.length() > 2) {
                            builder.append(", ");
                        }
                        builder.append(match);
                    }
                    builder.append(" ]");
                    LOGGER.log(Level.FINEST, "ShortCircuitConvertor matched {0}.", builder.toString());
                }
                return Collections.singletonList(ConvertedLine.forText((String)line, null));
            }
            return null;
        }
    }
}

