/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class PrimitiveTypeSerializer
implements JavonSerializer {
    private final ClassData voidClassData = new ClassData("", "void", true, false, (JavonSerializer)this);
    private final ClassData booleanClassData = new ClassData("", "boolean", true, false, (JavonSerializer)this);
    private final ClassData BooleanClassData = new ClassData("java.lang", "Boolean", false, false, (JavonSerializer)this);
    private final ClassData byteClassData = new ClassData("", "byte", true, false, (JavonSerializer)this);
    private final ClassData ByteClassData = new ClassData("java.lang", "Byte", false, false, (JavonSerializer)this);
    private final ClassData charClassData = new ClassData("", "char", true, false, (JavonSerializer)this);
    private final ClassData CharClassData = new ClassData("java.lang", "Character", false, false, (JavonSerializer)this);
    private final ClassData intClassData = new ClassData("", "int", true, false, (JavonSerializer)this);
    private final ClassData IntClassData = new ClassData("java.lang", "Integer", false, false, (JavonSerializer)this);
    private final ClassData longClassData = new ClassData("", "long", true, false, (JavonSerializer)this);
    private final ClassData LongClassData = new ClassData("java.lang", "Long", false, false, (JavonSerializer)this);
    private final ClassData shortClassData = new ClassData("", "short", true, false, (JavonSerializer)this);
    private final ClassData ShortClassData = new ClassData("java.lang", "Short", false, false, (JavonSerializer)this);
    private final ClassData stringClassData = new ClassData("java.lang", "String", false, false, (JavonSerializer)this);

    @Override
    public String getName() {
        return "Primitive type serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (TypeKind.VOID == type.getKind()) {
            return true;
        }
        if (TypeKind.BOOLEAN == type.getKind()) {
            return true;
        }
        if (TypeKind.BYTE == type.getKind()) {
            return true;
        }
        if (TypeKind.CHAR == type.getKind()) {
            return true;
        }
        if (TypeKind.INT == type.getKind()) {
            return true;
        }
        if (TypeKind.LONG == type.getKind()) {
            return true;
        }
        if (TypeKind.SHORT == type.getKind()) {
            return true;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
            String classFullQualifiedName = clazz.getQualifiedName().toString();
            if ("java.lang.String".equals(classFullQualifiedName)) {
                return true;
            }
            if ("java.lang.Boolean".equals(classFullQualifiedName)) {
                return true;
            }
            if ("java.lang.Byte".equals(classFullQualifiedName)) {
                return true;
            }
            if ("java.lang.Character".equals(classFullQualifiedName)) {
                return true;
            }
            if ("java.lang.Integer".equals(classFullQualifiedName)) {
                return true;
            }
            if ("java.lang.Long".equals(classFullQualifiedName)) {
                return true;
            }
            if ("java.lang.Short".equals(classFullQualifiedName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (TypeKind.VOID == type.getKind()) {
            return this.voidClassData;
        }
        if (TypeKind.BOOLEAN == type.getKind()) {
            return this.booleanClassData;
        }
        if (TypeKind.BYTE == type.getKind()) {
            return this.byteClassData;
        }
        if (TypeKind.CHAR == type.getKind()) {
            return this.charClassData;
        }
        if (TypeKind.INT == type.getKind()) {
            return this.intClassData;
        }
        if (TypeKind.LONG == type.getKind()) {
            return this.longClassData;
        }
        if (TypeKind.SHORT == type.getKind()) {
            return this.shortClassData;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
            String classFullQualifiedName = clazz.getQualifiedName().toString();
            if ("java.lang.String".equals(classFullQualifiedName)) {
                return this.stringClassData;
            }
            if ("java.lang.Boolean".equals(classFullQualifiedName)) {
                return this.BooleanClassData;
            }
            if ("java.lang.Byte".equals(classFullQualifiedName)) {
                return this.ByteClassData;
            }
            if ("java.lang.Character".equals(classFullQualifiedName)) {
                return this.CharClassData;
            }
            if ("java.lang.Integer".equals(classFullQualifiedName)) {
                return this.IntClassData;
            }
            if ("java.lang.Long".equals(classFullQualifiedName)) {
                return this.LongClassData;
            }
            if ("java.lang.Short".equals(classFullQualifiedName)) {
                return this.ShortClassData;
            }
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping mapping, ClassData type) {
        if (this.booleanClassData.equals(type)) {
            return "boolean";
        }
        if (this.BooleanClassData.equals(type)) {
            return "Boolean";
        }
        if (this.byteClassData.equals(type)) {
            return "byte";
        }
        if (this.ByteClassData.equals(type)) {
            return "Byte";
        }
        if (this.charClassData.equals(type)) {
            return "char";
        }
        if (this.CharClassData.equals(type)) {
            return "Character";
        }
        if (this.intClassData.equals(type)) {
            return "int";
        }
        if (this.IntClassData.equals(type)) {
            return "Integer";
        }
        if (this.longClassData.equals(type)) {
            return "long";
        }
        if (this.LongClassData.equals(type)) {
            return "Long";
        }
        if (this.shortClassData.equals(type)) {
            return "short";
        }
        if (this.ShortClassData.equals(type)) {
            return "Short";
        }
        if (this.stringClassData.equals(type)) {
            return "String";
        }
        if (this.voidClassData.equals(type)) {
            return "void";
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String toObject(JavonMapping mapping, ClassData type, String variable) {
        if (this.booleanClassData.equals(type)) {
            return "new Boolean(" + variable + ")";
        }
        if (this.byteClassData.equals(type)) {
            return "new Byte(" + variable + ")";
        }
        if (this.charClassData.equals(type)) {
            return "new Character(" + variable + ")";
        }
        if (this.intClassData.equals(type)) {
            return "new Integer(" + variable + ")";
        }
        if (this.longClassData.equals(type)) {
            return "new Long(" + variable + ")";
        }
        if (this.shortClassData.equals(type)) {
            return "new Short(" + variable + ")";
        }
        if (this.stringClassData.equals(type)) {
            return "(String)" + variable;
        }
        if (this.voidClassData.equals(type)) {
            return "void";
        }
        if (this.BooleanClassData.equals(type)) {
            return "(Boolean)" + variable;
        }
        if (this.ByteClassData.equals(type)) {
            return "(Byte)" + variable;
        }
        if (this.CharClassData.equals(type)) {
            return "(Character)" + variable;
        }
        if (this.IntClassData.equals(type)) {
            return "(Integer)" + variable;
        }
        if (this.LongClassData.equals(type)) {
            return "(Long)" + variable;
        }
        if (this.ShortClassData.equals(type)) {
            return "(Short)" + variable;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String fromObject(JavonMapping mapping, ClassData type, String object) {
        if (this.booleanClassData.equals(type)) {
            return "((Boolean)" + object + ").booleanValue()";
        }
        if (this.byteClassData.equals(type)) {
            return "((Byte)" + object + ").byteValue()";
        }
        if (this.charClassData.equals(type)) {
            return "((Character)" + object + ").charValue()";
        }
        if (this.intClassData.equals(type)) {
            return "((Integer)" + object + ").intValue()";
        }
        if (this.longClassData.equals(type)) {
            return "((Long)" + object + ").longValue()";
        }
        if (this.shortClassData.equals(type)) {
            return "((Short)" + object + ").shortValue()";
        }
        if (this.stringClassData.equals(type)) {
            return "(String)" + object;
        }
        if (this.voidClassData.equals(type)) {
            return "void";
        }
        if (this.BooleanClassData.equals(type)) {
            return "(Boolean)" + object;
        }
        if (this.ByteClassData.equals(type)) {
            return "(Byte)" + object;
        }
        if (this.CharClassData.equals(type)) {
            return "(Character)" + object;
        }
        if (this.IntClassData.equals(type)) {
            return "(Integer)" + object;
        }
        if (this.LongClassData.equals(type)) {
            return "(Long)" + object;
        }
        if (this.ShortClassData.equals(type)) {
            return "(Short)" + object;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String toStream(JavonMapping mapping, ClassData type, String stream, String object) {
        if (this.booleanClassData.equals(type)) {
            return stream + ".writeBoolean(" + object + ");";
        }
        if (this.byteClassData.equals(type)) {
            return stream + ".writeByte(" + object + ");";
        }
        if (this.charClassData.equals(type)) {
            return stream + ".writeChar(" + object + ");";
        }
        if (this.intClassData.equals(type)) {
            return stream + ".writeInt(" + object + ");";
        }
        if (this.longClassData.equals(type)) {
            return stream + ".writeLong(" + object + ");";
        }
        if (this.shortClassData.equals(type)) {
            return stream + ".writeShort(" + object + ");";
        }
        if (this.stringClassData.equals(type)) {
            return stream + ".writeUTF(" + this.fromObject(mapping, type, object) + ");";
        }
        if (this.voidClassData.equals(type)) {
            throw new IllegalArgumentException("Void object is not serializable");
        }
        if (this.BooleanClassData.equals(type)) {
            return stream + ".writeBoolean(" + this.fromObject(mapping, this.booleanClassData, object) + ");";
        }
        if (this.ByteClassData.equals(type)) {
            return stream + ".writeByte(" + this.fromObject(mapping, this.byteClassData, object) + ");";
        }
        if (this.CharClassData.equals(type)) {
            return stream + ".writeChar(" + this.fromObject(mapping, this.charClassData, object) + ");";
        }
        if (this.IntClassData.equals(type)) {
            return stream + ".writeInt(" + this.fromObject(mapping, this.intClassData, object) + ");";
        }
        if (this.LongClassData.equals(type)) {
            return stream + ".writeLong(" + this.fromObject(mapping, this.longClassData, object) + ");";
        }
        if (this.ShortClassData.equals(type)) {
            return stream + ".writeShort(" + this.fromObject(mapping, this.shortClassData, object) + ");";
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String fromStream(JavonMapping mapping, ClassData type, String stream, String object) {
        String result = "";
        if (object != null) {
            result = object + " = ";
        }
        if (this.voidClassData.equals(type)) {
            return object + " = _;";
        }
        if (this.booleanClassData.equals(type)) {
            result = result + stream + ".readBoolean()";
        } else if (this.BooleanClassData.equals(type)) {
            result = result + this.toObject(mapping, this.booleanClassData, stream + ".readBoolean()");
        } else if (this.byteClassData.equals(type)) {
            result = result + stream + ".readByte()";
        } else if (this.ByteClassData.equals(type)) {
            result = result + this.toObject(mapping, this.byteClassData, stream + ".readByte()");
        } else if (this.charClassData.equals(type)) {
            result = result + stream + ".readChar()";
        } else if (this.CharClassData.equals(type)) {
            result = result + this.toObject(mapping, this.charClassData, stream + ".readChar()");
        } else if (this.intClassData.equals(type)) {
            result = result + stream + ".readInt()";
        } else if (this.IntClassData.equals(type)) {
            result = result + this.toObject(mapping, this.intClassData, stream + ".readInt()");
        } else if (this.longClassData.equals(type)) {
            result = result + stream + ".readLong()";
        } else if (this.LongClassData.equals(type)) {
            result = result + this.toObject(mapping, this.longClassData, stream + ".readLong()");
        } else if (this.shortClassData.equals(type)) {
            result = result + stream + ".readShort()";
        } else if (this.ShortClassData.equals(type)) {
            result = result + this.toObject(mapping, this.shortClassData, stream + ".readShort()");
        } else if (this.stringClassData.equals(type)) {
            result = result + stream + ".readUTF()";
        }
        if ("".equals(result)) {
            throw new IllegalArgumentException("Invalid type: " + type.getName());
        }
        if (object != null) {
            result = result + ";";
        }
        return result;
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData rootClassData, Set<ClassData> usedTypes) {
        return Collections.singleton(rootClassData);
    }
}

