/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.java.editor.overridden.ComputeOverriders;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenPopup;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class GoToImplementation
extends BaseAction {
    private static Set<ElementKind> SUPPORTED_ELEMENTS = EnumSet.of(ElementKind.METHOD, ElementKind.ANNOTATION_TYPE, ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE);

    public GoToImplementation() {
        super(132);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        GoToImplementation.goToImplementation(jTextComponent);
    }

    public static void goToImplementation(final JTextComponent jTextComponent) {
        try {
            JavaSource.forDocument((Document)jTextComponent.getDocument()).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    List<ElementDescription> list;
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    GoToSupport.Context context = GoToSupport.resolveContext((CompilationInfo)compilationController, jTextComponent.getDocument(), jTextComponent.getCaretPosition(), false);
                    if (context == null || !SUPPORTED_ELEMENTS.contains((Object)context.resolved.getKind())) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToImplementation.class, (String)"LBL_NoMethod"));
                        return;
                    }
                    Element element = context.resolved;
                    TypeElement typeElement = element.getKind() == ElementKind.METHOD ? (TypeElement)element.getEnclosingElement() : (TypeElement)element;
                    ExecutableElement executableElement = element.getKind() == ElementKind.METHOD ? (ExecutableElement)element : null;
                    Map<ElementHandle<? extends Element>, List<ElementDescription>> map = new ComputeOverriders(new AtomicBoolean()).process((CompilationInfo)compilationController, typeElement, executableElement, true);
                    List<ElementDescription> list2 = list = map != null ? map.get(ElementHandle.create((Element)element)) : null;
                    if (list == null || list.isEmpty()) {
                        String string = element.getKind() == ElementKind.METHOD ? "LBL_NoOverridingMethod" : "LBL_NoOverridingType";
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToImplementation.class, (String)string));
                        return;
                    }
                    Point point = new Point(jTextComponent.modelToView(jTextComponent.getCaretPosition()).getLocation());
                    SwingUtilities.convertPointToScreen(point, jTextComponent);
                    GoToImplementation.performGoToAction(list, point, executableElement != null);
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    static void performGoToAction(List<ElementDescription> list, Point point, boolean bl) {
        String string = NbBundle.getMessage(GoToImplementation.class, (String)(bl ? "LBL_ImplementorsOverridersMethod" : "LBL_ImplementorsOverridersClass"));
        PopupUtil.showPopup(new IsOverriddenPopup(string, list), string, point.x, point.y, true, 0);
    }
}

