/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Set;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;

final class HelpersFinder {
    private static final MethodInfo[] APPLICABLE_METHODS = new MethodInfo[]{new MethodInfo("helper", "Helper"), new MethodInfo("cache_sweeper")};
    private final RubyIndex index;
    private final SymbolNode closest;
    private final Node root;
    private final AstPath path;

    public HelpersFinder(RubyIndex index, SymbolNode closest, Node root, AstPath path) {
        this.index = index;
        this.closest = closest;
        this.root = root;
        this.path = path;
    }

    private MethodInfo getMethodInfo(Node node) {
        if (!AstUtilities.isCall(node)) {
            return null;
        }
        for (MethodInfo each : APPLICABLE_METHODS) {
            if (!AstUtilities.isNodeNameIn(node, each.name)) continue;
            return each;
        }
        return null;
    }

    private MethodInfo getMethodInfo() {
        MethodInfo result = null;
        for (Node child : this.closest.childNodes()) {
            result = this.getMethodInfo(child);
            if (result == null) continue;
            return result;
        }
        result = this.getMethodInfo(this.path.leafParent());
        if (result == null) {
            result = this.getMethodInfo(this.path.leafGrandParent());
        }
        return result;
    }

    private String getClassName(MethodInfo methodInfo) {
        String className = AstUtilities.getName((Node)this.closest);
        if (className.length() == 0) {
            return null;
        }
        return methodInfo.getClassName(RubyUtils.underlinedNameToCamel(className));
    }

    DeclarationFinder.DeclarationLocation findHelperLocation() {
        MethodInfo methodInfo = this.getMethodInfo();
        if (methodInfo == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        String className = this.getClassName(methodInfo);
        if (className == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        Set<IndexedClass> result = this.index.getClasses(className, QuerySupport.Kind.EXACT, true, false, false);
        if (result.isEmpty()) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        return RubyDeclarationFinder.getLocation(result);
    }

    private static class MethodInfo {
        private final String name;
        private final String suffix;

        public MethodInfo(String name) {
            this(name, "");
        }

        public MethodInfo(String name, String suffix) {
            this.name = name;
            this.suffix = suffix;
        }

        public String getClassName(String className) {
            return className + this.suffix;
        }
    }
}

