/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SQLHistoryPersistenceManager {
    private static final int READ = 0;
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final int CREATE = 3;
    public static final Logger LOGGER = Logger.getLogger(SQLHistoryPersistenceManager.class.getName());
    private static SQLHistoryPersistenceManager _instance = null;
    private static Document document;
    private List<SQLHistory> sqlHistoryList;
    private int numElemsToRemove = 0;

    private SQLHistoryPersistenceManager() {
    }

    public static SQLHistoryPersistenceManager getInstance() {
        if (null == _instance) {
            _instance = new SQLHistoryPersistenceManager();
        }
        return _instance;
    }

    public void removeHistoryFile(FileObject historyRoot) {
        try {
            FileObject folder = DataFolder.findFolder((FileObject)historyRoot).getPrimaryFile();
            String fn = FileUtil.getFileDisplayName((FileObject)folder) + File.separator + "sql_history.xml";
            FileObject historyFo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(fn)));
            historyFo.delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void create(FileObject historyFileObject, List<SQLHistory> sqlHistoryList) throws SQLHistoryException {
        try {
            this.sqlHistoryList = sqlHistoryList;
            DataFolder df = DataFolder.findFolder((FileObject)historyFileObject);
            int action = df.getChildren().length == 0 ? 3 : 1;
            AtomicFileAction writer = new AtomicFileAction(df, null, action, sqlHistoryList);
            df.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)writer);
        }
        catch (IOException ex) {
            throw new SQLHistoryException(ex.getLocalizedMessage(), ex);
        }
    }

    public List<SQLHistory> retrieve(FileObject historyFileObject) throws ClassNotFoundException, SQLHistoryException {
        int limit;
        Handler handler = null;
        String limitUser = NbPreferences.forModule(SQLHistoryPersistenceManager.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", "");
        if (!limitUser.isEmpty()) {
            try {
                limit = Integer.parseInt(limitUser);
            }
            catch (NumberFormatException nfe) {
                limit = Integer.parseInt("100");
            }
        } else {
            limit = Integer.parseInt("100");
        }
        try {
            handler = new Handler(limit);
            DataFolder df = DataFolder.findFolder((FileObject)historyFileObject);
            AtomicFileAction reader = new AtomicFileAction(df, handler, 0, null);
            df.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)reader);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, ex.getLocalizedMessage(), ex);
            this.sqlHistoryList = handler.getXmlSqlHistoryList();
            throw new SQLHistoryException();
        }
        if (handler != null) {
            return handler.getXmlSqlHistoryList();
        }
        return new ArrayList<SQLHistory>();
    }

    public List<SQLHistory> retrieve() {
        return this.sqlHistoryList;
    }

    public void setNumElemsToRemove(int elemsToRemove) {
        this.numElemsToRemove = elemsToRemove;
    }

    public int getNumElemsToRemove() {
        return this.numElemsToRemove;
    }

    public List<SQLHistory> updateSQLSaved(int limit, FileObject historyFileObject) throws SQLHistoryException {
        List<SQLHistory> updatedSQLHistoryList = null;
        try {
            if (historyFileObject == null) {
                return new ArrayList<SQLHistory>();
            }
            updatedSQLHistoryList = this.retrieve(historyFileObject);
            if (limit < updatedSQLHistoryList.size()) {
                this.numElemsToRemove = updatedSQLHistoryList.size() - limit;
                boolean containsElems = true;
                boolean bl = containsElems = !updatedSQLHistoryList.isEmpty();
                if (containsElems && this.numElemsToRemove == updatedSQLHistoryList.size()) {
                    DataFolder df = DataFolder.findFolder((FileObject)historyFileObject);
                    List<SQLHistory> emptyList = Collections.emptyList();
                    AtomicFileAction writer = new AtomicFileAction(df, null, 3, emptyList);
                    df.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)writer);
                } else if (containsElems && (limit == 0 || this.numElemsToRemove >= 0)) {
                    DataFolder df = DataFolder.findFolder((FileObject)historyFileObject);
                    AtomicFileAction modifier = new AtomicFileAction(df, null, 2, updatedSQLHistoryList);
                    df.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)modifier);
                }
            }
            updatedSQLHistoryList = this.retrieve(historyFileObject);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLHistoryException(ex.getLocalizedMessage(), ex);
        }
        catch (IOException ex) {
            throw new SQLHistoryException(ex.getLocalizedMessage(), ex);
        }
        return updatedSQLHistoryList;
    }

    private static final class Handler
    extends DefaultHandler
    implements ContentHandler {
        private static final String ELEMENT_SQL = "sql";
        private static final String ATTR_URL_PROPERTY_VALUE = "url";
        private static final String ATTR_DATE_PROPERTY_VALUE = "date";
        private static String url;
        private static StringBuilder sql;
        private static Date date;
        boolean matchingUrl = false;
        private List<SQLHistory> xmlSqlHistoryList = new ArrayList<SQLHistory>();
        static boolean isSql;
        private int limit;
        private static Calendar calendar;

        public Handler(int limit) {
            this.limit = limit;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (ELEMENT_SQL.equals(qName)) {
                isSql = true;
                url = attrs.getValue(ATTR_URL_PROPERTY_VALUE);
                try {
                    calendar.setTimeInMillis(Long.parseLong(attrs.getValue(ATTR_DATE_PROPERTY_VALUE)));
                    date = calendar.getTime();
                }
                catch (NumberFormatException nfe) {
                    try {
                        date = DateFormat.getDateTimeInstance(3, 3).parse(attrs.getValue(ATTR_DATE_PROPERTY_VALUE));
                    }
                    catch (ParseException pe) {
                        date = calendar.getTime();
                    }
                }
            } else {
                isSql = false;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (ELEMENT_SQL.equals(qName) && url != null && sql != null && date != null) {
                this.addHistory(url, sql.toString(), date);
                Handler.reset();
            }
        }

        private static void reset() {
            url = null;
            date = null;
            sql = null;
        }

        private void addHistory(String url, String sql, Date date) {
            if (this.xmlSqlHistoryList.size() <= this.limit || this.limit == 0) {
                this.xmlSqlHistoryList.add(new SQLHistory(url, sql, date));
                this.setXmlSqlHistoryList(this.xmlSqlHistoryList);
            } else {
                this.xmlSqlHistoryList.remove(this.xmlSqlHistoryList.size() - 1);
            }
        }

        @Override
        public void characters(char[] buf, int offset, int length) {
            if (isSql) {
                String parsedValue = new String(buf, offset, length);
                if (sql == null) {
                    sql = new StringBuilder();
                    sql.append(parsedValue);
                } else {
                    sql.append(parsedValue);
                }
            }
        }

        public void setXmlSqlHistoryList(List<SQLHistory> sqlHistoryList) {
            this.xmlSqlHistoryList = sqlHistoryList;
        }

        public List<SQLHistory> getXmlSqlHistoryList() {
            if (this.xmlSqlHistoryList == null) {
                return new ArrayList<SQLHistory>();
            }
            return this.xmlSqlHistoryList;
        }

        static {
            isSql = false;
            calendar = Calendar.getInstance();
        }
    }

    private static final class XmlWriter {
        private PrintWriter pw;
        private List<SQLHistory> sqlHistoryList;

        public XmlWriter(FileObject data, List<SQLHistory> sqlHistoryList, PrintWriter pw) {
            this.sqlHistoryList = sqlHistoryList;
            this.pw = pw;
        }

        private Node createElements(Document document) {
            Element newNode = null;
            Element nameNode = null;
            if (null == document.getDocumentElement()) {
                newNode = document.createElement("history");
                for (SQLHistory sqlHistory : this.sqlHistoryList) {
                    nameNode = document.createElement("sql");
                    nameNode.appendChild(document.createTextNode(sqlHistory.getSql()));
                    nameNode.setAttribute("url", sqlHistory.getUrl());
                    nameNode.setAttribute("date", new Long(sqlHistory.getDate().getTime()).toString());
                    newNode.appendChild(nameNode);
                }
                document.adoptNode(newNode);
            } else {
                newNode = document.getDocumentElement();
                for (SQLHistory sqlHistory : this.sqlHistoryList) {
                    nameNode = document.createElement("sql");
                    nameNode.appendChild(document.createTextNode(sqlHistory.getSql()));
                    nameNode.setAttribute("url", sqlHistory.getUrl());
                    nameNode.setAttribute("date", new Long(sqlHistory.getDate().getTime()).toString());
                    newNode.insertBefore(nameNode, newNode.getFirstChild());
                }
            }
            return newNode;
        }

        private Node removeElements(Document document) {
            NodeList nodes = null;
            Element history = document.getDocumentElement();
            if (null != history) {
                int i;
                nodes = history.getElementsByTagName("sql");
                int elemsToRemove = SQLHistoryPersistenceManager.getInstance().getNumElemsToRemove();
                if (elemsToRemove == 0) {
                    for (i = 0; i < nodes.getLength(); ++i) {
                        if (nodes.item(0) == null) continue;
                        history.removeChild(nodes.item(0));
                    }
                }
                for (i = 0; i < elemsToRemove; ++i) {
                    if (nodes.item(0) == null) continue;
                    history.removeChild(nodes.item(nodes.getLength() - 1));
                }
            }
            return history;
        }

        private void write() {
            this.pw.println("<?xml version='1.0' encoding='UTF-8' ?>");
        }

        private void write(Node node, String indent) {
            switch (node.getNodeType()) {
                case 9: {
                    Document doc = (Document)node;
                    this.pw.println(indent + "<?xml version='1.0'?>");
                    for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
                        this.write(child, indent);
                    }
                    break;
                }
                case 1: {
                    Element elt = (Element)node;
                    this.pw.print(indent + "<" + elt.getTagName());
                    NamedNodeMap attrs = elt.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node a = attrs.item(i);
                        this.pw.print(" " + a.getNodeName() + "='" + this.fixup(a.getNodeValue()) + "'");
                    }
                    this.pw.println(">");
                    String newindent = indent + "    ";
                    for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
                        this.write(child, newindent);
                    }
                    this.pw.println(indent + "</" + elt.getTagName() + ">");
                    break;
                }
                case 3: {
                    Text textNode = (Text)node;
                    String text = textNode.getData().trim();
                    if (text == null || text.length() <= 0) break;
                    this.pw.println(indent + this.fixup(text));
                    break;
                }
                default: {
                    LOGGER.log(Level.INFO, "Ignoring node: " + node.getClass().getName());
                }
            }
        }

        private String fixup(String s) {
            StringBuilder sb = new StringBuilder();
            int len = s.length();
            block7: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    default: {
                        sb.append(c);
                        continue block7;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block7;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block7;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        sb.append("&apos;");
                    }
                }
            }
            return sb.toString();
        }
    }

    private static final class AtomicFileAction
    implements FileSystem.AtomicAction {
        List<SQLHistory> sqlHistoryList;
        DataFolder parent;
        boolean remove;
        FileObject data;
        Handler handler;
        int actionType;

        AtomicFileAction(DataFolder parent, Handler handler, int actionType, List<SQLHistory> sqlHistoryList) {
            this.parent = parent;
            this.handler = handler;
            this.sqlHistoryList = sqlHistoryList;
            this.actionType = actionType;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            FileLock lck = null;
            OutputStream ostm = null;
            PrintWriter writer = null;
            XmlWriter xmlWriter = null;
            DocumentBuilderFactory factory = null;
            DocumentBuilder builder = null;
            try {
                FileObject folder = this.parent.getPrimaryFile();
                String fn = FileUtil.getFileDisplayName((FileObject)folder) + File.separator + "sql_history.xml";
                switch (this.actionType) {
                    case 0: {
                        FileObject historyFo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(fn)));
                        XMLDataObject obj = (XMLDataObject)XMLDataObject.find((FileObject)historyFo);
                        InputSource inputSource = new InputSource(obj.getPrimaryFile().getInputStream());
                        inputSource.setSystemId(historyFo.getURL().toExternalForm());
                        XMLReader reader = XMLUtil.createXMLReader();
                        reader.setContentHandler(this.handler);
                        reader.setErrorHandler(this.handler);
                        reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                        reader.parse(inputSource);
                        return;
                    }
                    case 1: {
                        factory = DocumentBuilderFactory.newInstance();
                        builder = factory.newDocumentBuilder();
                        this.data = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(fn)));
                        InputStream inputStream = this.data.getInputStream();
                        document = builder.parse(inputStream);
                        inputStream.close();
                        lck = this.data.lock();
                        ostm = this.data.getOutputStream(lck);
                        writer = new PrintWriter(new OutputStreamWriter(ostm, "UTF8"));
                        xmlWriter = new XmlWriter(this.data, this.sqlHistoryList, writer);
                        xmlWriter.write(xmlWriter.createElements(document), "");
                        return;
                    }
                    case 3: {
                        factory = DocumentBuilderFactory.newInstance();
                        builder = factory.newDocumentBuilder();
                        this.data = new File(fn).exists() ? folder.getFileObject("sql_history.xml") : folder.createData("sql_history.xml");
                        lck = this.data.lock();
                        ostm = this.data.getOutputStream(lck);
                        writer = new PrintWriter(new OutputStreamWriter(ostm, "UTF8"));
                        document = builder.newDocument();
                        xmlWriter = new XmlWriter(this.data, this.sqlHistoryList, writer);
                        xmlWriter.write();
                        xmlWriter = new XmlWriter(this.data, this.sqlHistoryList, writer);
                        xmlWriter.write(xmlWriter.createElements(document), "");
                        return;
                    }
                    case 2: {
                        factory = DocumentBuilderFactory.newInstance();
                        builder = factory.newDocumentBuilder();
                        if (folder.getChildren().length > 0) {
                            this.data = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(fn)));
                            InputStream is = this.data.getInputStream();
                            document = builder.parse(is);
                            is.close();
                            lck = this.data.lock();
                            ostm = this.data.getOutputStream(lck);
                            writer = new PrintWriter(new OutputStreamWriter(ostm, "UTF8"));
                        }
                        xmlWriter = new XmlWriter(this.data, this.sqlHistoryList, writer);
                        xmlWriter.write();
                        xmlWriter.write(xmlWriter.removeElements(document), "");
                        return;
                    }
                }
                return;
            }
            catch (ParserConfigurationException ex) {
                LOGGER.log(Level.INFO, ex.getMessage());
                throw new IOException(ex.getLocalizedMessage(), ex);
            }
            catch (SAXException ex) {
                LOGGER.log(Level.INFO, ex.getMessage());
                throw new IOException(ex.getLocalizedMessage(), ex);
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                    writer = null;
                }
                if (ostm != null) {
                    ostm.close();
                    ostm = null;
                }
                if (lck != null) {
                    lck.releaseLock();
                }
            }
        }
    }
}

