/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.debugger.RubyDebuggerActionProvider;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.spi.RubyDebuggerImplementation;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerFactory;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

public final class RubyDebugger
implements RubyDebuggerImplementation {
    private static final Logger LOGGER = Logger.getLogger(RubyDebugger.class.getName());
    private static final String PATH_TO_CLASSIC_DEBUG_DIR;
    private RubyExecutionDescriptor descriptor;
    private RubySession rubySession;
    private static final LineConvertors.FileLocator DUMMY_FILE_LOCATOR;
    private static final String CLASSIC_DEBUGGER_PATH = "ruby/debug-commons-0.9.5/classic-debug.rb";

    public void describeProcess(RubyExecutionDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean prepare() {
        if (this.descriptor.getPlatform().isRubinius()) {
            return false;
        }
        if (!RubyDebugger.checkAndTuneSettings(this.descriptor)) {
            return false;
        }
        RubyPlatform platform = this.descriptor.getPlatform();
        if (!platform.hasFastDebuggerInstalled() && PATH_TO_CLASSIC_DEBUG_DIR == null) {
            LOGGER.severe("Cannot locate classic debugger in NetBeans Ruby cluster (ruby/debug-commons-0.9.5/classic-debug.rb). Neither fast debugger is available. Cannot debug.");
            return false;
        }
        return true;
    }

    public Process debug() {
        try {
            this.rubySession = RubyDebugger.startDebugging(this.descriptor);
            if (this.rubySession != null) {
                this.rubySession.getProxy().attach((IRubyBreakpoint[])RubyBreakpointManager.getBreakpoints());
                return this.rubySession.getProxy().getDebugTarget().getProcess();
            }
            throw new IllegalStateException("Unable to create Ruby debugging session");
        }
        catch (IOException e) {
            this.getFinishAction().run();
            throw new RuntimeException(e);
        }
        catch (RubyDebuggerException e) {
            this.getFinishAction().run();
            throw new RuntimeException(e);
        }
    }

    public void attach(String host, int port, int timeout) {
        assert (!EventQueue.isDispatchThread()) : "do not call attach from EDT";
        try {
            RubyDebuggerProxy proxy = new RubyDebuggerProxy(RubyDebuggerProxy.RUBY_DEBUG, timeout);
            RubyDebuggerProxy.PROXIES.add(proxy);
            RubyDebugTarget debugTarget = new RubyDebugTarget(proxy, host, port);
            proxy.setDebugTarget(debugTarget);
            this.rubySession = RubyDebugger.intializeIDEDebuggerEngine(proxy, DUMMY_FILE_LOCATOR);
            proxy.attach((IRubyBreakpoint[])RubyBreakpointManager.getBreakpoints());
        }
        catch (IOException e) {
            this.getFinishAction().run();
            RubyDebugger.problemOccurred(e);
        }
        catch (RubyDebuggerException e) {
            this.getFinishAction().run();
            RubyDebugger.problemOccurred((Exception)((Object)e));
        }
    }

    public Runnable getFinishAction() {
        return new Runnable(){

            @Override
            public void run() {
                if (RubyDebugger.this.rubySession != null) {
                    RubyDebugger.this.rubySession.getActionProvider().doAction(ActionsManager.ACTION_KILL);
                    RubyDebugger.this.rubySession = null;
                }
            }
        };
    }

    private static void problemOccurred(Exception e) {
        String message = NbBundle.getMessage(RubyDebugger.class, (String)"RubyDebugger.startup.problem", (Object)e.getLocalizedMessage());
        LOGGER.log(Level.INFO, message, e);
        Util.showWarning(message);
    }

    static RubySession startDebugging(RubyExecutionDescriptor descriptor) throws IOException, RubyDebuggerException {
        RubyDebuggerProxy proxy;
        RubyPlatform platform = descriptor.getPlatform();
        boolean jrubySet = platform.isJRuby();
        RubyDebuggerFactory.Descriptor debugDesc = new RubyDebuggerFactory.Descriptor();
        debugDesc.useDefaultPort(false);
        debugDesc.setJRuby(jrubySet);
        debugDesc.setDebuggeePath(descriptor.getScript());
        if (descriptor.useInterpreter()) {
            ArrayList<String> additionalOptions = new ArrayList<String>();
            if (descriptor.getInitialArgs() != null) {
                additionalOptions.addAll(Arrays.asList(descriptor.getInitialArgs()));
            }
            if (jrubySet && descriptor.getJVMArguments() != null) {
                for (String jvmArg : descriptor.getJVMArguments()) {
                    additionalOptions.add("-J" + jvmArg);
                }
            }
            if (!additionalOptions.isEmpty()) {
                debugDesc.setAdditionalOptions(additionalOptions);
            }
        }
        debugDesc.setScriptArguments(descriptor.getAdditionalArgs());
        debugDesc.setSynchronizedOutput(true);
        if (descriptor.getPwd() != null) {
            debugDesc.setBaseDirectory(descriptor.getPwd());
        }
        HashMap<String, String> env = new HashMap<String, String>();
        GemManager.adjustEnvironment((RubyPlatform)platform, env);
        if (descriptor.getAdditionalEnvironment() != null) {
            env.putAll(descriptor.getAdditionalEnvironment());
        }
        if (jrubySet) {
            env.putAll(RubyDebugger.getJRubyEnvironment(descriptor));
        }
        debugDesc.setEnvironment(env);
        int timeout = Integer.getInteger("org.netbeans.modules.ruby.debugger.timeout", 15);
        LOGGER.finer("Using timeout: " + timeout + 's');
        String interpreter = platform.getInterpreter();
        if (!platform.hasFastDebuggerInstalled()) {
            assert (PATH_TO_CLASSIC_DEBUG_DIR != null) : "PATH_TO_CLASSIC_DEBUG_DIR should be checked before";
            LOGGER.fine("Running classic(slow) debugger...");
            proxy = RubyDebuggerFactory.startClassicDebugger((RubyDebuggerFactory.Descriptor)debugDesc, (String)PATH_TO_CLASSIC_DEBUG_DIR, (String)interpreter, (int)timeout);
        } else {
            String version = platform.getLatestAvailableValidRDebugIDEVersions();
            debugDesc.setRubyDebugIDEVersion(version);
            LOGGER.fine("Running fast debugger...");
            File rDebugF = new File(Util.findRDebugExecutable(platform));
            if (descriptor.useInterpreter()) {
                proxy = RubyDebuggerFactory.startRubyDebug((RubyDebuggerFactory.Descriptor)debugDesc, (String)rDebugF.getAbsolutePath(), (String)interpreter, (int)timeout);
            } else {
                ArrayList<String> cmd = new ArrayList<String>(20);
                cmd.add(descriptor.getCmd().getAbsolutePath());
                assert (jrubySet) : "jruby is used";
                if (descriptor.getJVMArguments() != null) {
                    cmd.addAll(Arrays.asList(descriptor.getJVMArguments()));
                }
                cmd.addAll(Arrays.asList(descriptor.getInitialArgs()));
                proxy = RubyDebuggerFactory.startRubyDebug((RubyDebuggerFactory.Descriptor)debugDesc, cmd, (String)rDebugF.getAbsolutePath(), (int)timeout);
            }
        }
        return RubyDebugger.intializeIDEDebuggerEngine(proxy, descriptor.getFileLocator());
    }

    private static Map<String, String> getJRubyEnvironment(RubyExecutionDescriptor descriptor) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (descriptor.getClassPath() != null) {
            env.put("CLASSPATH", ExecutionUtils.getExtraClassPath((String)descriptor.getClassPath()));
        }
        return env;
    }

    static boolean checkAndTuneSettings(RubyExecutionDescriptor descriptor) {
        Util.FastDebugInstallationResult result;
        RubyPlatform platform = descriptor.getPlatform();
        if (platform.isRubinius()) {
            return false;
        }
        assert (platform.isValid()) : platform + " is a valid platform";
        boolean jrubySet = platform.isJRuby();
        boolean fastDebuggerRequired = descriptor.isFastDebugRequired();
        if (!(jrubySet || (result = Util.offerToInstallFastDebugger(platform)) != Util.FastDebugInstallationResult.CANCELLED && result != Util.FastDebugInstallationResult.FAILED)) {
            return false;
        }
        if (fastDebuggerRequired && (result = Util.ensureRubyDebuggerIsPresent(platform, true, "RubyDebugger.wrong.fast.debugger.required")) != Util.FastDebugInstallationResult.INSTALLED) {
            if (jrubySet) {
                Util.showMessage(NbBundle.getMessage(RubyDebugger.class, (String)"RubyDebugger.instructionsToInstallJRubyDebugger", (Object)platform.getFastDebuggerProblemsInHTML()));
            }
            return false;
        }
        if (platform.hasFastDebuggerInstalled()) {
            result = Util.ensureRubyDebuggerIsPresent(platform, true, "RubyDebugger.requiredMessage");
            if (result != Util.FastDebugInstallationResult.INSTALLED) {
                return false;
            }
            String rDebugPath = Util.findRDebugExecutable(platform);
            if (rDebugPath == null) {
                Util.showMessage(NbBundle.getMessage(RubyDebugger.class, (String)"RubyDebugger.wrong.rdebug-ide", (Object)platform.getInfo().getLongDescription(), (Object)platform.getInterpreter(), (Object)Util.rdebugPattern()));
                return false;
            }
        }
        return true;
    }

    private static RubySession intializeIDEDebuggerEngine(RubyDebuggerProxy proxy, LineConvertors.FileLocator fileLocator) {
        RubySession rubySession = new RubySession(proxy, fileLocator);
        SessionProvider sp = rubySession.createSessionProvider();
        DebuggerInfo di = DebuggerInfo.create((String)"RubyDebuggerInfo", (Object[])new Object[]{sp, rubySession});
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine[] de = dm.startDebugging(di);
        assert (de.length == 1) : "one debugger engine";
        Session session = (Session)de[0].lookupFirst(null, Session.class);
        assert (session != null) : "non-null Session in the lookup";
        rubySession.setSession(session);
        RubyDebuggerActionProvider provider = (RubyDebuggerActionProvider)((Object)de[0].lookupFirst(null, RubyDebuggerActionProvider.class));
        assert (provider != null);
        rubySession.setActionProvider(provider);
        proxy.addRubyDebugEventListener((RubyDebugEventListener)provider);
        return rubySession;
    }

    static {
        DUMMY_FILE_LOCATOR = new LineConvertors.FileLocator(){

            public FileObject find(String filename) {
                return null;
            }
        };
        File classicDebug = InstalledFileLocator.getDefault().locate(CLASSIC_DEBUGGER_PATH, "org.netbeans.modules.ruby.debugger", false);
        PATH_TO_CLASSIC_DEBUG_DIR = classicDebug == null || !classicDebug.isFile() ? null : classicDebug.getParentFile().getAbsolutePath();
    }
}

