/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.templates;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javacard.templates.ServletDeploymentWizardPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ServletDeploymentVisualPanel
extends JPanel
implements DocumentListener,
ActionListener {
    private ServletDeploymentWizardPanel wizardPanel;
    private JCheckBox addInfoCheckBox;
    private JTextField classNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField servletNameTextField;
    private JTextField urlPatternTextField;

    ServletDeploymentVisualPanel(ServletDeploymentWizardPanel wizardPanel) {
        this.initComponents();
        this.wizardPanel = wizardPanel;
        this.servletNameTextField.getDocument().addDocumentListener(this);
        this.urlPatternTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_wizard_deployment");
    }

    void setClassName(String className) {
        String oldClassName = this.classNameTextField.getText();
        boolean update = oldClassName != null && !oldClassName.equals("");
        this.classNameTextField.setText(className);
        if (update) {
            String oldText = this.servletNameTextField.getText();
            if (oldText.startsWith(oldClassName)) {
                this.servletNameTextField.setText(className + oldText.substring(oldClassName.length()));
            }
            if ((oldText = this.urlPatternTextField.getText()).startsWith("/" + oldClassName)) {
                this.urlPatternTextField.setText("/" + className + oldText.substring(oldClassName.length() + 1));
            }
        } else {
            this.servletNameTextField.setText(className);
            this.urlPatternTextField.setText("/" + className);
        }
    }

    String getServletName() {
        return this.servletNameTextField.getText();
    }

    String getUrlPattern() {
        return this.urlPatternTextField.getText();
    }

    boolean isAddInfoSelected() {
        return this.addInfoCheckBox.isSelected();
    }

    private void initComponents() {
        this.addInfoCheckBox = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.classNameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.servletNameTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.urlPatternTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.addInfoCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.addInfoCheckBox, (String)NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_add_to_web_descr"));
        this.addInfoCheckBox.addActionListener(this);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_class_name"));
        this.classNameTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_servlet_name"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_url_pattern"));
        this.urlPatternTextField.addActionListener(this);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"<html>Register the Servlet with the application by giving the URL Pattern(s)</html>");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jLabel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.addInfoCheckBox).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.jLabel3).add((Component)this.jLabel2)).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.classNameTextField, -1, 321, Short.MAX_VALUE).add((Component)this.servletNameTextField, -1, 317, Short.MAX_VALUE).add((Component)this.urlPatternTextField, -1, 321, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(18, 18, 18).add((Component)this.addInfoCheckBox).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.classNameTextField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.servletNameTextField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.urlPatternTextField, -2, -1, -2)).addContainerGap(103, Short.MAX_VALUE)));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addInfoCheckBox) {
            this.addInfoCheckBoxActionPerformed(evt);
        } else if (evt.getSource() == this.urlPatternTextField) {
            this.urlPatternTextFieldActionPerformed(evt);
        }
    }

    private void urlPatternTextFieldActionPerformed(ActionEvent evt) {
    }

    private void addInfoCheckBoxActionPerformed(ActionEvent evt) {
        this.servletNameTextField.setEditable(this.addInfoCheckBox.isSelected());
        this.urlPatternTextField.setEditable(this.addInfoCheckBox.isSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textsUpdated(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textsUpdated(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textsUpdated(e);
    }

    private void textsUpdated(DocumentEvent e) {
        this.wizardPanel.fireChangeEvent();
        if (this.servletNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("servletName", null, this.getServletName());
        }
        if (this.urlPatternTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("urlPattern", null, this.getUrlPattern());
        }
    }
}

