/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.awt.Point;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;

public class SceneListAdapter
implements ListModel,
SceneListener {
    private Scene scene;
    private ArrayList listeners = new ArrayList();

    public SceneListAdapter(Scene scene) {
        this.scene = scene;
        this.scene.addSceneListener(this);
    }

    @Override
    public int getSize() {
        return this.scene.getLayerCount();
    }

    public Object getElementAt(int n) {
        return this.scene.getLayerAt(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    @Override
    public void layerAdded(Scene scene, Layer layer, int n) {
        ListDataEvent listDataEvent = new ListDataEvent(scene, 1, n, n);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    @Override
    public void layerRemoved(Scene scene, Layer layer, Scene.LayerInfo layerInfo, int n) {
        ListDataEvent listDataEvent = new ListDataEvent(scene, 2, n, n);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.intervalRemoved(listDataEvent);
        }
    }

    public void layerModified(Scene scene, Layer layer) {
        int n = scene.indexOf(layer);
        ListDataEvent listDataEvent = new ListDataEvent(scene, 0, n, n);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    @Override
    public void layerMoved(Scene scene, Layer layer, int n, int n2) {
        this.layerModified(scene, layer);
    }

    @Override
    public void layerLockChanged(Scene scene, Layer layer, boolean bl) {
        this.layerModified(scene, layer);
    }

    @Override
    public void layerPositionChanged(Scene scene, Layer layer, Point point, Point point2, boolean bl) {
        this.layerModified(scene, layer);
    }

    @Override
    public void layerVisibilityChanged(Scene scene, Layer layer, boolean bl) {
        this.layerModified(scene, layer);
    }
}

