/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.MainProjectIterator;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

public class MainProjectScanningScope
extends TaskScanningScope
implements PropertyChangeListener {
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;
    private Project currentProject;
    private Map<String, String> scopeLabels = Collections.synchronizedMap(new HashMap(3));
    private Timer refreshTimer;

    private MainProjectScanningScope(String displayName, String description, Image icon) {
        super(displayName, description, icon);
        this.extractLabelsFromProject(null, this.scopeLabels);
        this.lookupContent.add(this.scopeLabels);
    }

    public static MainProjectScanningScope create() {
        return new MainProjectScanningScope(NbBundle.getBundle(MainProjectScanningScope.class).getString("LBL_MainProjectScope"), NbBundle.getBundle(MainProjectScanningScope.class).getString("HINT_MainProjectScope"), ImageUtilities.loadImage((String)"org/netbeans/modules/tasklist/projectint/main_project_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        return new MainProjectIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInScope(FileObject resource) {
        Project p = null;
        MainProjectScanningScope mainProjectScanningScope = this;
        synchronized (mainProjectScanningScope) {
            p = this.currentProject;
        }
        if (null == resource || null == p) {
            return false;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)resource);
        if (null == owner) {
            return false;
        }
        if (owner.equals(p)) {
            return true;
        }
        if (p.equals(OpenProjects.getDefault().getMainProject())) {
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projects.length; ++i) {
                SubprojectProvider subProjectProvider;
                if (projects[i].equals(p) || null == (subProjectProvider = (SubprojectProvider)projects[i].getLookup().lookup(SubprojectProvider.class)) || !subProjectProvider.getSubprojects().contains(p) || !projects[i].equals(owner)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        MainProjectScanningScope mainProjectScanningScope = this;
        synchronized (mainProjectScanningScope) {
            if (null == this.lookup) {
                this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
            }
        }
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(TaskScanningScope.Callback newCallback) {
        MainProjectScanningScope mainProjectScanningScope = this;
        synchronized (mainProjectScanningScope) {
            if (null != newCallback && null == this.callback) {
                OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
                Project p = OpenProjects.getDefault().getMainProject();
                if (null == p) {
                    p = MainProjectScanningScope.findCurrentProject();
                }
                this.setCurrentProject(p, false);
            } else if (null == newCallback && null != this.callback) {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
                this.setCurrentProject(null, false);
            }
            this.callback = newCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("MainProject".equals(e.getPropertyName())) {
            MainProjectScanningScope mainProjectScanningScope = this;
            synchronized (mainProjectScanningScope) {
                if (null != this.callback) {
                    Project p = OpenProjects.getDefault().getMainProject();
                    if (null == p) {
                        p = MainProjectScanningScope.findCurrentProject();
                    } else {
                        this.setCurrentProject(null, false);
                    }
                    this.setCurrentProject(p, true);
                }
            }
        } else if ("activatedNodes".equals(e.getPropertyName())) {
            if (null != this.refreshTimer) {
                this.refreshTimer.cancel();
            }
            this.refreshTimer = new Timer();
            this.refreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Project p = OpenProjects.getDefault().getMainProject();
                    if (null == p) {
                        p = MainProjectScanningScope.findCurrentProject();
                        MainProjectScanningScope.this.setCurrentProject(p, true);
                    }
                }
            }, 500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentProject(Project newProject, boolean callbackRefresh) {
        MainProjectScanningScope mainProjectScanningScope = this;
        synchronized (mainProjectScanningScope) {
            if (null == newProject && null == this.currentProject || null != this.currentProject && this.currentProject.equals(newProject)) {
                return;
            }
            if (null != this.currentProject) {
                this.lookupContent.remove((Object)this.currentProject);
            }
            if (null != newProject) {
                this.lookupContent.add((Object)newProject);
            }
            this.extractLabelsFromProject(newProject, this.scopeLabels);
            this.currentProject = newProject;
        }
        if (callbackRefresh && null != this.callback) {
            this.callback.refresh();
        }
    }

    private void extractLabelsFromProject(Project p, Map<String, String> labels) {
        labels.clear();
        if (null == p) {
            labels.put("StatusBarLabel", NbBundle.getMessage(MainProjectScanningScope.class, (String)"LBL_NoProjectStatusBar"));
        } else {
            ProjectInformation pi = ProjectUtils.getInformation((Project)p);
            if (p.equals(OpenProjects.getDefault().getMainProject())) {
                labels.put("StatusBarLabel", NbBundle.getMessage(MainProjectScanningScope.class, (String)"LBL_MainProjectStatusBar"));
            } else {
                labels.put("ShortDescription", NbBundle.getMessage(MainProjectScanningScope.class, (String)"HINT_CurrentProjectScope", (Object)pi.getDisplayName()));
                labels.put("Name", pi.getDisplayName());
                labels.put("StatusBarLabel", NbBundle.getMessage(MainProjectScanningScope.class, (String)"LBL_CurrentProjectStatusBar", (Object)pi.getDisplayName()));
            }
        }
    }

    static Project findCurrentProject() {
        Node[] nodes;
        HashSet<Project> result = new HashSet<Project>();
        for (Node n : nodes = TopComponent.getRegistry().getActivatedNodes()) {
            for (Project p : n.getLookup().lookupAll(Project.class)) {
                result.add(p);
                if (result.size() <= 1) continue;
                return null;
            }
            for (DataObject dob : n.getLookup().lookupAll(DataObject.class)) {
                FileObject fob = dob.getPrimaryFile();
                Project p = FileOwnerQuery.getOwner((FileObject)fob);
                if (p == null) continue;
                result.add(p);
                if (result.size() <= 1) continue;
                return null;
            }
        }
        return result.isEmpty() ? null : (Project)new ArrayList(result).get(0);
    }
}

