/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.Signal;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExternalTerminal
implements PropertyChangeListener {
    private final String tty;
    private final long pid;
    private File gdbHelperLog = null;
    private File gdbHelperScript = null;
    private final GdbDebugger debugger;
    private static final Logger log = Logger.getLogger("gdb.logger");
    private static final int RETRY_LIMIT = 200;

    public static String create(GdbDebugger debugger, String termpath, String[] env) throws IOException {
        return new ExternalTerminal((GdbDebugger)debugger, (String)termpath, (String[])env).tty;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExternalTerminal(GdbDebugger debugger, String termpath, String[] env) throws IOException {
        Map<String, String> map;
        this.debugger = debugger;
        debugger.addPropertyChangeListener(this);
        this.initGdbHelpers();
        TerminalProfile termProfile = this.getTermProfile(termpath);
        ProcessBuilder pb = new ProcessBuilder(termProfile.options);
        if (Utilities.getOperatingSystem() == 4096 && (map = pb.environment()).get("DISPLAY") == null) {
            String display = ":0.0";
            for (int i = 0; i < env.length; ++i) {
                if (!env[i].startsWith("DISPLAY=") || env[i].length() < 8) continue;
                display = env[i].substring(8);
            }
            map.put("DISPLAY", display);
        }
        pb.redirectErrorStream(true);
        Process process = pb.start();
        int count = 0;
        String tty_line = null;
        String pid_line = null;
        try {
            while (count++ < 200) {
                if (!termProfile.terminates) {
                    try {
                        int rc = process.exitValue();
                        String out = ProcessUtils.readProcessOutputLine((Process)process);
                        throw new IllegalStateException(NbBundle.getMessage(ExternalTerminal.class, (String)"ERR_ExternalTerminalFailedMessageDetails", (Object)Arrays.toString(termProfile.options), (Object)rc, (Object)out));
                    }
                    catch (IllegalThreadStateException e) {
                        // empty catch block
                    }
                }
                BufferedReader fromTerm = new BufferedReader(new FileReader(this.gdbHelperLog));
                tty_line = fromTerm.readLine();
                pid_line = fromTerm.readLine();
                fromTerm.close();
                if (pid_line != null) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                }
            }
            if (count >= 200) {
                log.warning("Retry limit reached for " + this.gdbHelperLog + ", giving up");
            }
        }
        catch (IOException ioe) {
            log.warning("Failed to read external terminal helper");
        }
        this.tty = tty_line;
        log.finest("ExternalTerminal: tty=" + this.tty);
        long pidTemp = 0L;
        try {
            pidTemp = Long.valueOf(pid_line);
        }
        catch (Exception ex) {
            log.warning("Error parsing pid: " + pid_line);
        }
        this.pid = pidTemp;
        log.finest("ExternalTerminal: pid=" + this.pid);
    }

    private void initGdbHelpers() {
        try {
            this.gdbHelperLog = File.createTempFile("gdb_helper_", ".log");
            this.gdbHelperScript = File.createTempFile("gdb_helper_", ".sh");
        }
        catch (IOException ex) {
            this.gdbHelperLog = new File("/tmp/gdb_helper.log");
            this.gdbHelperScript = new File("/tmp/gdb_helper.sh");
        }
        String content = NbBundle.getMessage(ExternalTerminal.class, (String)"GdbHelperScript", (Object)this.gdbHelperLog.getAbsolutePath());
        this.gdbHelperLog.deleteOnExit();
        this.gdbHelperScript.deleteOnExit();
        try {
            FileWriter fw = new FileWriter(this.gdbHelperScript);
            fw.write(content);
            fw.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            CommonTasksSupport.chmod((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)this.gdbHelperScript.getAbsolutePath(), (int)493, null).get(30L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    String getTty() {
        return this.tty;
    }

    private TerminalProfile getTermProfile(String path) {
        if (path.contains("gnome-terminal")) {
            return new TerminalProfile(false, new String[]{path, "--hide-menubar", "--disable-factory", "--command", this.gdbHelperScript.getAbsolutePath()});
        }
        if (path.contains("xterm")) {
            return new TerminalProfile(false, new String[]{path, "-e", this.gdbHelperScript.getAbsolutePath()});
        }
        return new TerminalProfile(true, new String[]{path, "-e", this.gdbHelperScript.getAbsolutePath()});
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("state")) {
            Object state = ev.getNewValue();
            if (state == GdbDebugger.State.EXITED) {
                this.gdbHelperScript.delete();
                this.gdbHelperLog.delete();
                this.debugger.removePropertyChangeListener(this);
            }
        } else if (ev.getPropertyName().equals("killTerm")) {
            if (this.pid == 0L) {
                log.warning("Killing zero pid detected from log: " + this.gdbHelperLog);
            }
            this.debugger.kill(Signal.TERM, this.pid);
        }
    }

    private static class TerminalProfile {
        private final String[] options;
        private final boolean terminates;

        private TerminalProfile(boolean terminates, String ... options) {
            this.options = options;
            this.terminates = terminates;
        }
    }
}

