/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import java.io.UnsupportedEncodingException;
import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;

public class Utf8Constant
extends Constant {
    private static final char TWO_BYTE_LIMIT = '\u0080';
    private static final int TWO_BYTE_CONSTANT1 = 192;
    private static final int TWO_BYTE_CONSTANT2 = 128;
    private static final int TWO_BYTE_SHIFT1 = 6;
    private static final int TWO_BYTE_MASK1 = 31;
    private static final int TWO_BYTE_MASK2 = 63;
    private static final char THREE_BYTE_LIMIT = '\u0800';
    private static final int THREE_BYTE_CONSTANT1 = 224;
    private static final int THREE_BYTE_CONSTANT2 = 128;
    private static final int THREE_BYTE_CONSTANT3 = 128;
    private static final int THREE_BYTE_SHIFT1 = 12;
    private static final int THREE_BYTE_SHIFT2 = 6;
    private static final int THREE_BYTE_MASK1 = 15;
    private static final int THREE_BYTE_MASK2 = 63;
    private static final int THREE_BYTE_MASK3 = 63;
    private byte[] bytes;
    private String string;

    public Utf8Constant() {
    }

    public Utf8Constant(String string) {
        this.bytes = null;
        this.string = string;
    }

    public void setBytes(byte[] byArray) {
        this.bytes = byArray;
        this.string = null;
    }

    public byte[] getBytes() {
        try {
            this.switchToByteArrayRepresentation();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        return this.bytes;
    }

    public void setString(String string) {
        this.bytes = null;
        this.string = string;
    }

    public String getString() {
        try {
            this.switchToStringRepresentation();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        return this.string;
    }

    public int getTag() {
        return 1;
    }

    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitUtf8Constant(clazz, this);
    }

    private void switchToByteArrayRepresentation() throws UnsupportedEncodingException {
        if (this.bytes == null) {
            this.bytes = this.getByteArrayRepresentation(this.string);
            this.string = null;
        }
    }

    private void switchToStringRepresentation() throws UnsupportedEncodingException {
        if (this.string == null) {
            this.string = this.getStringRepresentation(this.bytes);
            this.bytes = null;
        }
    }

    private byte[] getByteArrayRepresentation(String string) throws UnsupportedEncodingException {
        int n;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n = string.charAt(i);
            n2 += n == 0 ? 2 : (n < 128 ? 1 : (n < 2048 ? 2 : 3));
        }
        byte[] byArray = new byte[n2];
        n = 0;
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                byArray[n++] = -64;
                byArray[n++] = -128;
                continue;
            }
            if (c < '\u0080') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xE0 | c >>> 12 & 0xF);
            byArray[n++] = (byte)(0x80 | c >>> 6 & 0x3F);
            byArray[n++] = (byte)(0x80 | c & 0x3F);
        }
        return byArray;
    }

    private String getStringRepresentation(byte[] byArray) throws UnsupportedEncodingException {
        char[] cArray = new char[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2++] & 0xFF;
            try {
                cArray[n++] = (char)(n3 < 192 ? n3 : (n3 < 224 ? (n3 & 0x1F) << 6 | byArray[n2++] & 0x3F : (n3 & 0xF) << 12 | (byArray[n2++] & 0x3F) << 6 | byArray[n2++] & 0x3F));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UnsupportedEncodingException("Missing UTF-8 bytes after initial byte [0x" + Integer.toHexString(n3) + "] in string [" + new String(cArray, 0, n) + "]");
            }
        }
        return new String(cArray, 0, n);
    }
}

