/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.GotoTest;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseActionProvider;
import org.netbeans.modules.ruby.rubyproject.RubyConfigurationProvider;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunner;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.MainClassWarning;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class RubyActionProvider
extends RubyBaseActionProvider {
    public static final String COMMAND_IRB_CONSOLE = "irb-console";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "autotest", "autospec", "rdoc", "irb-console", "run", "run.single", "debug", "debug.single", "test", "rspec", "test.single", "debug.test.single", "delete", "copy", "move", "rename"};
    private static final String[] MIME_TYPES = new String[]{"text/x-ruby"};
    final RubyProject project;

    public RubyActionProvider(RubyProject project, UpdateHelper updateHelper) {
        super(project, updateHelper);
        this.project = project;
    }

    @Override
    protected FileObject[] getSourceRoots() {
        return this.project.getSourceRoots().getRoots();
    }

    @Override
    protected FileObject[] getTestSourceRoots() {
        return this.project.getTestSourceRoots().getRoots();
    }

    @Override
    protected String[] getMimeTypes() {
        return MIME_TYPES;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    @Override
    public RubyExecutionDescriptor getScriptDescriptor(File pwd, FileObject fileObject, String target, String displayName, Lookup context, boolean debug, LineConvertor ... extraConvertors) {
        RubyCoverageProvider coverageProvider;
        String rubyOptions = SharedRubyProjectProperties.getRubyOptions(this.project);
        String includePath = RubyProjectUtil.getLoadPath(this.project);
        rubyOptions = rubyOptions != null ? includePath + " " + rubyOptions : includePath;
        FileObject[] srcPath = this.project.getSourceRoots().getRoots();
        FileObject[] testPath = this.project.getTestSourceRoots().getRoots();
        target = this.locate(target, srcPath, testPath);
        if (pwd == null) {
            String runDir = this.project.evaluator().getProperty("work.dir");
            pwd = this.getSourceFolder();
            if (runDir != null && runDir.length() > 0) {
                File dir = new File(runDir);
                if (!dir.exists() && !(dir = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), runDir)).exists() && srcPath != null && srcPath.length > 0) {
                    FileObject root;
                    FileObject[] arr$ = srcPath;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && !(dir = new File(FileUtil.toFile((FileObject)(root = arr$[i$])), runDir)).exists(); ++i$) {
                    }
                }
                if (dir.exists()) {
                    pwd = dir;
                }
            }
        }
        String classPath = this.project.evaluator().getProperty("javac.classpath");
        String jvmArgs = this.project.evaluator().getProperty("jvm.args");
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(this.getPlatform(), displayName, pwd, target);
        desc.debug(debug);
        desc.showSuspended(true);
        desc.allowInput();
        desc.fileObject(fileObject);
        desc.jvmArguments(jvmArgs);
        desc.initialArgs(rubyOptions);
        desc.classPath(classPath);
        desc.additionalArgs(this.getApplicationArguments());
        desc.fileLocator((LineConvertors.FileLocator)new RubyFileLocator(context, this.project));
        desc.addStandardRecognizers();
        desc.addOutConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)desc.getFileLocator(), (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
        desc.addErrConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)desc.getFileLocator(), (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
        desc.setEncoding(this.getSourceEncoding());
        if (extraConvertors != null) {
            for (LineConvertor extra : extraConvertors) {
                desc.addOutConvertor(extra);
            }
        }
        if ((coverageProvider = RubyCoverageProvider.get((Project)this.project)) != null && coverageProvider.isEnabled()) {
            desc = coverageProvider.wrapWithCoverage(desc, false, null);
        }
        return desc;
    }

    private String locate(String target, FileObject[] srcPath, FileObject[] testPath) {
        if (!new File(target).exists() && srcPath != null && srcPath.length > 0) {
            FileObject fo;
            boolean found = false;
            for (FileObject root : srcPath) {
                fo = root.getFileObject(target);
                if (fo == null) continue;
                target = FileUtil.toFile((FileObject)fo).getAbsolutePath();
                found = true;
                break;
            }
            if (!found && testPath != null) {
                for (FileObject root : testPath) {
                    fo = root.getFileObject(target);
                    if (fo == null) continue;
                    target = FileUtil.toFile((FileObject)fo).getAbsolutePath();
                    break;
                }
            }
        }
        return target;
    }

    private void openIrbConsole(Lookup context) {
        RubyPlatform platform = this.getPlatform();
        String irbPath = platform.findExecutable("irb");
        if (irbPath == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        String displayName = NbBundle.getMessage(RubyActionProvider.class, (String)"CTL_IrbTopComponent");
        File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String classPath = this.project.evaluator().getProperty("javac.classpath");
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, displayName, pwd, irbPath).showSuspended(false).showProgress(false).classPath(classPath).allowInput().additionalArgs(new String[]{"--simple-prompt", "--noreadline"}).fileLocator((LineConvertors.FileLocator)new RubyFileLocator(context, this.project)).addStandardRecognizers();
        RubyProcessCreator rpc = new RubyProcessCreator(desc, this.getSourceEncoding());
        ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName).run();
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        RakeRunner runner;
        TestRunner testRunner;
        RubyPlatform platform = RubyPlatform.platformFor((Project)this.project);
        assert (platform != null) : "Action '" + command + "' should be disabled when platform is invalid";
        if ("run".equals(command) || "debug".equals(command)) {
            if (!platform.isValid(true)) {
                return;
            }
            String config = this.project.evaluator().getProperty("config");
            String path = config == null || config.length() == 0 ? "nbproject/project.properties" : "nbproject/configs/" + config + ".properties";
            EditableProperties ep = this.getUpdateHelper().getProperties(path);
            String mainClass = this.project.evaluator().getProperty("main.file");
            MainClassStatus result = this.isSetMainClass(this.project.getSourceRoots().getRoots(), mainClass);
            if (context.lookup(RubyConfigurationProvider.Config.class) != null) {
                result = MainClassStatus.SET_AND_VALID;
            }
            if (result != MainClassStatus.SET_AND_VALID) {
                do {
                    if (this.showMainClassWarning(mainClass, ProjectUtils.getInformation((Project)this.project).getDisplayName(), ep, result)) {
                        return;
                    }
                    mainClass = ep.get((Object)"main.file");
                } while ((result = this.isSetMainClass(this.project.getSourceRoots().getRoots(), mainClass)) != MainClassStatus.SET_AND_VALID);
                try {
                    if (!this.getUpdateHelper().requestSave()) {
                        return;
                    }
                    this.getUpdateHelper().putProperties(path, ep);
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, "Error while saving project: " + ioe);
                }
            }
            LifecycleManager.getDefault().saveAll();
            String displayName = mainClass != null ? NbBundle.getMessage(RubyActionProvider.class, (String)"Ruby") : NbBundle.getMessage(RubyActionProvider.class, (String)"Rake");
            ProjectInformation info = ProjectUtils.getInformation((Project)this.project);
            if (info != null) {
                displayName = info.getDisplayName();
            }
            if (mainClass != null) {
                FileObject fileObject = null;
                this.runRubyScript(fileObject, mainClass, displayName, context, "debug".equals(command), new LineConvertor[0]);
                return;
            }
            if (!platform.hasRubyGemsInstalled(true) || !platform.hasValidRake(true)) {
                return;
            }
            RubyFileLocator fileLocator = new RubyFileLocator(context, this.project);
            File pwd = this.getSourceFolder();
            String classPath = this.project.evaluator().getProperty("javac.classpath");
            RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, displayName, pwd, platform.getRake()).fileLocator((LineConvertors.FileLocator)fileLocator).allowInput().classPath(classPath).appendJdkToPath(platform.isJRuby()).addStandardRecognizers().addErrConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)fileLocator, (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2)).addOutConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)fileLocator, (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
            RubyCoverageProvider coverageProvider = RubyCoverageProvider.get((Project)this.project);
            if (coverageProvider != null && coverageProvider.isEnabled()) {
                desc = coverageProvider.wrapWithCoverage(desc, false, null);
            }
            RubyProcessCreator rpc = new RubyProcessCreator(desc, this.getSourceEncoding());
            ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName);
            return;
        }
        if ("run.single".equals(command) || "debug.single".equals(command)) {
            TestRunner testRunner2;
            if (!platform.isValid(true)) {
                return;
            }
            FileObject file = this.getCurrentFile(context);
            if (RakeSupport.isRakeFile(file)) {
                if (!platform.hasValidRake(true)) {
                    return;
                }
                LifecycleManager.getDefault().saveAll();
                RakeRunner runner2 = new RakeRunner(this.project);
                runner2.setRakeFile(file);
                runner2.setFileLocator(new RubyFileLocator(context, this.project));
                runner2.showWarnings(true);
                runner2.setDebug("debug.single".equals(command));
                runner2.run(new String[0]);
                return;
            }
            RSpecSupport rspec = new RSpecSupport(this.project);
            if (rspec.isRSpecInstalled() && RSpecSupport.isSpecFile(file)) {
                LifecycleManager.getDefault().saveAll();
                TestRunner rspecRunner = Util.getTestRunner(TestRunner.TestType.RSPEC);
                if (rspecRunner != null) {
                    rspecRunner.runTest(file, "debug.single".equals(command));
                } else {
                    rspec.runRSpec(null, file, file.getName(), new RubyFileLocator(context, this.project), true, "debug.single".equals(command), new String[0]);
                }
                return;
            }
            RubyActionProvider.saveFile(file);
            if (file.getName().endsWith("_test") && (testRunner2 = Util.getTestRunner(TestRunner.TestType.TEST_UNIT)) != null) {
                testRunner2.getInstance().runTest(file, "debug.single".equals(command));
                return;
            }
            this.runRubyScript(file, FileUtil.toFile((FileObject)file).getAbsolutePath(), file.getNameExt(), context, "debug.single".equals(command), new LineConvertor[]{null});
            return;
        }
        if ("rebuild".equals(command) || "build".equals(command) || "clean".equals(command)) {
            RakeRunner runner3 = new RakeRunner(this.project);
            runner3.showWarnings(true);
            if ("rebuild".equals(command)) {
                runner3.run("clean", "gem");
            } else if ("build".equals(command)) {
                runner3.run("gem");
            } else {
                runner3.run("clean");
            }
            return;
        }
        if ("rdoc".equals(command)) {
            LifecycleManager.getDefault().saveAll();
            File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            Runnable showBrowser = new Runnable(){

                @Override
                public void run() {
                    FileObject index;
                    FileObject doc = RubyActionProvider.this.project.getProjectDirectory().getFileObject("doc");
                    if (doc != null && (index = doc.getFileObject("index.html")) != null) {
                        try {
                            URL url = FileUtil.toFile((FileObject)index).toURI().toURL();
                            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                        }
                        catch (MalformedURLException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                }
            };
            RubyFileLocator fileLocator = new RubyFileLocator(context, this.project);
            String displayName = NbBundle.getMessage(RubyActionProvider.class, (String)"RubyDocumentation");
            RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, displayName, pwd).additionalArgs(new String[]{"-r", "rdoc/rdoc", "-e", "begin; r = RDoc::RDoc.new; r.document(ARGV); end"}).fileLocator((LineConvertors.FileLocator)fileLocator).postBuild(showBrowser).addStandardRecognizers();
            RubyProcessCreator rpc = new RubyProcessCreator(desc, this.getSourceEncoding());
            ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName).run();
            return;
        }
        if ("autotest".equals(command)) {
            if (AutoTestSupport.isInstalled(this.project, TestRunner.TestType.AUTOTEST)) {
                AutoTestSupport support = new AutoTestSupport(context, this.project, this.getSourceEncoding());
                support.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                support.start(TestRunner.TestType.AUTOTEST);
            }
            return;
        }
        if ("autospec".equals(command)) {
            if (AutoTestSupport.isInstalled(this.project, TestRunner.TestType.AUTOSPEC)) {
                AutoTestSupport support = new AutoTestSupport(context, this.project, this.getSourceEncoding());
                support.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                support.start(TestRunner.TestType.AUTOSPEC);
            }
            return;
        }
        if ("test.single".equals(command) || "debug.test.single".equals(command)) {
            if (!platform.isValid(true)) {
                return;
            }
            FileObject file = this.getCurrentFile(context);
            if (file == null) {
                return;
            }
            RubyActionProvider.saveFile(file);
            DeclarationFinder.DeclarationLocation location = new GotoTest().findTest(file, -1);
            if (location != DeclarationFinder.DeclarationLocation.NONE) {
                file = location.getFileObject();
                RubyActionProvider.saveFile(file);
            }
            boolean isDebug = "debug.test.single".equals(command);
            RSpecSupport rspec = new RSpecSupport(this.project);
            if (rspec.isRSpecInstalled() && RSpecSupport.isSpecFile(file)) {
                TestRunner rspecRunner = Util.getTestRunner(TestRunner.TestType.RSPEC);
                if (rspecRunner != null) {
                    rspecRunner.runTest(file, isDebug);
                } else {
                    rspec.runRSpec(null, file, file.getName(), new RubyFileLocator(context, this.project), true, isDebug, new String[0]);
                }
                return;
            }
            TestRunner testRunner3 = Util.getTestRunner(TestRunner.TestType.TEST_UNIT);
            if (testRunner3 != null) {
                testRunner3.getInstance().runTest(file, isDebug);
            } else {
                this.runRubyScript(file, FileUtil.toFile((FileObject)file).getAbsolutePath(), file.getNameExt(), context, isDebug, new TestNotifierLineConvertor(true, true));
            }
        }
        if ("test".equals(command)) {
            boolean testTaskExist;
            testRunner = Util.getTestRunner(TestRunner.TestType.TEST_UNIT);
            boolean bl = testTaskExist = RakeSupport.getRakeTask(this.project, "test") != null;
            if (testTaskExist) {
                File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                runner = new RakeRunner(this.project);
                runner.setPWD(pwd);
                runner.setFileLocator(new RubyFileLocator(context, this.project));
                runner.showWarnings(true);
                runner.setDebug("debug.single".equals(command));
                runner.run("test");
            } else if (testRunner != null) {
                testRunner.getInstance().runAllTests(this.project, false);
            }
            return;
        }
        if ("rspec".equals(command)) {
            boolean rspecTaskExists = RakeSupport.getRakeTask(this.project, "spec") != null;
            TestRunner testRunner4 = Util.getTestRunner(TestRunner.TestType.RSPEC);
            if (rspecTaskExists) {
                File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                runner = new RakeRunner(this.project);
                runner.setPWD(pwd);
                runner.setFileLocator(new RubyFileLocator(context, this.project));
                runner.showWarnings(true);
                runner.run("spec");
            } else if (testRunner4 != null) {
                testRunner4.getInstance().runAllTests(this.project, false);
            }
            return;
        }
        if ("rspec-all".equals(command)) {
            testRunner = Util.getTestRunner(TestRunner.TestType.RSPEC);
            if (testRunner != null) {
                testRunner.getInstance().runAllTests(this.project, false);
            }
            return;
        }
        if (COMMAND_IRB_CONSOLE.equals(command)) {
            this.openIrbConsole(context);
            return;
        }
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (this.getPlatform() == null) {
            return false;
        }
        if (command.equals("compile.single")) {
            return this.findSourcesAndPackages(context, this.project.getSourceRoots().getRoots()) != null || this.findSourcesAndPackages(context, this.project.getTestSourceRoots().getRoots()) != null;
        }
        if (command.equals("run.single") || command.equals("debug.single")) {
            if (RakeSupport.isRakeFileSelected(context)) {
                return true;
            }
            FileObject[] fos = this.findSources(context);
            if (fos != null && fos.length == 1) {
                return true;
            }
            fos = this.findTestSources(context);
            return fos != null && fos.length == 1;
        }
        return true;
    }

    protected FileObject[] findSourcesAndPackages(Lookup context, FileObject srcDir) {
        if (srcDir != null) {
            FileObject[] files = RubyActionProvider.findSelectedFiles(context, srcDir, null, true);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isFolder() || !files[i].getMIMEType().equals("text/x-ruby")) continue;
                    return null;
                }
            }
            return files;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup context, FileObject[] srcRoots) {
        for (int i = 0; i < srcRoots.length; ++i) {
            FileObject[] result = this.findSourcesAndPackages(context, srcRoots[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private FileObject getRoot(FileObject[] roots, FileObject file) {
        assert (file != null) : "File can't be null";
        FileObject srcDir = null;
        for (int i = 0; i < roots.length; ++i) {
            assert (roots[i] != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)roots[i], (FileObject)file) && !roots[i].equals(file)) continue;
            srcDir = roots[i];
            break;
        }
        return srcDir;
    }

    private MainClassStatus isSetMainClass(FileObject[] sourcesRoots, String mainClass) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult != false ? MainClassStatus.SET_AND_VALID : MainClassStatus.SET_BUT_INVALID;
        }
        if (mainClass == null || mainClass.length() == 0) {
            return MainClassStatus.UNSET;
        }
        if (RubyProjectUtil.isMainClass(mainClass, sourcesRoots)) {
            return MainClassStatus.SET_AND_VALID;
        }
        return MainClassStatus.SET_BUT_INVALID;
    }

    private boolean showMainClassWarning(String mainClass, String projectName, EditableProperties ep, MainClassStatus messageType) {
        boolean canceled;
        String message;
        final JButton okButton = new JButton(NbBundle.getMessage(RubyActionProvider.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyActionProvider.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        switch (messageType) {
            case UNSET: {
                message = MessageFormat.format(NbBundle.getMessage(RubyActionProvider.class, (String)"LBL_MainClassNotFound"), projectName);
                break;
            }
            case SET_BUT_INVALID: {
                message = MessageFormat.format(NbBundle.getMessage(RubyActionProvider.class, (String)"LBL_MainClassWrong"), mainClass, projectName);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning panel = new MainClassWarning(message, this.project.getSourceRoots().getRoots());
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        okButton.setEnabled(false);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(RubyActionProvider.class, (String)"CTL_MainClassWarning_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() != options[0]) {
            canceled = true;
        } else {
            mainClass = panel.getSelectedMainClass();
            canceled = false;
            ep.put("main.file", mainClass == null ? "" : mainClass);
        }
        dlg.dispose();
        return canceled;
    }

    private File getSourceFolder() {
        FileObject[] srcPath = this.project.getSourceRoots().getRoots();
        if (srcPath != null && srcPath.length > 0) {
            return FileUtil.toFile((FileObject)srcPath[0]);
        }
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    private static enum MainClassStatus {
        SET_AND_VALID,
        SET_BUT_INVALID,
        UNSET;

    }
}

