/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.imageio.IIOException;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AbstractSaveAction;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.SVGAnimationRasterizerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SaveAnimationAsImageAction
extends AbstractSaveAction {
    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public static void setDialogMinimumSize(final Dialog dlg) {
        dlg.pack();
        dlg.setSize(dlg.getPreferredSize());
        dlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = dlg.getWidth();
                int h = dlg.getHeight();
                Dimension minSize = dlg.getPreferredSize();
                int _w = Math.max(w, minSize.width);
                int _h = Math.max(h, minSize.height);
                if (w != _w || h != _h) {
                    dlg.setSize(new Dimension(_w, _h));
                }
            }
        });
    }

    protected void performAction(Node[] n) {
        SVGDataObject doj = (SVGDataObject)((Object)n[0].getLookup().lookup(SVGDataObject.class));
        if (doj != null) {
            int state = this.getAnimatorState(doj);
            float time = this.stopAnimator(doj);
            try {
                final SVGAnimationRasterizerPanel panel = new SVGAnimationRasterizerPanel(doj);
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SaveAnimationAsImageAction.class, (String)"TITLE_AnimationExport"));
                panel.addPropertyChangeListener("valid", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        dd.setValid(panel.isDialogValid());
                    }
                });
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                SaveAnimationAsImageAction.setDialogMinimumSize(dlg);
                dd.setValid(panel.isDialogValid());
                dlg.setVisible(true);
                panel.stopProcessing();
                if (dd.getValue() == DialogDescriptor.OK_OPTION && panel.isExportConfirmed()) {
                    AnimationRasterizer.export(doj, panel);
                }
            }
            catch (IIOException e) {
                String msg = NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"MSG_IMG_ENCODING_ERROR") + ": " + e.getLocalizedMessage();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            }
            catch (Exception e) {
                SceneManager.error("Animation export failed", e);
            }
            this.resumeAnimatorState(doj, state, time);
        }
    }

    public String getName() {
        return NbBundle.getMessage(SaveAnimationAsImageAction.class, (String)"LBL_ExportAnimationAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected int mode() {
        return 1;
    }

    protected Class[] cookieClasses() {
        return new Class[]{SVGDataObject.class};
    }

    protected boolean asynchronous() {
        return false;
    }
}

