/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Map;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.Version;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBinder {
    private Logger log = LoggerFactory.getLogger(PropertyBinder.class);
    private String name;
    private String returnedClassName;
    private boolean lazy;
    private AccessType accessType;
    private Ejb3Column[] columns;
    private PropertyHolder holder;
    private ExtendedMappings mappings;
    private Value value;
    private boolean insertable = true;
    private boolean updatable = true;
    private String cascade;
    private SimpleValueBinder simpleValueBinder;
    private XClass declaringClass;
    private boolean declaringClassSet;
    private boolean embedded;
    private EntityBinder entityBinder;
    private boolean isXToMany;
    private String referencedEntityName;
    private XProperty property;
    private XClass returnedClass;
    private boolean isId;
    private Map<XClass, InheritanceState> inheritanceStatePerClass;
    private Property mappingProperty;

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setEntityBinder(EntityBinder entityBinder) {
        this.entityBinder = entityBinder;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.insertable = columns[0].isInsertable();
        this.updatable = columns[0].isUpdatable();
        this.columns = columns;
    }

    public void setHolder(PropertyHolder holder) {
        this.holder = holder;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setCascade(String cascadeStrategy) {
        this.cascade = cascadeStrategy;
    }

    public void setMappings(ExtendedMappings mappings) {
        this.mappings = mappings;
    }

    public void setDeclaringClass(XClass declaringClass) {
        this.declaringClass = declaringClass;
        this.declaringClassSet = true;
    }

    private void validateBind() {
        if (this.property.isAnnotationPresent(Immutable.class)) {
            throw new AnnotationException("@Immutable on property not allowed. Only allowed on entity level or on a collection.");
        }
        if (!this.declaringClassSet) {
            throw new AssertionFailure("declaringClass has not been set before a bind");
        }
    }

    private void validateMake() {
    }

    private Property makePropertyAndValue() {
        this.validateBind();
        this.log.debug("binding property {} with lazy={}", (Object)this.name, (Object)this.lazy);
        String containerClassName = this.holder == null ? null : this.holder.getClassName();
        this.simpleValueBinder = new SimpleValueBinder();
        this.simpleValueBinder.setMappings(this.mappings);
        this.simpleValueBinder.setPropertyName(this.name);
        this.simpleValueBinder.setReturnedClassName(this.returnedClassName);
        this.simpleValueBinder.setColumns(this.columns);
        this.simpleValueBinder.setPersistentClassName(containerClassName);
        this.simpleValueBinder.setType(this.property, this.returnedClass);
        this.simpleValueBinder.setMappings(this.mappings);
        this.simpleValueBinder.setReferencedEntityName(this.referencedEntityName);
        SimpleValue propertyValue = this.simpleValueBinder.make();
        this.setValue(propertyValue);
        return this.makeProperty();
    }

    public Property makePropertyAndBind() {
        return this.bind(this.makeProperty());
    }

    public Property makePropertyValueAndBind() {
        return this.bind(this.makePropertyAndValue());
    }

    public void setXToMany(boolean xToMany) {
        this.isXToMany = xToMany;
    }

    private Property bind(Property prop) {
        if (this.isId) {
            RootClass rootClass = (RootClass)this.holder.getPersistentClass();
            if (this.isXToMany || this.entityBinder.wrapIdsInEmbeddedComponents()) {
                Component identifier = (Component)rootClass.getIdentifier();
                if (identifier == null) {
                    identifier = AnnotationBinder.createComponent(this.holder, new PropertyPreloadedData(null, null, null), true, false);
                    rootClass.setIdentifier(identifier);
                    identifier.setNullValue("undefined");
                    rootClass.setEmbeddedIdentifier(true);
                }
                identifier.addProperty(prop);
            } else {
                rootClass.setIdentifier((KeyValue)this.getValue());
                if (this.embedded) {
                    rootClass.setEmbeddedIdentifier(true);
                } else {
                    rootClass.setIdentifierProperty(prop);
                    MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(this.declaringClass, this.inheritanceStatePerClass, this.mappings);
                    if (superclass != null) {
                        superclass.setDeclaredIdentifierProperty(prop);
                    } else {
                        rootClass.setDeclaredIdentifierProperty(prop);
                    }
                }
            }
        } else {
            this.holder.addProperty(prop, this.columns, this.declaringClass);
        }
        return prop;
    }

    public Property makeProperty() {
        OptimisticLock lockAnn;
        NaturalId naturalId;
        GenerationTime generated;
        this.validateMake();
        this.log.debug("Building property " + this.name);
        Property prop = new Property();
        prop.setName(this.name);
        prop.setNodeName(this.name);
        prop.setValue(this.value);
        prop.setLazy(this.lazy);
        prop.setCascade(this.cascade);
        prop.setPropertyAccessorName(this.accessType.getType());
        Generated ann = this.property != null ? this.property.getAnnotation(Generated.class) : null;
        GenerationTime generationTime = generated = ann != null ? ann.value() : null;
        if (generated != null && !GenerationTime.NEVER.equals((Object)generated)) {
            if (this.property.isAnnotationPresent(Version.class) && GenerationTime.INSERT.equals((Object)generated)) {
                throw new AnnotationException("@Generated(INSERT) on a @Version property not allowed, use ALWAYS: " + StringHelper.qualify(this.holder.getPath(), this.name));
            }
            this.insertable = false;
            if (GenerationTime.ALWAYS.equals((Object)generated)) {
                this.updatable = false;
            }
            prop.setGeneration(PropertyGeneration.parse(generated.toString().toLowerCase()));
        }
        NaturalId naturalId2 = naturalId = this.property != null ? this.property.getAnnotation(NaturalId.class) : null;
        if (naturalId != null) {
            if (!naturalId.mutable()) {
                this.updatable = false;
            }
            prop.setNaturalIdentifier(true);
        }
        prop.setInsertable(this.insertable);
        prop.setUpdateable(this.updatable);
        OptimisticLock optimisticLock = lockAnn = this.property != null ? this.property.getAnnotation(OptimisticLock.class) : null;
        if (lockAnn != null) {
            prop.setOptimisticLocked(!lockAnn.excluded());
            if (lockAnn.excluded() && (this.property.isAnnotationPresent(Version.class) || this.property.isAnnotationPresent(Id.class) || this.property.isAnnotationPresent(EmbeddedId.class))) {
                throw new AnnotationException("@OptimisticLock.exclude=true incompatible with @Id, @EmbeddedId and @Version: " + StringHelper.qualify(this.holder.getPath(), this.name));
            }
        }
        this.log.trace("Cascading " + this.name + " with " + this.cascade);
        this.mappingProperty = prop;
        return prop;
    }

    public void setProperty(XProperty property) {
        this.property = property;
    }

    public void setReturnedClass(XClass returnedClass) {
        this.returnedClass = returnedClass;
    }

    public SimpleValueBinder getSimpleValueBinder() {
        return this.simpleValueBinder;
    }

    public Value getValue() {
        return this.value;
    }

    public void setId(boolean id) {
        this.isId = id;
    }

    public void setInheritanceStatePerClass(Map<XClass, InheritanceState> inheritanceStatePerClass) {
        this.inheritanceStatePerClass = inheritanceStatePerClass;
    }
}

