/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.PixelFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.PdfDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;

public class AxialContext
implements PaintContext {
    private float maxPDFX = -9999.0f;
    private float maxPDFY = -9999.0f;
    private float minPDFX = 9999.0f;
    private float minPDFY = 9999.0f;
    GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private boolean[] isExtended;
    private float x0 = 0.0f;
    private float x1 = 0.0f;
    private float y0 = 0.0f;
    private float y1 = 0.0f;
    private float t0 = 0.0f;
    private float t1 = 1.0f;
    private PDFFunction function;
    private boolean isPrinting;
    private int pageHeight;
    private boolean colorsReversed;
    private int minX = 0;
    private float[] background;
    private float offX;
    private float offY;
    private float printScale = 4.0f;
    public static int x = 0;

    private AxialContext() {
    }

    public AxialContext(float f, boolean bl, int n, int n2, int n3, int n4, float f2, boolean[] blArray, float[] fArray, float[] fArray2, GenericColorSpace genericColorSpace, boolean bl2, float[] fArray3, PDFFunction pDFFunction) {
        this.printScale = f;
        this.isPrinting = bl;
        this.offX = n;
        this.offY = n2;
        this.colorsReversed = bl2;
        this.pageHeight = n4;
        this.isExtended = blArray;
        this.t0 = fArray[0];
        this.t1 = fArray[1];
        this.background = fArray3;
        this.x0 = fArray2[0];
        this.x1 = fArray2[2];
        this.y0 = fArray2[1];
        this.y1 = fArray2[3];
        this.shadingColorSpace = genericColorSpace;
        this.function = pDFFunction;
        this.scaling = f2;
        this.minX = n3;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        int n5;
        WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        int[] nArray = new int[n3 * n4 * 4];
        float f = 0.0f;
        float f2 = -1.0f;
        float f3 = this.x1 - this.x0;
        float f4 = this.y1 - this.y0;
        float f5 = f3 * f3 + f4 * f4;
        Color color = this.colorsReversed ? this.calculateColor(this.t1, this.t0, this.t1) : this.calculateColor(this.t0, this.t0, this.t1);
        int n6 = color.getRed();
        int n7 = color.getGreen();
        int n8 = color.getBlue();
        if (this.background != null) {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.shadingColorSpace.setColor(this.background, 4);
                    Color color2 = (Color)((Object)this.shadingColorSpace.getColor());
                    n5 = (i * n3 + j) * 4;
                    nArray[n5] = color2.getRed();
                    nArray[n5 + 1] = color2.getGreen();
                    nArray[n5 + 2] = color2.getBlue();
                    nArray[n5 + 3] = 255;
                }
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (int i = 0; i < n4; ++i) {
            for (n5 = 0; n5 < n3; ++n5) {
                Object object;
                float f8;
                if (PdfDecoder.isRunningOnMac) {
                    f8 = (f3 * ((float)(n5 + n) - this.x0) + f4 * ((float)(i + n2) - this.y0)) / f5;
                } else {
                    object = PixelFactory.convertPhysicalToPDF(this.isPrinting, f6, f7, n5, i, this.offX, this.offY, this.scaling, n, n2, this.minX, this.pageHeight);
                    f6 = object[0];
                    f7 = object[1];
                    f8 = (f3 * (f6 - this.x0) + f4 * (f7 - this.y0)) / f5;
                    float f9 = this.y0 - this.y1;
                    if (this.isPrinting && f9 < 0.0f) {
                        f8 = 1.0f - f8;
                    }
                    if (f6 > this.maxPDFX) {
                        this.maxPDFX = f6;
                    }
                    if (f6 < this.minPDFX) {
                        this.minPDFX = f6;
                    }
                    if (f7 > this.maxPDFY) {
                        this.maxPDFY = f7;
                    }
                    if (f7 < this.minPDFY) {
                        this.minPDFY = f7;
                    }
                }
                f = -1.0f;
                f = f8 < 0.0f && this.isExtended[0] ? this.t0 : (f8 > 1.0f && this.isExtended[1] ? this.t1 : this.t0 + (this.t1 - this.t0) * f8);
                if (!(f >= 0.0f) || !(f <= 1.0f)) continue;
                if (this.colorsReversed) {
                    f = 1.0f - f;
                }
                if (f != f2) {
                    f2 = f;
                    object = this.calculateColor(f, this.t0, this.t1);
                    n6 = ((Color)object).getRed();
                    n7 = ((Color)object).getGreen();
                    n8 = ((Color)object).getBlue();
                }
                int n9 = (i * n3 + n5) * 4;
                nArray[n9] = n6;
                nArray[n9 + 1] = n7;
                nArray[n9 + 2] = n8;
                nArray[n9 + 3] = 255;
            }
        }
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    private Color calculateColor(float f, float f2, float f3) {
        float[] fArray = new float[]{f};
        float[] fArray2 = this.function.compute(fArray);
        this.shadingColorSpace.setColor(fArray2, fArray2.length);
        return (Color)((Object)this.shadingColorSpace.getColor());
    }
}

