/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.AxialContext;
import com.idrsolutions.pdf.color.shading.FunctionContext;
import com.idrsolutions.pdf.color.shading.RadialContext;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class ShadedPaint
implements PdfPaint,
Paint,
Serializable {
    public static final int FUNCTION = 1;
    public static final int AXIAL = 2;
    public static final int RADIAL = 3;
    public static final int FREEFORM = 4;
    public static final int LATTICEFORM = 5;
    public static final int COONS = 6;
    public static final int TENSOR = 7;
    private static final boolean debug = false;
    protected PDFFunction function;
    protected int pageHeight;
    protected GenericColorSpace shadingColorSpace = null;
    protected float[] coords;
    protected boolean AntiAlias = false;
    protected int shadingType;
    protected float[] domain = new float[]{0.0f, 1.0f};
    private int type;
    private boolean[] isExtended = new boolean[2];
    private boolean colorsReversed;
    private float scaling;
    private int cropX;
    private int cropH;
    private float[] background;
    private boolean isPrinting;

    public ShadedPaint() {
    }

    public ShadedPaint(PdfObject pdfObject, boolean bl, int n, int n2, GenericColorSpace genericColorSpace, PdfObjectReader pdfObjectReader, float[][] fArray, int n3, boolean bl2) {
        this.isPrinting = bl;
        this.colorsReversed = bl2;
        this.type = n2;
        this.pageHeight = n3;
        this.init(pdfObject, n, genericColorSpace, pdfObjectReader, fArray);
    }

    public void init(PdfObject pdfObject, int n, GenericColorSpace genericColorSpace, PdfObjectReader pdfObjectReader, float[][] fArray) {
        float[] fArray2;
        float[] fArray3;
        boolean[] blArray = pdfObject.getBooleanArray(1144345468);
        if (blArray != null) {
            this.isExtended = blArray;
        }
        this.shadingColorSpace = genericColorSpace;
        this.shadingType = pdfObject.getInt(1487255197);
        this.background = pdfObject.getFloatArray(1921025959);
        this.AntiAlias = pdfObject.getBoolean(2055039589);
        PdfObject pdfObject2 = pdfObject.getDictionary(1518239089);
        if (pdfObject2 != null) {
            this.function = FunctionFactory.getFunction(pdfObject2, pdfObjectReader);
        }
        if ((fArray3 = pdfObject.getFloatArray(1026641277)) != null) {
            this.domain = fArray3;
        }
        if ((fArray2 = pdfObject.getFloatArray(1061308290)) != null) {
            int n2 = fArray2.length;
            this.coords = new float[n2];
            System.arraycopy(fArray2, 0, this.coords, 0, n2);
            if (fArray != null) {
                float f = fArray[0][0];
                float f2 = fArray[0][1];
                float f3 = fArray[1][0];
                float f4 = fArray[1][1];
                float f5 = fArray[2][0];
                float f6 = fArray[2][1];
                if (this.type == 2) {
                    float f7 = this.coords[0];
                    float f8 = this.coords[1];
                    float f9 = this.coords[2];
                    float f10 = this.coords[3];
                    this.coords[0] = f * f7 + f3 * f8 + f5;
                    this.coords[1] = f2 * f7 + f4 * f8 + f6;
                    this.coords[2] = f * f9 + f3 * f10 + f5;
                    this.coords[3] = f2 * f9 + f4 * f10 + f6;
                } else if (this.type == 3) {
                    float f11 = this.coords[0];
                    float f12 = this.coords[1];
                    float f13 = this.coords[3];
                    float f14 = this.coords[4];
                    this.coords[0] = f * f11 + f3 * f12 + f5;
                    this.coords[1] = f2 * f11 + f4 * f12 + f6;
                    this.coords[3] = f * f13 + f3 * f14 + f5;
                    this.coords[4] = f2 * f13 + f4 * f14 + f6;
                    f13 = this.coords[2];
                    float f15 = f * f13;
                    float f16 = f2 * f13;
                    this.coords[2] = (float)Math.sqrt(f15 * f15 + f16 * f16);
                    f13 = this.coords[5];
                    f15 = f * f13;
                    f16 = f2 * f13;
                    this.coords[5] = (float)Math.sqrt(f15 * f15 + f16 * f16);
                    if (f4 < 0.0f) {
                        float f17 = this.coords[5];
                        this.coords[5] = this.coords[2];
                        this.coords[2] = f17;
                        this.colorsReversed = true;
                    }
                }
            }
        }
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        PaintContext paintContext = null;
        float f = 1.0f;
        int n = 0;
        int n2 = 0;
        if (!this.isPrinting) {
            n = (int)affineTransform.getTranslateX() + this.cropX;
            n2 = (int)affineTransform.getTranslateY() - this.cropH;
        } else {
            n = (int)affineTransform.getTranslateX();
            n2 = (int)affineTransform.getTranslateY();
            this.scaling = (float)affineTransform.getScaleY();
        }
        switch (this.type) {
            case 1: {
                paintContext = new FunctionContext(this.cropH, (float)(1.0 / affineTransform.getScaleX()), this.domain, this.shadingColorSpace, this.colorsReversed, this.function);
                break;
            }
            case 2: {
                paintContext = new AxialContext(f, this.isPrinting, n, n2, this.cropX, this.cropH, 1.0f / this.scaling, this.isExtended, this.domain, this.coords, this.shadingColorSpace, this.colorsReversed, this.background, this.function);
                break;
            }
            case 3: {
                paintContext = new RadialContext(this.isPrinting, n, n2, this.cropX, this.cropH, 1.0f / this.scaling, this.isExtended, this.domain, this.coords, this.shadingColorSpace, this.colorsReversed, this.background, this.function);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
        }
        return paintContext;
    }

    public int getTransparency() {
        return 0;
    }

    public void setScaling(double d, double d2, float f) {
        this.scaling = f;
        this.cropX = (int)d;
        this.cropH = (int)d2;
    }

    public boolean isPattern() {
        return true;
    }

    public void setPattern(int n) {
    }

    public int getRGB() {
        return 0;
    }
}

