/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import oracle.xml.parser.v2.XMLDOMConfiguration;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class XMLLSSerializer
implements LSSerializer {
    private DOMConfiguration config = new XMLDOMConfiguration();
    private String newLine = null;
    private LSSerializerFilter filter = null;

    public DOMConfiguration getConfig() {
        return this.config;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String string) {
        if (string.equals("\n") || string.equals("\r") || string.equals("\r\n")) {
            this.newLine = string;
        }
    }

    public LSSerializerFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.filter = lSSerializerFilter;
    }

    public boolean write(Node node, LSOutput lSOutput) {
        Writer writer = lSOutput.getCharacterStream();
        OutputStream outputStream = lSOutput.getByteStream();
        String string = lSOutput.getSystemId();
        String string2 = lSOutput.getEncoding();
        boolean bl = (Boolean)this.config.getParameter("xml-declaration");
        XMLPrintDriver xMLPrintDriver = null;
        if (writer != null) {
            xMLPrintDriver = new XMLPrintDriver(writer);
        } else if (outputStream != null) {
            xMLPrintDriver = new XMLPrintDriver(outputStream);
        } else {
            if (string != null) {
                throw new XMLDOMException(9, "Writing to a URI is not supported");
            }
            return false;
        }
        if (node == null) {
            return true;
        }
        try {
            if (string2 != null) {
                xMLPrintDriver.setEncoding(string2);
            }
            if (this.newLine != null) {
                xMLPrintDriver.setEOLChars(this.newLine);
            }
            if (this.filter != null) {
                xMLPrintDriver.setFilter(this.filter);
            }
            xMLPrintDriver.setConfig(this.config);
            if (node instanceof XMLDocument) {
                xMLPrintDriver.printDocument((XMLDocument)node);
            } else {
                xMLPrintDriver.printChildNodes((XMLNode)node);
            }
            xMLPrintDriver.flush();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean writeToURI(Node node, String string) {
        LSOutput lSOutput = new XMLDOMImplementation().createLSOutput();
        lSOutput.setSystemId(string);
        return this.write(node, lSOutput);
    }

    public String writeToString(Node node) throws DOMException {
        LSOutput lSOutput = new XMLDOMImplementation().createLSOutput();
        lSOutput.setByteStream(new ByteArrayOutputStream());
        try {
            boolean bl = this.write(node, lSOutput);
            if (!bl) {
                return null;
            }
            return lSOutput.getByteStream().toString();
        }
        catch (Exception exception) {
            throw new XMLDOMException(2, "The resulting string is too long to fit");
        }
    }
}

