/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DiskStoreConfiguration {
    private static final Logger LOG = Logger.getLogger(DiskStoreConfiguration.class.getName());
    private String path;

    public final String getPath() {
        return this.path;
    }

    public static String getDefaultPath() {
        return DiskStoreConfiguration.translatePath("java.io.tmpdir");
    }

    public final void setPath(String path) {
        String translatedPath;
        this.path = translatedPath = DiskStoreConfiguration.translatePath(path);
    }

    private static String translatePath(String path) {
        String translatedPath = DiskStoreConfiguration.replaceToken("user.home", System.getProperty("user.home"), path);
        translatedPath = DiskStoreConfiguration.replaceToken("user.dir", System.getProperty("user.dir"), translatedPath);
        translatedPath = DiskStoreConfiguration.replaceToken("java.io.tmpdir", System.getProperty("java.io.tmpdir"), translatedPath);
        translatedPath = DiskStoreConfiguration.replaceToken("ehcache.disk.store.dir", System.getProperty("ehcache.disk.store.dir"), translatedPath);
        translatedPath = DiskStoreConfiguration.replaceToken(File.separator + File.separator, File.separator, translatedPath);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Disk Store Path: " + translatedPath);
        }
        return translatedPath;
    }

    public static String replaceToken(String token, String replacement, String source) {
        int foundIndex = source.indexOf(token);
        if (foundIndex == -1) {
            return source;
        }
        String firstFragment = source.substring(0, foundIndex);
        String lastFragment = source.substring(foundIndex + token.length(), source.length());
        return new StringBuffer().append(firstFragment).append(replacement).append(lastFragment).toString();
    }

    private static final class Env {
        static final String USER_HOME = "user.home";
        static final String USER_DIR = "user.dir";
        static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
        static final String EHCACHE_DISK_STORE_DIR = "ehcache.disk.store.dir";

        private Env() {
        }
    }
}

