/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.engine.TriggerObject;
import org.h2.message.Message;
import org.h2.table.Table;

public class DropTrigger
extends SchemaCommand {
    private String triggerName;
    private boolean ifExists;

    public DropTrigger(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        TriggerObject trigger = this.getSchema().findTrigger(this.triggerName);
        if (trigger == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90042, this.triggerName);
            }
        } else {
            Table table = trigger.getTable();
            this.session.getUser().checkRight(table, 15);
            db.removeSchemaObject(this.session, trigger);
        }
        return 0;
    }
}

