/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Schema;
import org.h2.message.Message;
import org.h2.table.Table;

public class TruncateTable
extends SchemaCommand {
    private String tableName;

    public TruncateTable(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int update() throws SQLException {
        this.session.commit();
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        if (!table.canTruncate()) {
            throw Message.getSQLException(90106, this.tableName);
        }
        this.session.getUser().checkRight(table, 2);
        table.lock(this.session, true);
        table.truncate(this.session);
        return 0;
    }
}

