/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Random;
import org.h2.test.bench.Bench;
import org.h2.test.bench.Database;

public class BenchA
implements Bench {
    private Database db;
    private int branches;
    private int tellers;
    private int accounts;
    private int size;
    private static final String FILLER = "abcdefghijklmnopqrstuvwxyz";
    private static final int DELTA = 10000;

    public BenchA() {
        this.tellers = this.branches * 10;
        this.accounts = this.branches * 100;
    }

    public void init(Database db, int size) throws Exception {
        int i;
        this.db = db;
        this.size = size;
        int scale = 1;
        this.accounts = size * 20;
        this.tellers = Math.max(this.accounts / 10, 1);
        this.branches = Math.max(this.tellers / 10, 1);
        db.start(this, "Init");
        db.openConnection();
        db.dropTable("BRANCHES");
        db.dropTable("BRANCHES");
        db.dropTable("TELLERS");
        db.dropTable("ACCOUNTS");
        db.dropTable("HISTORY");
        String[] create = new String[]{"CREATE TABLE BRANCHES(BID INT PRIMARY KEY, BBALANCE DECIMAL(15,2), FILLER VARCHAR(88))", "CREATE TABLE TELLERS(TID INT PRIMARY KEY, BID INT, TBALANCE DECIMAL(15,2), FILLER VARCHAR(84))", "CREATE TABLE ACCOUNTS(AID INT PRIMARY KEY, BID INT, ABALANCE DECIMAL(15,2), FILLER VARCHAR(84))", "CREATE TABLE HISTORY(TID INT, BID INT, AID INT, DELTA DECIMAL(15,2), HTIME DATETIME, FILLER VARCHAR(40))"};
        for (int i2 = 0; i2 < create.length; ++i2) {
            db.update(create[i2]);
        }
        db.setAutoCommit(false);
        int commitEvery = 1000;
        PreparedStatement prep = db.prepare("INSERT INTO BRANCHES(BID,BBALANCE,FILLER) VALUES(?,10000.00,'abcdefghijklmnopqrstuvwxyz')");
        for (i = 0; i < this.branches * scale; ++i) {
            prep.setInt(1, i);
            db.update(prep);
            if (i % commitEvery != 0) continue;
            db.commit();
        }
        db.commit();
        prep = db.prepare("INSERT INTO TELLERS(TID,BID,TBALANCE,FILLER) VALUES(?,?,10000.00,'abcdefghijklmnopqrstuvwxyz')");
        for (i = 0; i < this.tellers * scale; ++i) {
            prep.setInt(1, i);
            prep.setInt(2, i / this.tellers);
            db.update(prep);
            if (i % commitEvery != 0) continue;
            db.commit();
        }
        db.commit();
        int len = this.accounts * scale;
        prep = db.prepare("INSERT INTO ACCOUNTS(AID,BID,ABALANCE,FILLER) VALUES(?,?,10000.00,'abcdefghijklmnopqrstuvwxyz')");
        for (int i3 = 0; i3 < len; ++i3) {
            prep.setInt(1, i3);
            prep.setInt(2, i3 / this.accounts);
            db.update(prep);
            if (i3 % commitEvery != 0) continue;
            db.commit();
        }
        db.commit();
        db.closeConnection();
        db.end();
        db.start(this, "Open/Close");
        db.openConnection();
        db.closeConnection();
        db.end();
    }

    public void run() throws Exception {
        this.db.start(this, "Transactions");
        this.db.openConnection();
        this.processTransactions();
        this.db.closeConnection();
        this.db.end();
        this.db.openConnection();
        this.processTransactions();
        this.db.logMemory(this, "Memory Usage");
        this.db.closeConnection();
    }

    private void processTransactions() throws Exception {
        Random random = this.db.getRandom();
        int branch = random.nextInt(this.branches);
        int teller = random.nextInt(this.tellers);
        int transactions = this.size * 20;
        PreparedStatement updateAccount = this.db.prepare("UPDATE ACCOUNTS SET ABALANCE=ABALANCE+? WHERE AID=?");
        PreparedStatement selectBalance = this.db.prepare("SELECT ABALANCE FROM ACCOUNTS WHERE AID=?");
        PreparedStatement updateTeller = this.db.prepare("UPDATE TELLERS SET TBALANCE=TBALANCE+? WHERE TID=?");
        PreparedStatement updateBranch = this.db.prepare("UPDATE BRANCHES SET BBALANCE=BBALANCE+? WHERE BID=?");
        PreparedStatement insertHistory = this.db.prepare("INSERT INTO HISTORY(AID,TID,BID,DELTA,HTIME,FILLER) VALUES(?,?,?,?,?,?)");
        int accountsPerBranch = this.accounts / this.branches;
        this.db.setAutoCommit(false);
        for (int i = 0; i < transactions; ++i) {
            int account = random.nextInt(100) < 85 ? random.nextInt(accountsPerBranch) + branch * accountsPerBranch : random.nextInt(this.accounts);
            int max = 10000;
            BigDecimal delta = new BigDecimal("" + (random.nextInt(max * 2) - max));
            long current = System.currentTimeMillis();
            updateAccount.setBigDecimal(1, delta);
            updateAccount.setInt(2, account);
            this.db.update(updateAccount);
            updateTeller.setBigDecimal(1, delta);
            updateTeller.setInt(2, teller);
            this.db.update(updateTeller);
            updateBranch.setBigDecimal(1, delta);
            updateBranch.setInt(2, branch);
            this.db.update(updateBranch);
            selectBalance.setInt(1, account);
            this.db.queryReadResult(selectBalance);
            insertHistory.setInt(1, account);
            insertHistory.setInt(2, teller);
            insertHistory.setInt(3, branch);
            insertHistory.setBigDecimal(4, delta);
            insertHistory.setTimestamp(5, new Timestamp(current));
            insertHistory.setString(6, FILLER);
            this.db.update(insertHistory);
            this.db.commit();
        }
        updateAccount.close();
        selectBalance.close();
        updateTeller.close();
        updateBranch.close();
        insertHistory.close();
    }

    public String getName() {
        return "BenchA";
    }
}

