/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PropertyUtil {
    private static final Logger LOG = Logger.getLogger(PropertyUtil.class.getName());
    private static final String DEFAULT_PROPERTY_SEPARATOR = ",";

    private PropertyUtil() {
    }

    public static String extractAndLogProperty(String name, Properties properties) {
        if (properties == null || properties.size() == 0) {
            return null;
        }
        String foundValue = (String)properties.get(name);
        if (foundValue != null) {
            foundValue = foundValue.trim();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(new StringBuffer().append("Value found for ").append(name).append(": ").append(foundValue).toString());
        }
        return foundValue;
    }

    public static String extractAndLogProperty(String name, Map properties) {
        if (properties == null || properties.size() == 0) {
            return null;
        }
        String foundValue = (String)properties.get(name);
        if (foundValue != null) {
            foundValue = foundValue.trim();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(new StringBuffer().append("Value found for ").append(name).append(": ").append(foundValue).toString());
        }
        return foundValue;
    }

    public static Properties parseProperties(String propertiesString, String propertySeparator) {
        String propertySeparatorLocal = propertySeparator;
        if (propertiesString == null) {
            LOG.fine("propertiesString is null.");
            return null;
        }
        if (propertySeparator == null) {
            propertySeparatorLocal = DEFAULT_PROPERTY_SEPARATOR;
        }
        Properties properties = new Properties();
        String propertyLines = propertiesString.trim();
        propertyLines = propertyLines.replaceAll(propertySeparatorLocal, "\n");
        try {
            properties.load(new ByteArrayInputStream(propertyLines.getBytes()));
        }
        catch (IOException e) {
            LOG.severe("Cannot load properties from " + propertiesString);
        }
        return properties;
    }

    public static boolean parseBoolean(String value) {
        return value != null && value.equalsIgnoreCase("true");
    }
}

