/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.code;

import java.io.File;
import java.io.RandomAccessFile;

public class CheckAscii {
    String[] suffixCheck = new String[]{"html", "jsp", "js", "css", "bat", "nsi", "java", "txt", "properties", "cpp", "def", "h", "rc", "dev", "sql", "xml"};
    String[] suffixIgnore = new String[]{"gif", "png", "odg", "ico", "sxd", "layout", "res", "win", "dll", "jar"};
    boolean failOnError;

    public static void main(String[] args) throws Exception {
        new CheckAscii().run();
    }

    void run() throws Exception {
        String baseDir = "src";
        this.check(new File(baseDir));
    }

    private void check(File file) throws Exception {
        String name = file.getName();
        if (file.isDirectory()) {
            if (name.equals("CVS")) {
                return;
            }
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                this.check(list[i]);
            }
        } else {
            int i;
            String suffix = "";
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0) {
                suffix = name.substring(lastDot + 1);
            }
            boolean check = false;
            boolean ignore = false;
            for (i = 0; i < this.suffixCheck.length; ++i) {
                if (!suffix.equals(this.suffixCheck[i])) continue;
                check = true;
            }
            for (i = 0; i < this.suffixIgnore.length; ++i) {
                if (!suffix.equals(this.suffixIgnore[i])) continue;
                ignore = true;
            }
            if (ignore == check) {
                throw new Error("Unknown suffix: " + suffix + " for file: " + name);
            }
            if (check) {
                this.checkFile(file);
            }
        }
    }

    private void checkFile(File file) throws Exception {
        RandomAccessFile in = new RandomAccessFile(file, "r");
        byte[] data = new byte[(int)file.length()];
        in.readFully(data);
        in.close();
        int line = 1;
        for (int i = 0; i < data.length; ++i) {
            char ch = (char)(data[i] & 0xFF);
            if (ch > '\u007f') {
                this.fail(file, "contains character " + ch, line);
                continue;
            }
            if (ch >= ' ') continue;
            if (ch == '\n') {
                ++line;
                continue;
            }
            if (ch == '\r' || ch == '\t') continue;
            this.fail(file, "contains character " + ch, line);
        }
    }

    private void fail(File file, String error, int line) {
        System.out.println("File " + file.getName() + " " + error + " at line " + line);
        if (this.failOnError) {
            throw new Error("FAIL");
        }
    }
}

