/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Schema;
import org.h2.engine.SchemaObject;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.table.Table;

public class Sequence
extends SchemaObject {
    private static final int BLOCK_INCREMENT = 32;
    private long value = 1L;
    private long valueWithMargin;
    private long increment = 1L;
    private boolean belongsToTable;

    public Sequence(Schema schema, int id, String name, boolean belongsToTable) {
        super(schema, id, name, "sequence");
        this.belongsToTable = belongsToTable;
    }

    public void setStartValue(long value) {
        this.value = value;
        this.valueWithMargin = value;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public void setIncrement(long inc) throws JdbcSQLException {
        if (this.increment == 0L) {
            throw Message.getSQLException(90009, new String[]{"0", "INCREMENT"}, null);
        }
        this.increment = inc;
    }

    public String getCreateSQLForCopy(Table table, String quotedTable, String quotedName) {
        throw Message.internal();
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE SEQUENCE ");
        buff.append(this.getSQL());
        buff.append(" START WITH ");
        buff.append(this.valueWithMargin);
        if (this.increment != 1L) {
            buff.append(" INCREMENT BY ");
            buff.append(this.increment);
        }
        if (this.belongsToTable) {
            buff.append(" BELONGS_TO_TABLE");
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNext(Session session) throws SQLException {
        Sequence sequence = this;
        synchronized (sequence) {
            if (this.value >= this.valueWithMargin) {
                this.valueWithMargin += 32L;
                this.flush(session);
            }
            long v = this.value;
            this.value += this.increment;
            return v;
        }
    }

    private void flush(Session session) throws SQLException {
        this.database.update(session, this);
    }

    public void close(Session session) throws SQLException {
        this.valueWithMargin = this.value;
        this.flush(session);
    }

    public int getType() {
        return 3;
    }

    public void removeChildrenAndResources(Session session) {
        this.invalidate();
    }

    public void checkRename() {
    }

    public long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean b) {
        this.belongsToTable = b;
    }
}

