/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DataPageText;
import org.h2.store.FileStore;
import org.h2.store.LogSystem;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.util.BitField;
import org.h2.util.Cache;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.FileUtils;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;

public class DiskFile
implements CacheWriter {
    public static final int BLOCK_SIZE = 128;
    static final int BLOCK_PAGE_PAGE_SHIFT = 6;
    public static final int BLOCKS_PER_PAGE = 64;
    private static final int OFFSET = 48;
    private Database database;
    private String fileName;
    private FileStore file;
    private BitField used = new BitField();
    private BitField deleted = new BitField();
    private int fileBlockCount;
    private IntArray pageOwners = new IntArray();
    private Cache cache;
    private LogSystem log;
    private DataPage rowBuff;
    private DataPage freeBlock;
    private boolean dataFile;
    private boolean logChanges;
    private int recordOverhead;
    private boolean init;
    private boolean initAlreadyTried;

    public DiskFile(Database database, String fileName, boolean dataFile, boolean logChanges, int cacheSize) throws SQLException {
        this.database = database;
        this.log = database.getLog();
        this.fileName = fileName;
        this.dataFile = dataFile;
        this.logChanges = logChanges;
        this.cache = new Cache(this, cacheSize);
        this.rowBuff = DataPage.create((DataHandler)database, 128);
        this.recordOverhead = 2 * this.rowBuff.getIntLen() + 1 + this.rowBuff.getFillerLength();
        this.freeBlock = DataPage.create((DataHandler)database, 128);
        this.freeBlock.fill(128);
        this.freeBlock.updateChecksum();
        try {
            if (FileUtils.exists(fileName)) {
                this.file = database.openFile(fileName);
            } else {
                this.create();
            }
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
    }

    void setBlockCount(int count) {
        this.fileBlockCount = count;
        int pages = this.getPage(count);
        while (pages >= this.pageOwners.size()) {
            this.pageOwners.add(-1);
        }
    }

    int getBlockCount() {
        return this.fileBlockCount;
    }

    private void create() throws SQLException {
        try {
            this.file = this.database.openFile(this.fileName);
            DataPage header = DataPage.create((DataHandler)this.database, 48);
            this.file.seek(48L);
            header.fill(48);
            header.updateChecksum();
            this.file.write(header.getBytes(), 0, 48);
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    public byte[] getSummary() throws SQLException {
        try {
            int i;
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(buff);
            int blocks = (int)((this.file.length() - 48L) / 128L);
            out.writeInt(blocks);
            int x = 0;
            for (int i2 = 0; i2 < blocks / 8; ++i2) {
                int mask = 0;
                for (int j = 0; j < 8; ++j) {
                    if (this.used.get(x)) {
                        mask |= 1 << j;
                    }
                    ++x;
                }
                out.write(mask);
            }
            out.writeInt(this.pageOwners.size());
            ObjectArray storages = new ObjectArray();
            for (i = 0; i < this.pageOwners.size(); ++i) {
                int s = this.pageOwners.get(i);
                out.writeInt(s);
                if (s < 0 || s < storages.size() && storages.get(s) != null) continue;
                Storage storage = this.database.getStorage(s, this);
                while (storages.size() <= s) {
                    storages.add(null);
                }
                storages.set(s, storage);
            }
            for (i = 0; i < storages.size(); ++i) {
                Storage storage = (Storage)storages.get(i);
                if (storage == null) continue;
                out.writeInt(i);
                out.writeInt(storage.getRecordCount());
            }
            out.writeInt(-1);
            out.close();
            byte[] b2 = buff.toByteArray();
            return b2;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void initFromSummary(byte[] summary) {
        if (summary == null || summary.length == 0) {
            this.init = false;
            return;
        }
        if (this.database.getRecovery() || this.initAlreadyTried) {
            return;
        }
        this.initAlreadyTried = true;
        try {
            int s;
            Storage storage;
            int blocks = (int)((this.file.length() - 48L) / 128L);
            this.setBlockCount(blocks);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(summary));
            int b2 = in.readInt();
            int x = 0;
            for (int i = 0; i < b2 / 8; ++i) {
                int mask = in.read();
                for (int j = 0; j < 8; ++j) {
                    if ((mask & 1 << j) != 0) {
                        this.used.set(x);
                    }
                    ++x;
                }
            }
            int len = in.readInt();
            ObjectArray storages = new ObjectArray();
            for (int i = 0; i < len; ++i) {
                int s2 = in.readInt();
                if (s2 >= 0) {
                    storage = this.database.getStorage(s2, this);
                    while (storages.size() <= s2) {
                        storages.add(null);
                    }
                    storages.set(s2, storage);
                    storage.addPage(i);
                }
                this.setPageOwner(i, s2);
            }
            while ((s = in.readInt()) >= 0) {
                int recordCount = in.readInt();
                storage = (Storage)storages.get(s);
                storage.setRecordCount(recordCount);
            }
            this.init = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init() throws SQLException {
        if (this.init) {
            return;
        }
        ObjectArray storages = this.database.getAllStorages();
        for (int i = 0; i < storages.size(); ++i) {
            Storage s = (Storage)storages.get(i);
            if (s == null || s.getDiskFile() != this) continue;
            s.setRecordCount(0);
        }
        try {
            int blocks = (int)((this.file.length() - 48L) / 128L);
            this.setBlockCount(blocks);
            int blockHeaderLen = Math.max(16, 2 * this.rowBuff.getIntLen());
            byte[] buff = new byte[blockHeaderLen];
            DataPage s = DataPage.create((DataHandler)this.database, buff);
            long time = 0L;
            int i = 0;
            while (i < blocks) {
                long t2 = System.currentTimeMillis();
                if (t2 > time + 10L) {
                    time = t2;
                    this.database.setProgress(0, this.fileName, i, blocks);
                }
                this.go(i);
                this.file.readFully(buff, 0, blockHeaderLen);
                s.reset();
                int blockCount = s.readInt();
                if (Constants.CHECK && blockCount < 0) {
                    throw Message.internal();
                }
                if (blockCount == 0) {
                    this.setUnused(i, 1);
                    ++i;
                    continue;
                }
                int id = s.readInt();
                if (Constants.CHECK && id < 0) {
                    throw Message.internal();
                }
                Storage storage = this.database.getStorage(id, this);
                this.setBlockOwner(storage, i, blockCount, true);
                storage.incrementRecordCount();
                i += blockCount;
            }
            this.database.setProgress(0, this.fileName, blocks, blocks);
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    void flushRecord(Record rec) throws SQLException {
        this.writeBack(rec);
    }

    void flush() throws SQLException {
        int i;
        ObjectArray list = this.cache.getAllChanged();
        for (i = 0; i < list.size(); ++i) {
            Record rec = (Record)list.get(i);
            this.writeBack(rec);
        }
        for (i = 0; i < this.fileBlockCount && (i = this.deleted.nextSetBit(i)) >= 0; ++i) {
            if (!this.deleted.get(i)) continue;
            this.writeDirectDeleted(i, 1);
            this.deleted.clear(i);
        }
    }

    public void close() throws SQLException {
        SQLException closeException = null;
        if (!this.database.getReadOnly()) {
            try {
                this.flush();
            }
            catch (SQLException e) {
                closeException = e;
            }
        }
        this.cache.clear();
        if (this.file != null) {
            block7: {
                try {
                    this.file.close();
                }
                catch (Exception e) {
                    if (closeException != null) break block7;
                    closeException = Message.convert(e);
                }
            }
            this.file = null;
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    void go(int pos) throws SQLException {
        this.file.seek((long)pos * 128L + 48L);
    }

    Record getRecordIfStored(int pos, RecordReader reader, int storageId) throws SQLException {
        try {
            this.go(pos);
            this.rowBuff.reset();
            byte[] buff = this.rowBuff.getBytes();
            this.file.readFully(buff, 0, 128);
            DataPage s = DataPage.create((DataHandler)this.database, buff);
            s.readInt();
            int id = s.readInt();
            if (id != storageId) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.getRecord(pos, reader, storageId);
    }

    Record getRecord(int pos, RecordReader reader, int storageId) throws SQLException {
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
        DiskFile diskFile = this;
        synchronized (diskFile) {
            Record record = (Record)this.cache.get(pos);
            if (record != null) {
                return record;
            }
            try {
                this.go(pos);
                this.rowBuff.reset();
                byte[] buff = this.rowBuff.getBytes();
                this.file.readFully(buff, 0, 128);
                DataPage s = DataPage.create((DataHandler)this.database, buff);
                int blockCount = s.readInt();
                int id = s.readInt();
                if (Constants.CHECK && storageId != id) {
                    throw Message.internal("File ID mismatch got=" + id + " expected=" + storageId + " pos=" + pos);
                }
                if (Constants.CHECK && blockCount == 0) {
                    throw Message.internal("0 blocks to read pos=" + pos);
                }
                if (blockCount > 1) {
                    byte[] b2 = new byte[blockCount * 128];
                    System.arraycopy(buff, 0, b2, 0, 128);
                    buff = b2;
                    this.file.readFully(buff, 128, blockCount * 128 - 128);
                    s = DataPage.create((DataHandler)this.database, buff);
                    s.readInt();
                    s.readInt();
                }
                s.check(blockCount * 128);
                Record r = reader.read(s);
                r.setStorageId(storageId);
                r.setPos(pos);
                r.setBlockCount(blockCount);
                this.cache.put(r);
                return r;
            }
            catch (Exception e) {
                throw Message.convert(e);
            }
        }
    }

    int allocate(Storage storage, int blockCount) throws SQLException {
        int i;
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
        blockCount = this.getPage(blockCount + 64 - 1) * 64;
        int lastPage = this.getPage(this.getBlockCount());
        int pageCount = this.getPage(blockCount);
        int pos = -1;
        boolean found = false;
        for (i = 0; i < lastPage; ++i) {
            found = true;
            for (int j = i; j < i + pageCount; ++j) {
                if (j < lastPage && this.getPageOwner(j) == -1) continue;
                found = false;
                break;
            }
            if (!found) continue;
            pos = i * 64;
            break;
        }
        if (!found) {
            int max = this.getBlockCount();
            pos = MathUtils.roundUp(max, 64);
            if (this.rowBuff instanceof DataPageText) {
                if (pos > max) {
                    this.writeDirectDeleted(max, pos - max);
                }
                this.writeDirectDeleted(pos, blockCount);
            } else {
                long min = ((long)pos + (long)blockCount) * 128L;
                if ((min = MathUtils.scaleUp50Percent(131072L, min, 8192L) + 48L) > this.file.length()) {
                    this.file.setLength(min);
                }
            }
        }
        this.setBlockOwner(storage, pos, blockCount, false);
        for (i = 0; i < blockCount; ++i) {
            storage.free(i + pos, 1);
        }
        return pos;
    }

    private void setBlockOwner(Storage storage, int pos, int blockCount, boolean inUse) throws SQLException {
        if (pos + blockCount > this.fileBlockCount) {
            this.setBlockCount(pos + blockCount);
        }
        if (!inUse) {
            this.setUnused(pos, blockCount);
        }
        for (int i = this.getPage(pos); i <= this.getPage(pos + blockCount - 1); ++i) {
            this.setPageOwner(i, storage.getId());
        }
        if (inUse) {
            this.used.setRange(pos, blockCount, true);
            this.deleted.setRange(pos, blockCount, false);
        }
    }

    private void setUnused(int pos, int blockCount) throws SQLException {
        if (pos + blockCount > this.fileBlockCount) {
            this.setBlockCount(pos + blockCount);
        }
        for (int i = pos; i < pos + blockCount; ++i) {
            this.used.clear(i);
            if (i % 64 != 0 || pos + blockCount < i + 64) continue;
            this.setPageOwner(this.getPage(i), -1);
        }
    }

    int getPage(int pos) {
        return pos >>> 6;
    }

    int getPageOwner(int page) {
        if (page * 64 > this.fileBlockCount) {
            return -1;
        }
        return this.pageOwners.get(page);
    }

    void setPageOwner(int page, int storageId) throws SQLException {
        int old = this.pageOwners.get(page);
        if (old == storageId) {
            return;
        }
        if (Constants.CHECK && old >= 0 && storageId >= 0 && old != storageId) {
            for (int i = 0; i < 64; ++i) {
                if (!this.used.get(i + page * 64)) continue;
                throw Message.internal("double allocation");
            }
        }
        if (old >= 0) {
            this.database.getStorage(old, this).removePage(page);
            if (!this.logChanges) {
                this.writeDirectDeleted(page * 64, 64);
            }
        }
        if (storageId >= 0) {
            this.database.getStorage(storageId, this).addPage(page);
        }
        this.pageOwners.set(page, storageId);
    }

    void setUsed(int pos, int blockCount) {
        if (pos + blockCount > this.fileBlockCount) {
            this.setBlockCount(pos + blockCount);
        }
        this.used.setRange(pos, blockCount, true);
        this.deleted.setRange(pos, blockCount, false);
    }

    public void delete() throws SQLException {
        try {
            this.cache.clear();
            this.file.close();
            FileUtils.delete(this.fileName);
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
        finally {
            this.file = null;
            this.fileName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBack(CacheObject obj) throws SQLException {
        Record record = (Record)obj;
        DiskFile diskFile = this;
        synchronized (diskFile) {
            try {
                this.go(record.getPos());
                DataPage buff = this.rowBuff;
                buff.reset();
                int blockCount = record.getBlockCount();
                buff.checkCapacity(blockCount * 128);
                buff.writeInt(blockCount);
                buff.writeInt(record.getStorageId());
                record.write(buff);
                buff.fill(blockCount * 128);
                buff.updateChecksum();
                this.file.write(buff.getBytes(), 0, buff.length());
            }
            catch (Exception e) {
                throw Message.convert(e);
            }
        }
        record.setChanged(false);
    }

    BitField getUsed() {
        return this.used;
    }

    public void updateRecord(Session session, Record record) throws SQLException {
        try {
            record.setChanged(true);
            int pos = record.getPos();
            if (Constants.CHECK) {
                Record old = (Record)this.cache.get(pos);
                if (old != record) {
                    this.database.checkPowerOff();
                    throw Message.internal("old != record");
                }
                int blockCount = record.getBlockCount();
                for (int i = 0; i < blockCount; ++i) {
                    if (!this.deleted.get(i + pos)) continue;
                    throw Message.internal("update marked as deleted: " + (i + pos));
                }
            }
            if (this.logChanges) {
                this.log.add(session, this, record);
            }
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDirectDeleted(int recordId, int blockCount) throws SQLException {
        DiskFile diskFile = this;
        synchronized (diskFile) {
            try {
                this.go(recordId);
                for (int i = 0; i < blockCount; ++i) {
                    this.file.write(this.freeBlock.getBytes(), 0, this.freeBlock.length());
                }
                this.free(recordId, blockCount);
            }
            catch (Exception e) {
                throw Message.convert(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDirect(Storage storage, int pos, int blockCount, DataPage buff) throws SQLException {
        DiskFile diskFile = this;
        synchronized (diskFile) {
            try {
                this.go(pos);
                DataPage all = this.rowBuff;
                all.reset();
                all.writeInt(blockCount);
                all.writeInt(storage.getId());
                all.writeDataPageNoSize(buff);
                all.fill(blockCount * 128);
                all.updateChecksum();
                this.file.write(all.getBytes(), 0, all.length());
                this.setBlockOwner(storage, pos, blockCount, true);
            }
            catch (Exception e) {
                throw Message.convert(e);
            }
        }
    }

    void removeRecord(Session session, int pos, Record record, int blockCount) throws SQLException {
        if (this.logChanges) {
            this.log.add(session, this, record);
        }
        this.cache.remove(pos);
        this.deleted.setRange(pos, blockCount, true);
        this.setUnused(pos, blockCount);
    }

    void addRecord(Session session, Record record) throws SQLException {
        if (this.logChanges) {
            this.log.add(session, this, record);
        }
        this.cache.put(record);
    }

    public Cache getCache() {
        return this.cache;
    }

    void free(int pos, int blockCount) {
        this.used.setRange(pos, blockCount, false);
    }

    public int getRecordOverhead() {
        return this.recordOverhead;
    }

    public void truncateStorage(Session session, int storageId) throws SQLException {
        for (int i = 0; i < this.pageOwners.size(); ++i) {
            if (this.pageOwners.get(i) != storageId) continue;
            if (this.logChanges) {
                this.log.addTruncate(session, this, storageId, i * 64, 64);
            }
            for (int j = 0; j < 64; ++j) {
                Record r = (Record)this.cache.getNoMoveToFront(i * 64 + j);
                if (r == null) continue;
                this.cache.remove(r.getPos());
            }
            this.deleted.setRange(i * 64, 64, true);
            this.setUnused(i * 64, 64);
        }
    }

    public void sync() {
        if (this.file != null) {
            this.file.sync();
        }
    }

    public boolean isDataFile() {
        return this.dataFile;
    }

    public void setLogChanges(boolean b) {
        this.logChanges = b;
    }
}

