/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.jdbc.JdbcConnection;
import org.h2.test.TestBase;
import org.h2.tools.FileBase;
import org.h2.util.FileUtils;

public class TestPowerOff
extends TestBase {
    private String dbName = "powerOff";
    private String dir;
    private String url;
    private int maxPowerOffCount;

    public void test() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.dir = this.config.big ? BASE_DIR : "inmemory:";
        this.url = this.dir + "/" + this.dbName + ";file_lock=no";
        this.testCrash();
        this.testShutdown();
        this.testNoIndexFile();
        this.testMemoryTables();
        this.testPersistentTables();
    }

    private void testCrash() throws Exception {
        if (this.config.networked) {
            return;
        }
        this.deleteDb(this.dir, this.dbName);
        Random random = new Random(1L);
        Constants.RUN_FINALIZERS = false;
        int repeat = this.getSize(1, 20);
        for (int i = 0; i < repeat; ++i) {
            Connection conn = this.getConnection(this.url);
            conn.close();
            conn = this.getConnection(this.url);
            Statement stat = conn.createStatement();
            stat.execute("SET WRITE_DELAY 0");
            ((JdbcConnection)conn).setPowerOffCount(random.nextInt(100));
            try {
                stat.execute("DROP TABLE IF EXISTS TEST");
                stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
                conn.setAutoCommit(false);
                int len = this.getSize(3, 100);
                for (int j = 0; j < len; ++j) {
                    stat.execute("INSERT INTO TEST VALUES(" + j + ", 'Hello')");
                    if (random.nextInt(5) == 0) {
                        conn.commit();
                    }
                    if (random.nextInt(10) != 0) continue;
                    stat.execute("DROP TABLE IF EXISTS TEST");
                    stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
                }
                stat.execute("DROP TABLE IF EXISTS TEST");
                conn.close();
                continue;
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("90098")) continue;
                e.printStackTrace();
            }
        }
    }

    private void testShutdown() throws Exception {
        this.deleteDb(this.dir, this.dbName);
        Connection conn = this.getConnection(this.url);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("SHUTDOWN");
        conn.close();
        conn = this.getConnection(this.url);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        this.check(rs.next());
        this.checkFalse(rs.next());
        conn.close();
    }

    private void testNoIndexFile() throws Exception {
        if (this.config.networked) {
            return;
        }
        this.deleteDb(this.dir, this.dbName);
        Connection conn = this.getConnection(this.url);
        Statement stat = conn.createStatement();
        stat.execute("CREATE MEMORY TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        ((JdbcConnection)conn).setPowerOffCount(1);
        try {
            stat.execute("INSERT INTO TEST VALUES(2, 'Hello')");
            stat.execute("CHECKPOINT");
            this.error("should not work!");
        }
        catch (SQLException e) {
            // empty catch block
        }
        boolean deleted = false;
        ArrayList files = FileBase.getDatabaseFiles(this.dir, this.dbName, false);
        for (int i = 0; i < files.size(); ++i) {
            String fileName = (String)files.get(i);
            if (!fileName.endsWith(".index.db")) continue;
            FileUtils.delete(fileName);
            deleted = true;
        }
        this.check(deleted);
        conn = this.getConnection(this.url);
        conn.close();
    }

    private void testMemoryTables() throws Exception {
        if (this.config.networked) {
            return;
        }
        this.deleteDb(this.dir, this.dbName);
        Connection conn = this.getConnection(this.url);
        Statement stat = conn.createStatement();
        stat.execute("CREATE MEMORY TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("CHECKPOINT");
        ((JdbcConnection)conn).setPowerOffCount(1);
        try {
            stat.execute("INSERT INTO TEST VALUES(2, 'Hello')");
            stat.execute("INSERT INTO TEST VALUES(3, 'Hello')");
            stat.execute("CHECKPOINT");
            this.error("should have failed!");
        }
        catch (Exception e) {
            // empty catch block
        }
        ((JdbcConnection)conn).setPowerOffCount(0);
        conn = this.getConnection(this.url);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM TEST");
        rs.next();
        this.check(rs.getInt(1), 1L);
        conn.close();
    }

    private void testPersistentTables() throws Exception {
        if (this.config.networked) {
            return;
        }
        this.deleteDb(this.dir, this.dbName);
        this.testRun(true);
        int max = this.maxPowerOffCount;
        this.trace("max=" + max);
        this.runTest(0, max, true);
        this.recoverAndCheckConsistency();
        this.runTest(0, max, false);
        this.recoverAndCheckConsistency();
    }

    void runTest(int min, int max, boolean withConsistencyCheck) throws Exception {
        for (int i = min; i < max; ++i) {
            this.deleteDb(this.dir, this.dbName);
            Database.setInitialPowerOffCount(i);
            int expect = this.testRun(false);
            if (withConsistencyCheck) {
                int got = this.recoverAndCheckConsistency();
                this.trace("test " + i + " of " + max + " expect=" + expect + " got=" + got);
                continue;
            }
            this.trace("test " + i + " of " + max + " expect=" + expect);
        }
        Database.setInitialPowerOffCount(0);
    }

    int testRun(boolean init) throws Exception {
        int state;
        block4: {
            if (init) {
                Database.setInitialPowerOffCount(Integer.MAX_VALUE);
            }
            state = 0;
            try {
                Connection conn = this.getConnection(this.url);
                Statement stat = conn.createStatement();
                stat.execute("SET WRITE_DELAY 0");
                stat.execute("CREATE TABLE IF NOT EXISTS TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
                state = 1;
                conn.setAutoCommit(false);
                stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
                stat.execute("INSERT INTO TEST VALUES(2, 'World')");
                conn.commit();
                state = 2;
                stat.execute("UPDATE TEST SET NAME='Hallo' WHERE ID=1");
                stat.execute("UPDATE TEST SET NAME='Welt' WHERE ID=2");
                conn.commit();
                state = 3;
                stat.execute("DELETE FROM TEST WHERE ID=1");
                stat.execute("DELETE FROM TEST WHERE ID=2");
                conn.commit();
                state = 1;
                stat.execute("DROP TABLE TEST");
                state = 0;
                if (init) {
                    this.maxPowerOffCount = Integer.MAX_VALUE - ((JdbcConnection)conn).getPowerOffCount();
                }
                conn.close();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("90098")) break block4;
                throw e;
            }
        }
        return state;
    }

    int recoverAndCheckConsistency() throws Exception {
        int state;
        Database.setInitialPowerOffCount(0);
        Connection conn = this.getConnection(this.url);
        if (((JdbcConnection)conn).getPowerOffCount() != 0) {
            this.error("power off count is not 0");
        }
        Statement stat = conn.createStatement();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getTables(null, null, "TEST", null);
        if (!rs.next()) {
            state = 0;
        } else {
            rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
            if (!rs.next()) {
                state = 1;
            } else {
                this.check(rs.getInt(1), 1L);
                String name1 = rs.getString(2);
                this.check(rs.next());
                this.check(rs.getInt(1), 2L);
                String name2 = rs.getString(2);
                this.checkFalse(rs.next());
                if ("Hello".equals(name1)) {
                    this.check(name2, "World");
                    state = 2;
                } else {
                    this.check(name1, "Hallo");
                    this.check(name2, "Welt");
                    state = 3;
                }
            }
        }
        conn.close();
        return state;
    }
}

