/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.test.TestBase;

public class TestTwoPhaseCommit
extends TestBase {
    public void test() throws Exception {
        if (this.config.memory || this.config.networked) {
            return;
        }
        this.prepare();
        this.openWith(true);
        this.test(true);
        this.prepare();
        this.openWith(false);
        this.test(false);
    }

    void test(boolean rolledBack) throws Exception {
        Connection conn = this.getConnection("twoPhaseCommit");
        Statement stat = conn.createStatement();
        stat.execute("SET WRITE_DELAY 0");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getString(2), "Hello");
        if (!rolledBack) {
            rs.next();
            this.check(rs.getInt(1), 2L);
            this.check(rs.getString(2), "World");
        }
        this.checkFalse(rs.next());
        conn.close();
    }

    void openWith(boolean rollback) throws Exception {
        Connection conn = this.getConnection("twoPhaseCommit");
        Statement stat = conn.createStatement();
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT");
        while (rs.next()) {
            list.add(rs.getString("TRANSACTION"));
        }
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            if (rollback) {
                stat.execute("ROLLBACK TRANSACTION " + s);
                continue;
            }
            stat.execute("COMMIT TRANSACTION " + s);
        }
        conn.close();
    }

    void prepare() throws Exception {
        this.deleteDb("twoPhaseCommit");
        Connection conn = this.getConnection("twoPhaseCommit");
        Statement stat = conn.createStatement();
        stat.execute("SET WRITE_DELAY 0");
        conn.setAutoCommit(false);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        conn.commit();
        stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        stat.execute("PREPARE COMMIT XID_TEST_TRANSACTION_WITH_LONG_NAME");
        this.crash(conn);
    }
}

