/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.h2.message.Message;
import org.h2.util.ReaderInputStream;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class TypeConverter {
    private static final int BUFFER_BLOCK_SIZE = 8192;

    public static byte[] serialize(Object obj) throws SQLException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw Message.getSQLException(90026, null, e);
        }
    }

    public static Object deserialize(byte[] data) throws SQLException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(in);
            Object obj = is.readObject();
            return obj;
        }
        catch (Throwable e) {
            throw Message.getSQLException(90027, null, e);
        }
    }

    public static Reader getReader(InputStream in) throws SQLException {
        try {
            return new BufferedReader(new InputStreamReader(in, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw Message.convert(e);
        }
    }

    public static InputStream getInputStream(String s) throws SQLException {
        return new ByteArrayInputStream(StringUtils.utf8Encode(s));
    }

    public static InputStream getInputStream(Reader x) throws SQLException {
        return new ReaderInputStream(x);
    }

    public static Reader getReader(String s) {
        return new StringReader(s);
    }

    public static String getString(Reader in, int length) throws SQLException {
        try {
            int len = Math.min(length, 8192);
            CharArrayWriter out = new CharArrayWriter(len);
            char[] buff = new char[8192];
            while (length > 0 && (len = in.read(buff, 0, len)) >= 0) {
                out.write(buff, 0, len);
                length -= len;
                len = Math.min(length, 8192);
            }
            out.close();
            return out.toString();
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public static byte[] getBytes(InputStream in, int length) throws SQLException {
        try {
            int len = Math.min(length, 8192);
            ByteArrayOutputStream out = new ByteArrayOutputStream(len);
            byte[] buff = new byte[len];
            while (length > 0 && (len = in.read(buff, 0, len)) >= 0) {
                out.write(buff, 0, len);
                length -= len;
                len = Math.min(length, 8192);
            }
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public static Date convertDateToCalendar(Date x, Calendar calendar) throws SQLException {
        return x == null ? x : new Date(TypeConverter.getLocalTime(x, calendar));
    }

    public static Time convertTimeToCalendar(Time x, Calendar calendar) throws SQLException {
        return x == null ? x : new Time(TypeConverter.getLocalTime(x, calendar));
    }

    public static Timestamp convertTimestampToCalendar(Timestamp x, Calendar calendar) throws SQLException {
        if (x != null) {
            Timestamp y = new Timestamp(TypeConverter.getLocalTime(x, calendar));
            y.setNanos(x.getNanos());
            x = y;
        }
        return x;
    }

    public static Value convertDateToUniversal(Date x, Calendar source) throws SQLException {
        return ValueDate.get(new Date(TypeConverter.getUniversalTime(source, x)));
    }

    public static Value convertTimeToUniversal(Time x, Calendar source) throws SQLException {
        return ValueTime.get(new Time(TypeConverter.getUniversalTime(source, x)));
    }

    public static Value convertTimestampToUniversal(Timestamp x, Calendar source) throws SQLException {
        Timestamp y = new Timestamp(TypeConverter.getUniversalTime(source, x));
        y.setNanos(x.getNanos());
        return ValueTimestamp.get(y);
    }

    private static long getUniversalTime(Calendar source, java.util.Date x) throws SQLException {
        if (source == null) {
            throw Message.getInvalidValueException("calendar", null);
        }
        source = (Calendar)source.clone();
        Calendar universal = Calendar.getInstance();
        source.setTime(x);
        TypeConverter.convertTime(source, universal);
        return universal.getTime().getTime();
    }

    private static long getLocalTime(java.util.Date x, Calendar target) throws SQLException {
        if (target == null) {
            throw Message.getInvalidValueException("calendar", null);
        }
        target = (Calendar)target.clone();
        Calendar local = Calendar.getInstance();
        local.setTime(x);
        TypeConverter.convertTime(local, target);
        return target.getTime().getTime();
    }

    private static void convertTime(Calendar from, Calendar to) {
        to.set(1, from.get(1));
        to.set(2, from.get(2));
        to.set(5, from.get(5));
        to.set(11, from.get(11));
        to.set(12, from.get(12));
        to.set(13, from.get(13));
        to.set(14, from.get(14));
    }

    public static Reader getAsciiReader(InputStream x) throws SQLException {
        try {
            return new InputStreamReader(x, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw Message.convert(e);
        }
    }

    public static int readFully(InputStream in, byte[] buffer, int max) throws IOException {
        int l;
        int off = 0;
        int len = Math.min(max, buffer.length);
        while ((l = len - off) > 0 && (l = in.read(buffer, off, l)) != -1) {
            off += l;
        }
        return off;
    }

    public static int readFully(Reader in, char[] buffer, int max) throws IOException {
        int l;
        int off = 0;
        int len = Math.min(max, buffer.length);
        while ((l = len - off) > 0 && (l = in.read(buffer, off, l)) != -1) {
            off += l;
        }
        return off;
    }
}

