/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import sbaz.EmptyUniverse;
import sbaz.FormatError;
import sbaz.SimpleUniverse;
import sbaz.Universe;
import sbaz.Universe$;
import sbaz.UniverseTest$;
import sbaz.Version;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-2\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\t!\u0002\u0002\r+:Lg/\u001a:tKR+7\u000f\u001e\u0006\u0002\u0007\u0005!1OY1{\u0007\u0001\u00192\u0001\u0001\u0004\u000f!\t9A\"D\u0001\t\u0015\tI!\"A\u0005ge\u0006lWm^8sW*\t1\"A\u0003kk:LG/\u0003\u0002\u000e\u0011\tAA+Z:u\u0007\u0006\u001cX\r\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002CA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003M!Xm\u001d;TS6\u0004H.\u001a(pi\u0006$\u0018n\u001c82+\u0005a\u0002CA\b\u001e\u0013\tq\u0002C\u0001\u0003V]&$\b\"\u0002\u0011\u0001\t\u0003Y\u0012a\u0005;fgR\u001c\u0016.\u001c9mK:{G/\u0019;j_:\u0014\u0004\"\u0002\u0012\u0001\t\u0003Y\u0012a\u0005;fgR\u001c\u0016.\u001c9mK:{G/\u0019;j_:\u001c\u0004\"\u0002\u0013\u0001\t\u0003Y\u0012!\u0006;fgR\u001c\u0016.\u001c9mK:{G/\u0019;j_:\u0014\u0015\r\u001a\u0005\u0006M\u0001!\taG\u0001\ni\u0016\u001cHo\u0014:eKJDQ\u0001\u000b\u0001\u0005\u0002m\tA\u0002^3ti>#\b.\u001a:PaNDQA\u000b\u0001\u0005\u0002m\tA\u0002^3tiR{7\u000b\u001e:j]\u001e\u0004")
public class UniverseTest
extends TestCase
implements ScalaObject {
    public void testSimpleNotation1() {
        Universe univ1 = Universe$.MODULE$.fromString("\n      <overrideuniverse>\n        <components>\n          <simpleuniverse>\n            <name>scala-dev</name>\n            <location>http://scbaztmp.lexspoon.org:8006/scala-dev</location>\n          </simpleuniverse>\n          <simpleuniverse>\n            <name>local-hacks</name>\n            <location>http://localhost/sbaz/local-hacks</location>\n          </simpleuniverse>\n        </components>\n      </overrideuniverse>");
        Universe univ2 = Universe$.MODULE$.fromString("\n        scala-dev http://scbaztmp.lexspoon.org:8006/scala-dev\n        local-hacks http://localhost/sbaz/local-hacks\n        ");
        String string = univ1.toString();
        String string2 = univ2.toString();
        Assert.assertTrue((String)new StringBuilder().append((Object)univ1.toString()).append((Object)" vs. ").append((Object)univ2.toString()).toString(), (!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
    }

    public void testSimpleNotation2() {
        SimpleUniverse univ1 = new SimpleUniverse("scala-dev", new URL("http://scbaztmp.lexspoon.org:8006/scala-dev"));
        Universe univ2 = Universe$.MODULE$.fromString("\n        scala-dev http://scbaztmp.lexspoon.org:8006/scala-dev\n        ");
        String string = univ1.toString();
        String string2 = univ2.toString();
        Assert.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
    }

    public void testSimpleNotation3() {
        EmptyUniverse univ1 = new EmptyUniverse();
        Universe univ2 = Universe$.MODULE$.fromString("\n        ");
        String string = univ1.toString();
        String string2 = univ2.toString();
        Assert.assertTrue((String)new StringBuilder().append((Object)univ1.toString()).append((Object)" vs. ").append((Object)univ2.toString()).toString(), (!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
    }

    public void testSimpleNotationBad() {
        boolean threw = false;
        Universe exceptionResult1 = null;
        try {
            exceptionResult1 = Universe$.MODULE$.fromString("a http://foo.bar/sbaz def");
        }
        catch (FormatError formatError) {
            threw = true;
            exceptionResult1 = BoxedUnit.UNIT;
        }
        Assert.assertTrue((boolean)threw);
    }

    public void testOrder() {
        List sorted;
        List stringsInOrder = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "abc", "abcd", "abd", "1", "1.1", "1.1a", "1.1a2", "1.1a100", "1.1.5", "1.2", "1.2.", "2", "12"}));
        List inOrder = (List)stringsInOrder.map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom());
        List stringsOutOfOrder = stringsInOrder.reverse();
        List outOfOrder = (List)stringsOutOfOrder.map((Function1)new $anonfun$2(this), List$.MODULE$.canBuildFrom());
        List list = sorted = (List)outOfOrder.sortWith((Function2)new $anonfun$3(this));
        List list2 = inOrder;
        Assert.assertTrue((!(list != null ? !list.equals(list2) : list2 != null) ? 1 : 0) != 0);
    }

    public void testOtherOps() {
        Version version;
        Assert.assertTrue((boolean)new Version("1").$less((Object)new Version("2")));
        Assert.assertTrue((boolean)new Version("1").$less$eq((Object)new Version("2")));
        Assert.assertTrue((boolean)new Version("2").$greater((Object)new Version("1")));
        Version version2 = version = new Version("1.5");
        Assert.assertTrue((!(version2 != null ? !version2.equals(version) : version != null) ? 1 : 0) != 0);
    }

    public void testToString() {
        String string = new Version("1.5a").toString();
        String string2 = "1.5a";
        Assert.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
        String string3 = new Version("").toString();
        String string4 = "";
        Assert.assertTrue((!(string3 != null ? !string3.equals(string4) : string4 != null) ? 1 : 0) != 0);
    }
}

