/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class FlatHashTable$class {
    public static int loadFactor(FlatHashTable $this) {
        return 450;
    }

    public static final int loadFactorDenum(FlatHashTable $this) {
        return 1000;
    }

    public static int initialSize(FlatHashTable $this) {
        return 16;
    }

    private static int capacity(FlatHashTable $this, int expectedSize) {
        return expectedSize == 0 ? 1 : HashTable$.MODULE$.powerOfTwo(expectedSize);
    }

    private static int initialCapacity(FlatHashTable $this) {
        return FlatHashTable$class.capacity($this, $this.initialSize());
    }

    public static void init(FlatHashTable $this, ObjectInputStream in, Function1 f) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        Predef$.MODULE$.assert(size2 >= 0);
        $this.table_$eq(new Object[FlatHashTable$class.capacity($this, size2 * $this.loadFactorDenum() / $this._loadFactor())]);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, Predef$.MODULE$.refArrayOps($this.table()).size()));
        for (int index2 = 0; index2 < size2; ++index2) {
            Object elem = in.readObject();
            f.apply(elem);
            $this.addEntry(elem);
        }
    }

    public static void serializeTo(FlatHashTable $this, ObjectOutputStream out$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this._loadFactor());
        out$1.writeInt($this.tableSize());
        $this.iterator().foreach(new FlatHashTable$.anonfun.serializeTo.1($this, out$1));
    }

    public static boolean containsEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (entry != null && !BoxesRunTime.equals(entry, elem)) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return entry != null;
    }

    public static boolean addEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (true) {
            if (entry == null) {
                $this.table()[h] = elem;
                $this.tableSize_$eq($this.tableSize() + 1);
                if ($this.tableSize() >= $this.threshold()) {
                    FlatHashTable$class.growTable($this);
                }
                return true;
            }
            if (BoxesRunTime.equals(entry, elem)) {
                return false;
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    public static Option removeEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (entry != null) {
            if (BoxesRunTime.equals(entry, elem)) {
                int h0 = h;
                int h1 = (h0 + 1) % $this.table().length;
                while (true) {
                    if ($this.table()[h1] == null) {
                        $this.table()[h0] = null;
                        $this.tableSize_$eq($this.tableSize() - 1);
                        return new Some<Object>(entry);
                    }
                    int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                    if (h2 != h1 && FlatHashTable$class.precedes$1($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return None$.MODULE$;
    }

    public static Iterator iterator(FlatHashTable $this) {
        return new FlatHashTable$.anon.1($this);
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            Serializable serializable = entry == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean($this.addEntry(entry));
        }
    }

    public static int elemHashCode(FlatHashTable $this, Object elem) {
        return elem == null ? 0 : elem.hashCode();
    }

    public static final int improve(FlatHashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static final int index(FlatHashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length - 1;
    }

    private static int newThreshold(FlatHashTable $this, int size2) {
        int lf = $this._loadFactor();
        Predef$.MODULE$.assert(lf < $this.loadFactorDenum() / 2, new FlatHashTable$.anonfun.newThreshold.1($this));
        return (int)((long)size2 * (long)lf / (long)$this.loadFactorDenum());
    }

    private static final boolean precedes$1(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq($this.loadFactor());
        $this.table_$eq(new Object[FlatHashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, FlatHashTable$class.initialCapacity($this)));
    }
}

