/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.type1.PFMFile;

public class Type1FontLoader
extends FontLoader {
    private String fontFileURI;
    private PFMFile pfm;
    private SingleByteFont singleFont;
    private CustomFont returnFont;
    private FontResolver resolver;

    public Type1FontLoader(String fontFileURI, InputStream in, FontResolver resolver) throws IOException {
        this.fontFileURI = fontFileURI;
        this.resolver = resolver;
        this.pfm = new PFMFile();
        this.pfm.load(in);
        this.singleFont = new SingleByteFont();
        this.singleFont.setFontType(FontType.TYPE1);
        this.singleFont.setResolver(this.resolver);
        this.returnFont = this.singleFont;
        this.read();
    }

    private void read() throws IOException {
        this.returnFont.setFontName(this.pfm.getPostscriptName());
        this.returnFont.setCapHeight(this.pfm.getCapHeight());
        this.returnFont.setXHeight(this.pfm.getXHeight());
        this.returnFont.setAscender(this.pfm.getLowerCaseAscent());
        this.returnFont.setDescender(this.pfm.getLowerCaseDescent());
        this.returnFont.setFontBBox(this.pfm.getFontBBox());
        this.returnFont.setFirstChar(this.pfm.getFirstChar());
        this.returnFont.setLastChar(this.pfm.getFirstChar());
        this.returnFont.setFlags(this.pfm.getFlags());
        this.returnFont.setStemV(this.pfm.getStemV());
        this.returnFont.setItalicAngle(this.pfm.getItalicAngle());
        this.returnFont.setMissingWidth(0);
        for (short i = this.pfm.getFirstChar(); i <= this.pfm.getLastChar(); i = (short)(i + 1)) {
            this.singleFont.setWidth(i, this.pfm.getCharWidth(i));
        }
        this.singleFont.setEmbedFileName(this.fontFileURI);
    }

    public CustomFont getFont() {
        return this.returnFont;
    }
}

