/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;

public class ChartUtil {
    public static List getImageAreaHyperlinks(JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Graphics2D grx, Rectangle2D renderingArea) {
        ArrayList<JRPrintImageAreaHyperlink> areaHyperlinks = null;
        if (chartHyperlinkProvider != null && chartHyperlinkProvider.hasHyperlinks()) {
            ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
            if (grx == null) {
                chart.createBufferedImage((int)renderingArea.getWidth(), (int)renderingArea.getHeight(), renderingInfo);
            } else {
                chart.draw(grx, renderingArea, renderingInfo);
            }
            EntityCollection entityCollection = renderingInfo.getEntityCollection();
            if (entityCollection != null && entityCollection.getEntityCount() > 0) {
                areaHyperlinks = new ArrayList<JRPrintImageAreaHyperlink>(entityCollection.getEntityCount());
                Iterator it = entityCollection.iterator();
                while (it.hasNext()) {
                    ChartEntity entity = (ChartEntity)it.next();
                    JRPrintHyperlink printHyperlink = chartHyperlinkProvider.getEntityHyperlink(entity);
                    if (printHyperlink == null) continue;
                    JRPrintImageArea area = ChartUtil.getImageArea(entity);
                    JRPrintImageAreaHyperlink areaHyperlink = new JRPrintImageAreaHyperlink();
                    areaHyperlink.setArea(area);
                    areaHyperlink.setHyperlink(printHyperlink);
                    areaHyperlinks.add(areaHyperlink);
                }
            }
        }
        return areaHyperlinks;
    }

    private static JRPrintImageArea getImageArea(ChartEntity entity) {
        JRPrintImageArea area = new JRPrintImageArea();
        area.setShape(JRPrintImageArea.getShape(entity.getShapeType()));
        int[] coordinates = ChartUtil.getCoordinates(entity);
        if (coordinates != null) {
            area.setCoordinates(coordinates);
        }
        return area;
    }

    private static int[] getCoordinates(ChartEntity entity) {
        int[] coordinates = null;
        String shapeCoords = entity.getShapeCoords();
        if (shapeCoords != null && shapeCoords.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(shapeCoords, ",");
            coordinates = new int[tokens.countTokens()];
            int idx = 0;
            while (tokens.hasMoreTokens()) {
                String coord = tokens.nextToken();
                coordinates[idx] = Integer.parseInt(coord);
                ++idx;
            }
        }
        return coordinates;
    }
}

