<?php
/**
 * This defines autoloading handler for whole MediaWiki framework
 *
 * @file
 */

/**
 * Locations of core classes
 * Extension classes are specified with $wgAutoloadClasses
 * This array is a global instead of a static member of AutoLoader to work around a bug in APC
 */
global $wgAutoloadLocalClasses;

$wgAutoloadLocalClasses = array(
	# Includes
	'Action' => 'includes/Action.php',
	'AjaxDispatcher' => 'includes/AjaxDispatcher.php',
	'AjaxResponse' => 'includes/AjaxResponse.php',
	'AlphabeticPager' => 'includes/Pager.php',
	'Article' => 'includes/Article.php',
	'AtomFeed' => 'includes/Feed.php',
	'AuthPlugin' => 'includes/AuthPlugin.php',
	'AuthPluginUser' => 'includes/AuthPlugin.php',
	'Autopromote' => 'includes/Autopromote.php',
	'BacklinkCache' => 'includes/BacklinkCache.php',
	'BadTitleError' => 'includes/Exception.php',
	'BaseTemplate' => 'includes/SkinTemplate.php',
	'Block' => 'includes/Block.php',
	'Category' => 'includes/Category.php',
	'Categoryfinder' => 'includes/Categoryfinder.php',
	'CategoryPage' => 'includes/CategoryPage.php',
	'CategoryViewer' => 'includes/CategoryViewer.php',
	'CdbFunctions' => 'includes/Cdb_PHP.php',
	'CdbReader' => 'includes/Cdb.php',
	'CdbReader_DBA' => 'includes/Cdb.php',
	'CdbReader_PHP' => 'includes/Cdb_PHP.php',
	'CdbWriter' => 'includes/Cdb.php',
	'CdbWriter_DBA' => 'includes/Cdb.php',
	'CdbWriter_PHP' => 'includes/Cdb_PHP.php',
	'ChangesFeed' => 'includes/ChangesFeed.php',
	'ChangesList' => 'includes/ChangesList.php',
	'ChangeTags' => 'includes/ChangeTags.php',
	'ChannelFeed' => 'includes/Feed.php',
	'Collation' => 'includes/Collation.php',
	'ConcatenatedGzipHistoryBlob' => 'includes/HistoryBlob.php',
	'ConfEditor' => 'includes/ConfEditor.php',
	'ConfEditorParseError' => 'includes/ConfEditor.php',
	'ConfEditorToken' => 'includes/ConfEditor.php',
	'Cookie' => 'includes/Cookie.php',
	'CookieJar' => 'includes/Cookie.php',
	'MWCryptRand' => 'includes/CryptRand.php',
	'CurlHttpRequest' => 'includes/HttpFunctions.php',
	'DeferrableUpdate' => 'includes/DeferredUpdates.php',
	'DeferredUpdates' => 'includes/DeferredUpdates.php',
	'DerivativeRequest' => 'includes/WebRequest.php',
	'DiffHistoryBlob' => 'includes/HistoryBlob.php',

	'DoubleReplacer' => 'includes/StringUtils.php',
	'DummyLinker' => 'includes/Linker.php',
	'Dump7ZipOutput' => 'includes/Export.php',
	'DumpBZip2Output' => 'includes/Export.php',
	'DumpFileOutput' => 'includes/Export.php',
	'DumpFilter' => 'includes/Export.php',
	'DumpGZipOutput' => 'includes/Export.php',
	'DumpLatestFilter' => 'includes/Export.php',
	'DumpMultiWriter' => 'includes/Export.php',
	'DumpNamespaceFilter' => 'includes/Export.php',
	'DumpNotalkFilter' => 'includes/Export.php',
	'DumpOutput' => 'includes/Export.php',
	'DumpPipeOutput' => 'includes/Export.php',
	'EditPage' => 'includes/EditPage.php',
	'EmailNotification' => 'includes/UserMailer.php',
	'EnhancedChangesList' => 'includes/ChangesList.php',
	'ErrorPageError' => 'includes/Exception.php',
	'ExplodeIterator' => 'includes/StringUtils.php',
	'ExternalEdit' => 'includes/ExternalEdit.php',
	'ExternalStore' => 'includes/ExternalStore.php',
	'ExternalStoreDB' => 'includes/ExternalStoreDB.php',
	'ExternalStoreHttp' => 'includes/ExternalStoreHttp.php',
	'ExternalUser' => 'includes/ExternalUser.php',
	'FakeTitle' => 'includes/FakeTitle.php',
	'Fallback' => 'includes/Fallback.php',
	'FatalError' => 'includes/Exception.php',
	'FauxRequest' => 'includes/WebRequest.php',
	'FauxResponse' => 'includes/WebResponse.php',
	'FeedItem' => 'includes/Feed.php',
	'FeedUtils' => 'includes/FeedUtils.php',
	'FileDeleteForm' => 'includes/FileDeleteForm.php',
	'ForkController' => 'includes/ForkController.php',
	'FormlessAction' => 'includes/Action.php',
	'FormAction' => 'includes/Action.php',
	'FormOptions' => 'includes/FormOptions.php',
	'FormSpecialPage' => 'includes/SpecialPage.php',
	'HashtableReplacer' => 'includes/StringUtils.php',
	'HistoryBlob' => 'includes/HistoryBlob.php',
	'HistoryBlobCurStub' => 'includes/HistoryBlob.php',
	'HistoryBlobStub' => 'includes/HistoryBlob.php',
	'Hooks' => 'includes/Hooks.php',
	'Html' => 'includes/Html.php',
	'HTMLCheckField' => 'includes/HTMLForm.php',
	'HTMLEditTools' => 'includes/HTMLForm.php',
	'HTMLFloatField' => 'includes/HTMLForm.php',
	'HTMLForm' => 'includes/HTMLForm.php',
	'HTMLFormField' => 'includes/HTMLForm.php',
	'HTMLHiddenField' => 'includes/HTMLForm.php',
	'HTMLInfoField' => 'includes/HTMLForm.php',
	'HTMLIntField' => 'includes/HTMLForm.php',
	'HTMLMultiSelectField' => 'includes/HTMLForm.php',
	'HTMLRadioField' => 'includes/HTMLForm.php',
	'HTMLSelectAndOtherField' => 'includes/HTMLForm.php',
	'HTMLSelectField' => 'includes/HTMLForm.php',
	'HTMLSelectOrOtherField' => 'includes/HTMLForm.php',
	'HTMLSubmitField' => 'includes/HTMLForm.php',
	'HTMLTextAreaField' => 'includes/HTMLForm.php',
	'HTMLTextField' => 'includes/HTMLForm.php',
	'Http' => 'includes/HttpFunctions.php',
	'HttpError' => 'includes/Exception.php',
	'HttpRequest' => 'includes/HttpFunctions.old.php',
	'IcuCollation' => 'includes/Collation.php',
	'IdentityCollation' => 'includes/Collation.php',
	'ImageGallery' => 'includes/ImageGallery.php',
	'ImageHistoryList' => 'includes/ImagePage.php',
	'ImageHistoryPseudoPager' => 'includes/ImagePage.php',
	'ImagePage' => 'includes/ImagePage.php',
	'ImageQueryPage' => 'includes/ImageQueryPage.php',
	'ImportStreamSource' => 'includes/Import.php',
	'ImportStringSource' => 'includes/Import.php',
	'IncludableSpecialPage' => 'includes/SpecialPage.php',
	'IndexPager' => 'includes/Pager.php',
	'Interwiki' => 'includes/interwiki/Interwiki.php',
	'IP' => 'includes/IP.php',
	'LCStore_Accel' => 'includes/LocalisationCache.php',
	'LCStore_CDB' => 'includes/LocalisationCache.php',
	'LCStore_DB' => 'includes/LocalisationCache.php',
	'LCStore_Null' => 'includes/LocalisationCache.php',
	'LegacyTemplate' => 'includes/SkinLegacy.php',
	'License' => 'includes/Licenses.php',
	'Licenses' => 'includes/Licenses.php',
	'Linker' => 'includes/Linker.php',
	'LinkFilter' => 'includes/LinkFilter.php',
	'LinksUpdate' => 'includes/LinksUpdate.php',
	'LocalisationCache' => 'includes/LocalisationCache.php',
	'LocalisationCache_BulkLoad' => 'includes/LocalisationCache.php',
	'MagicWord' => 'includes/MagicWord.php',
	'MagicWordArray' => 'includes/MagicWord.php',
	'MailAddress' => 'includes/UserMailer.php',
	'MediaWiki' => 'includes/Wiki.php',
	'MediaWiki_I18N' => 'includes/SkinTemplate.php',
	'Message' => 'includes/Message.php',
	'MessageBlobStore' => 'includes/MessageBlobStore.php',
	'MimeMagic' => 'includes/MimeMagic.php',
	'MWException' => 'includes/Exception.php',
	'MWExceptionHandler' => 'includes/Exception.php',
	'MWFunction' => 'includes/MWFunction.php',
	'MWHttpRequest' => 'includes/HttpFunctions.php',
	'MWInit' => 'includes/Init.php',
	'MWNamespace' => 'includes/Namespace.php',
	'OldChangesList' => 'includes/ChangesList.php',
	'OutputPage' => 'includes/OutputPage.php',
	'Page' =>  'includes/WikiPage.php',
	'PageQueryPage' => 'includes/PageQueryPage.php',
	'Pager' => 'includes/Pager.php',
	'PasswordError' => 'includes/User.php',
	'PathRouter' => 'includes/PathRouter.php',
	'PathRouterPatternReplacer' => 'includes/PathRouter.php',
	'PermissionsError' => 'includes/Exception.php',
	'PhpHttpRequest' => 'includes/HttpFunctions.php',
	'PoolCounter' => 'includes/PoolCounter.php',
	'PoolCounter_Stub' => 'includes/PoolCounter.php',
	'PoolCounterWork' => 'includes/PoolCounter.php',
	'PoolWorkArticleView' => 'includes/WikiPage.php',
	'Preferences' => 'includes/Preferences.php',
	'PreferencesForm' => 'includes/Preferences.php',
	'PrefixSearch' => 'includes/PrefixSearch.php',
	'ProtectionForm' => 'includes/ProtectionForm.php',
	'QueryPage' => 'includes/QueryPage.php',
	'QuickTemplate' => 'includes/SkinTemplate.php',
	'RCCacheEntry' => 'includes/ChangesList.php',
	'RdfMetaData' => 'includes/Metadata.php',
	'ReadOnlyError' => 'includes/Exception.php',
	'RecentChange' => 'includes/RecentChange.php',
	'RedirectSpecialPage' => 'includes/SpecialPage.php',
	'RegexlikeReplacer' => 'includes/StringUtils.php',
	'ReplacementArray' => 'includes/StringUtils.php',
	'Replacer' => 'includes/StringUtils.php',
	'ReverseChronologicalPager' => 'includes/Pager.php',
	'RevisionItemBase' => 'includes/RevisionList.php',
	'RevisionListBase' => 'includes/RevisionList.php',
	'Revision' => 'includes/Revision.php',
	'RevisionList' => 'includes/RevisionList.php',
	'RSSFeed' => 'includes/Feed.php',
	'Sanitizer' => 'includes/Sanitizer.php',
	'SiteConfiguration' => 'includes/SiteConfiguration.php',
	'SiteStats' => 'includes/SiteStats.php',
	'SiteStatsInit' => 'includes/SiteStats.php',
	'SiteStatsUpdate' => 'includes/SiteStats.php',
	'Skin' => 'includes/Skin.php',
	'SkinLegacy' => 'includes/SkinLegacy.php',
	'SkinTemplate' => 'includes/SkinTemplate.php',
	'SpecialCreateAccount' => 'includes/SpecialPage.php',
	'SpecialListAdmins' => 'includes/SpecialPage.php',
	'SpecialListBots' => 'includes/SpecialPage.php',
	'SpecialMycontributions' => 'includes/SpecialPage.php',
	'SpecialMypage' => 'includes/SpecialPage.php',
	'SpecialMytalk' => 'includes/SpecialPage.php',
	'SpecialMyuploads' => 'includes/SpecialPage.php',
	'SpecialPage' => 'includes/SpecialPage.php',
	'SpecialPageFactory' => 'includes/SpecialPageFactory.php',
	'SpecialRedirectToSpecial' => 'includes/SpecialPage.php',
	'SquidPurgeClient' => 'includes/SquidPurgeClient.php',
	'SquidPurgeClientPool' => 'includes/SquidPurgeClient.php',
	'Status' => 'includes/Status.php',
	'StreamFile' => 'includes/StreamFile.php',
	'StringUtils' => 'includes/StringUtils.php',
	'StubContLang' => 'includes/StubObject.php',
	'StubObject' => 'includes/StubObject.php',
	'StubUserLang' => 'includes/StubObject.php',
	'TablePager' => 'includes/Pager.php',
	'Title' => 'includes/Title.php',
	'TitleArray' => 'includes/TitleArray.php',
	'TitleArrayFromResult' => 'includes/TitleArray.php',
	'ThrottledError' => 'includes/Exception.php',
	'UnlistedSpecialPage' => 'includes/SpecialPage.php',
	'UppercaseCollation' => 'includes/Collation.php',
	'User' => 'includes/User.php',
	'UserArray' => 'includes/UserArray.php',
	'UserArrayFromResult' => 'includes/UserArray.php',
	'UserBlockedError' => 'includes/Exception.php',
	'UserMailer' => 'includes/UserMailer.php',
	'UserRightsProxy' => 'includes/UserRightsProxy.php',
	'ViewCountUpdate' => 'includes/ViewCountUpdate.php',
	'WantedQueryPage' => 'includes/QueryPage.php',
	'WatchedItem' => 'includes/WatchedItem.php',
	'WebRequest' => 'includes/WebRequest.php',
	'WebRequestUpload' => 'includes/WebRequest.php',
	'WebResponse' => 'includes/WebResponse.php',
	'WikiCategoryPage' => 'includes/WikiCategoryPage.php',
	'WikiError' => 'includes/WikiError.php',
	'WikiErrorMsg' => 'includes/WikiError.php',
	'WikiExporter' => 'includes/Export.php',
	'WikiFilePage' =>  'includes/WikiFilePage.php',
	'WikiImporter' => 'includes/Import.php',
	'WikiPage' =>  'includes/WikiPage.php',
	'WikiRevision' => 'includes/Import.php',
	'WikiMap' => 'includes/WikiMap.php',
	'WikiReference' => 'includes/WikiMap.php',
	'WikiXmlError' => 'includes/WikiError.php',
	'Xml' => 'includes/Xml.php',
	'XmlDumpWriter' => 'includes/Export.php',
	'XmlJsCode' => 'includes/Xml.php',
	'XmlSelect' => 'includes/Xml.php',
	'XmlTypeCheck' => 'includes/XmlTypeCheck.php',
	'ZhClient' => 'includes/ZhClient.php',
	'ZipDirectoryReader' => 'includes/ZipDirectoryReader.php',

	# includes/actions
	'CreditsAction' => 'includes/actions/CreditsAction.php',
	'DeleteAction' => 'includes/actions/DeleteAction.php',
	'EditAction' => 'includes/actions/EditAction.php',
	'HistoryAction' => 'includes/actions/HistoryAction.php',
	'HistoryPage' => 'includes/actions/HistoryAction.php',
	'HistoryPager' => 'includes/actions/HistoryAction.php',
	'InfoAction' => 'includes/actions/InfoAction.php',
	'MarkpatrolledAction' => 'includes/actions/MarkpatrolledAction.php',
	'ProtectAction' => 'includes/actions/ProtectAction.php',
	'PurgeAction' => 'includes/actions/PurgeAction.php',
	'RawAction' => 'includes/actions/RawAction.php',
	'RawPage' => 'includes/actions/RawAction.php',
	'RenderAction' => 'includes/actions/RenderAction.php',
	'RevertAction' => 'includes/actions/RevertAction.php',
	'RevertFileAction' => 'includes/actions/RevertAction.php',
	'RevisiondeleteAction' => 'includes/actions/RevisiondeleteAction.php',
	'RollbackAction' => 'includes/actions/RollbackAction.php',
	'SubmitAction' => 'includes/actions/EditAction.php',
	'UnprotectAction' => 'includes/actions/ProtectAction.php',
	'UnwatchAction' => 'includes/actions/WatchAction.php',
	'ViewAction' => 'includes/actions/ViewAction.php',
	'WatchAction' => 'includes/actions/WatchAction.php',

	# includes/api
	'ApiBase' => 'includes/api/ApiBase.php',
	'ApiBlock' => 'includes/api/ApiBlock.php',
	'ApiComparePages' => 'includes/api/ApiComparePages.php',
	'ApiDelete' => 'includes/api/ApiDelete.php',
	'ApiDisabled' => 'includes/api/ApiDisabled.php',
	'ApiEditPage' => 'includes/api/ApiEditPage.php',
	'ApiEmailUser' => 'includes/api/ApiEmailUser.php',
	'ApiExpandTemplates' => 'includes/api/ApiExpandTemplates.php',
	'ApiFeedContributions' => 'includes/api/ApiFeedContributions.php',
	'ApiFeedWatchlist' => 'includes/api/ApiFeedWatchlist.php',
	'ApiFileRevert' => 'includes/api/ApiFileRevert.php',
	'ApiFormatBase' => 'includes/api/ApiFormatBase.php',
	'ApiFormatDbg' => 'includes/api/ApiFormatDbg.php',
	'ApiFormatDump' => 'includes/api/ApiFormatDump.php',
	'ApiFormatFeedWrapper' => 'includes/api/ApiFormatBase.php',
	'ApiFormatJson' => 'includes/api/ApiFormatJson.php',
	'ApiFormatPhp' => 'includes/api/ApiFormatPhp.php',
	'ApiFormatRaw' => 'includes/api/ApiFormatRaw.php',
	'ApiFormatTxt' => 'includes/api/ApiFormatTxt.php',
	'ApiFormatWddx' => 'includes/api/ApiFormatWddx.php',
	'ApiFormatXml' => 'includes/api/ApiFormatXml.php',
	'ApiFormatXmlRsd' => 'includes/api/ApiRsd.php',
	'ApiFormatYaml' => 'includes/api/ApiFormatYaml.php',
	'ApiHelp' => 'includes/api/ApiHelp.php',
	'ApiImport' => 'includes/api/ApiImport.php',
	'ApiImportReporter' => 'includes/api/ApiImport.php',
	'ApiLogin' => 'includes/api/ApiLogin.php',
	'ApiLogout' => 'includes/api/ApiLogout.php',
	'ApiMain' => 'includes/api/ApiMain.php',
	'ApiMove' => 'includes/api/ApiMove.php',
	'ApiOpenSearch' => 'includes/api/ApiOpenSearch.php',
	'ApiPageSet' => 'includes/api/ApiPageSet.php',
	'ApiParamInfo' => 'includes/api/ApiParamInfo.php',
	'ApiParse' => 'includes/api/ApiParse.php',
	'ApiPatrol' => 'includes/api/ApiPatrol.php',
	'ApiProtect' => 'includes/api/ApiProtect.php',
	'ApiPurge' => 'includes/api/ApiPurge.php',
	'ApiQuery' => 'includes/api/ApiQuery.php',
	'ApiQueryAllCategories' => 'includes/api/ApiQueryAllCategories.php',
	'ApiQueryAllimages' => 'includes/api/ApiQueryAllimages.php',
	'ApiQueryAllLinks' => 'includes/api/ApiQueryAllLinks.php',
	'ApiQueryAllmessages' => 'includes/api/ApiQueryAllmessages.php',
	'ApiQueryAllpages' => 'includes/api/ApiQueryAllpages.php',
	'ApiQueryAllUsers' => 'includes/api/ApiQueryAllUsers.php',
	'ApiQueryBacklinks' => 'includes/api/ApiQueryBacklinks.php',
	'ApiQueryBase' => 'includes/api/ApiQueryBase.php',
	'ApiQueryBlocks' => 'includes/api/ApiQueryBlocks.php',
	'ApiQueryCategories' => 'includes/api/ApiQueryCategories.php',
	'ApiQueryCategoryInfo' => 'includes/api/ApiQueryCategoryInfo.php',
	'ApiQueryCategoryMembers' => 'includes/api/ApiQueryCategoryMembers.php',
	'ApiQueryContributions' => 'includes/api/ApiQueryUserContributions.php',
	'ApiQueryDeletedrevs' => 'includes/api/ApiQueryDeletedrevs.php',
	'ApiQueryDisabled' => 'includes/api/ApiQueryDisabled.php',
	'ApiQueryDuplicateFiles' => 'includes/api/ApiQueryDuplicateFiles.php',
	'ApiQueryExternalLinks' => 'includes/api/ApiQueryExternalLinks.php',
	'ApiQueryExtLinksUsage' => 'includes/api/ApiQueryExtLinksUsage.php',
	'ApiQueryFilearchive' => 'includes/api/ApiQueryFilearchive.php',
	'ApiQueryGeneratorBase' => 'includes/api/ApiQueryBase.php',
	'ApiQueryImageInfo' => 'includes/api/ApiQueryImageInfo.php',
	'ApiQueryImages' => 'includes/api/ApiQueryImages.php',
	'ApiQueryInfo' => 'includes/api/ApiQueryInfo.php',
	'ApiQueryIWBacklinks' => 'includes/api/ApiQueryIWBacklinks.php',
	'ApiQueryIWLinks' => 'includes/api/ApiQueryIWLinks.php',
	'ApiQueryLangBacklinks' => 'includes/api/ApiQueryLangBacklinks.php',
	'ApiQueryLangLinks' => 'includes/api/ApiQueryLangLinks.php',
	'ApiQueryLinks' => 'includes/api/ApiQueryLinks.php',
	'ApiQueryLogEvents' => 'includes/api/ApiQueryLogEvents.php',
	'ApiQueryPageProps' => 'includes/api/ApiQueryPageProps.php',
	'ApiQueryProtectedTitles' => 'includes/api/ApiQueryProtectedTitles.php',
	'ApiQueryQueryPage' => 'includes/api/ApiQueryQueryPage.php',
	'ApiQueryRandom' => 'includes/api/ApiQueryRandom.php',
	'ApiQueryRecentChanges' => 'includes/api/ApiQueryRecentChanges.php',
	'ApiQueryRevisions' => 'includes/api/ApiQueryRevisions.php',
	'ApiQuerySearch' => 'includes/api/ApiQuerySearch.php',
	'ApiQuerySiteinfo' => 'includes/api/ApiQuerySiteinfo.php',
	'ApiQueryStashImageInfo' => 'includes/api/ApiQueryStashImageInfo.php',
	'ApiQueryTags' => 'includes/api/ApiQueryTags.php',
	'ApiQueryUserInfo' => 'includes/api/ApiQueryUserInfo.php',
	'ApiQueryUsers' => 'includes/api/ApiQueryUsers.php',
	'ApiQueryWatchlist' => 'includes/api/ApiQueryWatchlist.php',
	'ApiQueryWatchlistRaw' => 'includes/api/ApiQueryWatchlistRaw.php',
	'ApiResult' => 'includes/api/ApiResult.php',
	'ApiRollback' => 'includes/api/ApiRollback.php',
	'ApiRsd' => 'includes/api/ApiRsd.php',
	'ApiUnblock' => 'includes/api/ApiUnblock.php',
	'ApiUndelete' => 'includes/api/ApiUndelete.php',
	'ApiUpload' => 'includes/api/ApiUpload.php',
	'ApiUserrights' => 'includes/api/ApiUserrights.php',
	'ApiWatch' => 'includes/api/ApiWatch.php',

	# includes/cache
	'CacheDependency' => 'includes/cache/CacheDependency.php',
	'ConstantDependency' => 'includes/cache/CacheDependency.php',
	'DependencyWrapper' => 'includes/cache/CacheDependency.php',
	'FileCacheBase' => 'includes/cache/FileCacheBase.php',
	'FileDependency' => 'includes/cache/CacheDependency.php',
	'GenderCache' => 'includes/cache/GenderCache.php',
	'GlobalDependency' => 'includes/cache/CacheDependency.php',
	'HTMLCacheUpdate' => 'includes/cache/HTMLCacheUpdate.php',
	'HTMLCacheUpdateJob' => 'includes/cache/HTMLCacheUpdate.php',
	'HTMLFileCache' => 'includes/cache/HTMLFileCache.php',
	'LinkBatch' => 'includes/cache/LinkBatch.php',
	'LinkCache' => 'includes/cache/LinkCache.php',
	'MessageCache' => 'includes/cache/MessageCache.php',
	'ObjectFileCache' => 'includes/cache/ObjectFileCache.php',
	'ResourceFileCache' => 'includes/cache/ResourceFileCache.php',
	'SquidUpdate' => 'includes/cache/SquidUpdate.php',
	'TitleDependency' => 'includes/cache/CacheDependency.php',
	'TitleListDependency' => 'includes/cache/CacheDependency.php',

	'UsageException' => 'includes/api/ApiMain.php',

	# includes/context
	'ContextSource' => 'includes/context/ContextSource.php',
	'DerivativeContext' => 'includes/context/DerivativeContext.php',
	'IContextSource' => 'includes/context/IContextSource.php',
	'RequestContext' => 'includes/context/RequestContext.php',

	# includes/db
	'Blob' => 'includes/db/DatabaseUtility.php',
	'ChronologyProtector' => 'includes/db/LBFactory.php',
	'CloneDatabase' => 'includes/db/CloneDatabase.php',
	'Database' => 'includes/db/DatabaseMysql.php',
	'DatabaseBase' => 'includes/db/Database.php',
	'DatabaseIbm_db2' => 'includes/db/DatabaseIbm_db2.php',
	'DatabaseMssql' => 'includes/db/DatabaseMssql.php',
	'DatabaseMysql' => 'includes/db/DatabaseMysql.php',
	'DatabaseOracle' => 'includes/db/DatabaseOracle.php',
	'DatabasePostgres' => 'includes/db/DatabasePostgres.php',
	'DatabaseSqlite' => 'includes/db/DatabaseSqlite.php',
	'DatabaseSqliteStandalone' => 'includes/db/DatabaseSqlite.php',
	'DatabaseType' => 'includes/db/Database.php',
	'DBConnectionError' => 'includes/db/DatabaseError.php',
	'DBError' => 'includes/db/DatabaseError.php',
	'DBObject' => 'includes/db/DatabaseUtility.php',
	'DBMasterPos' => 'includes/db/DatabaseUtility.php',
	'DBQueryError' => 'includes/db/DatabaseError.php',
	'DBUnexpectedError' => 'includes/db/DatabaseError.php',
	'FakeResultWrapper' => 'includes/db/DatabaseUtility.php',
	'Field' => 'includes/db/DatabaseUtility.php',
	'IBM_DB2Blob' => 'includes/db/DatabaseIbm_db2.php',
	'IBM_DB2Field' => 'includes/db/DatabaseIbm_db2.php',
	'LBFactory' => 'includes/db/LBFactory.php',
	'LBFactory_Multi' => 'includes/db/LBFactory_Multi.php',
	'LBFactory_Simple' => 'includes/db/LBFactory.php',
	'LBFactory_Single' => 'includes/db/LBFactory_Single.php',
	'LikeMatch' => 'includes/db/DatabaseUtility.php',
	'LoadBalancer' => 'includes/db/LoadBalancer.php',
	'LoadBalancer_Single' => 'includes/db/LBFactory_Single.php',
	'LoadMonitor' => 'includes/db/LoadMonitor.php',
	'LoadMonitor_MySQL' => 'includes/db/LoadMonitor.php',
	'LoadMonitor_Null' => 'includes/db/LoadMonitor.php',
	'MySQLField' => 'includes/db/DatabaseMysql.php',
	'MySQLMasterPos' => 'includes/db/DatabaseMysql.php',
	'ORAField' => 'includes/db/DatabaseOracle.php',
	'ORAResult' => 'includes/db/DatabaseOracle.php',
	'PostgresField' => 'includes/db/DatabasePostgres.php',
	'ResultWrapper' => 'includes/db/DatabaseUtility.php',
	'SQLiteField' => 'includes/db/DatabaseSqlite.php',

	# includes/debug
	'MWDebug' => 'includes/debug/Debug.php',

	# includes/diff
	'_DiffEngine' => 'includes/diff/DairikiDiff.php',
	'_DiffOp' => 'includes/diff/DairikiDiff.php',
	'_DiffOp_Add' => 'includes/diff/DairikiDiff.php',
	'_DiffOp_Change' => 'includes/diff/DairikiDiff.php',
	'_DiffOp_Copy' => 'includes/diff/DairikiDiff.php',
	'_DiffOp_Delete' => 'includes/diff/DairikiDiff.php',
	'_HWLDF_WordAccumulator' => 'includes/diff/DairikiDiff.php',
	'ArrayDiffFormatter' => 'includes/diff/DairikiDiff.php',
	'Diff' => 'includes/diff/DairikiDiff.php',
	'DifferenceEngine' => 'includes/diff/DifferenceEngine.php',
	'DiffFormatter' => 'includes/diff/DairikiDiff.php',
	'MappedDiff' => 'includes/diff/DairikiDiff.php',
	'RangeDifference' => 'includes/diff/WikiDiff3.php',
	'TableDiffFormatter' => 'includes/diff/DairikiDiff.php',
	'UnifiedDiffFormatter' => 'includes/diff/DairikiDiff.php',
	'WikiDiff3' => 'includes/diff/WikiDiff3.php',
	'WordLevelDiff' => 'includes/diff/DairikiDiff.php',

	# includes/extauth
	'ExternalUser_Hardcoded' => 'includes/extauth/Hardcoded.php',
	'ExternalUser_MediaWiki' => 'includes/extauth/MediaWiki.php',
	'ExternalUser_vB' => 'includes/extauth/vB.php',

	# includes/filerepo
	'FileRepo' => 'includes/filerepo/FileRepo.php',
	'FileRepoStatus' => 'includes/filerepo/FileRepoStatus.php',
	'ForeignAPIRepo' => 'includes/filerepo/ForeignAPIRepo.php',
	'ForeignDBRepo' => 'includes/filerepo/ForeignDBRepo.php',
	'ForeignDBViaLBRepo' => 'includes/filerepo/ForeignDBViaLBRepo.php',
	'FSRepo' => 'includes/filerepo/FSRepo.php',
	'LocalRepo' => 'includes/filerepo/LocalRepo.php',
	'NullRepo' => 'includes/filerepo/NullRepo.php',
	'RepoGroup' => 'includes/filerepo/RepoGroup.php',

	# includes/filerepo/file
	'ArchivedFile' => 'includes/filerepo/file/ArchivedFile.php',
	'File' => 'includes/filerepo/file/File.php',
	'ForeignAPIFile' => 'includes/filerepo/file/ForeignAPIFile.php',
	'ForeignDBFile' => 'includes/filerepo/file/ForeignDBFile.php',
	'LocalFile' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileDeleteBatch' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileMoveBatch' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileRestoreBatch' => 'includes/filerepo/file/LocalFile.php',
	'OldLocalFile' => 'includes/filerepo/file/OldLocalFile.php',
	'UnregisteredLocalFile' => 'includes/filerepo/file/UnregisteredLocalFile.php',
	'FSFile' => 'includes/filerepo/backend/FSFile.php',
	'TempFSFile' => 'includes/filerepo/backend/TempFSFile.php',

	# includes/filerepo/backend
	'FileBackendGroup' => 'includes/filerepo/backend/FileBackendGroup.php',
	'FileBackend' => 'includes/filerepo/backend/FileBackend.php',
	'FileBackendStore' => 'includes/filerepo/backend/FileBackend.php',
	'FileBackendMultiWrite' => 'includes/filerepo/backend/FileBackendMultiWrite.php',
	'FileBackendStoreShardListIterator' => 'includes/filerepo/backend/FileBackend.php',
	'FSFileBackend' => 'includes/filerepo/backend/FSFileBackend.php',
	'FSFileBackendFileList' => 'includes/filerepo/backend/FSFileBackend.php',
	'SwiftFileBackend' => 'includes/filerepo/backend/SwiftFileBackend.php',
	'SwiftFileBackendFileList' => 'includes/filerepo/backend/SwiftFileBackend.php',
	'LockManagerGroup' => 'includes/filerepo/backend/lockmanager/LockManagerGroup.php',
	'LockManager' => 'includes/filerepo/backend/lockmanager/LockManager.php',
	'ScopedLock' => 'includes/filerepo/backend/lockmanager/LockManager.php',
	'FSLockManager' => 'includes/filerepo/backend/lockmanager/FSLockManager.php',
	'DBLockManager' => 'includes/filerepo/backend/lockmanager/DBLockManager.php',
	'LSLockManager' => 'includes/filerepo/backend/lockmanager/LSLockManager.php',
	'MySqlLockManager'=> 'includes/filerepo/backend/lockmanager/DBLockManager.php',
	'NullLockManager' => 'includes/filerepo/backend/lockmanager/LockManager.php',
	'FileOp' => 'includes/filerepo/backend/FileOp.php',
	'FileOpScopedPHPTimeout' => 'includes/filerepo/backend/FileOp.php',
	'StoreFileOp' => 'includes/filerepo/backend/FileOp.php',
	'CopyFileOp' => 'includes/filerepo/backend/FileOp.php',
	'MoveFileOp' => 'includes/filerepo/backend/FileOp.php',
	'DeleteFileOp' => 'includes/filerepo/backend/FileOp.php',
	'ConcatenateFileOp' => 'includes/filerepo/backend/FileOp.php',
	'CreateFileOp' => 'includes/filerepo/backend/FileOp.php',
	'NullFileOp' => 'includes/filerepo/backend/FileOp.php',

	# includes/installer
	'CliInstaller' => 'includes/installer/CliInstaller.php',
	'DatabaseInstaller' => 'includes/installer/DatabaseInstaller.php',
	'DatabaseUpdater' => 'includes/installer/DatabaseUpdater.php',
	'Ibm_db2Installer' => 'includes/installer/Ibm_db2Installer.php',
	'Ibm_db2Updater' => 'includes/installer/Ibm_db2Updater.php',
	'InstallDocFormatter' => 'includes/installer/InstallDocFormatter.php',
	'Installer' => 'includes/installer/Installer.php',
	'LBFactory_InstallerFake' => 'includes/installer/Installer.php',
	'LocalSettingsGenerator' => 'includes/installer/LocalSettingsGenerator.php',
	'MysqlInstaller' => 'includes/installer/MysqlInstaller.php',
	'MysqlUpdater' => 'includes/installer/MysqlUpdater.php',
	'OracleInstaller' => 'includes/installer/OracleInstaller.php',
	'OracleUpdater' => 'includes/installer/OracleUpdater.php',
	'PhpRefCallBugTester' => 'includes/installer/PhpBugTests.php',
	'PhpXmlBugTester' => 'includes/installer/PhpBugTests.php',
	'PostgresInstaller' => 'includes/installer/PostgresInstaller.php',
	'PostgresUpdater' => 'includes/installer/PostgresUpdater.php',
	'SqliteInstaller' => 'includes/installer/SqliteInstaller.php',
	'SqliteUpdater' => 'includes/installer/SqliteUpdater.php',
	'WebInstaller' => 'includes/installer/WebInstaller.php',
	'WebInstaller_Complete' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Copying' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_DBConnect' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_DBSettings' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Document' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_ExistingWiki' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Install' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Language' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Name' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Options' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Readme' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_ReleaseNotes' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Restart' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Upgrade' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_UpgradeDoc' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Welcome' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerOutput' => 'includes/installer/WebInstallerOutput.php',
	'WebInstallerPage' => 'includes/installer/WebInstallerPage.php',

	# includes/job
	'DoubleRedirectJob' => 'includes/job/DoubleRedirectJob.php',
	'EmaillingJob' => 'includes/job/EmaillingJob.php',
	'EnotifNotifyJob' => 'includes/job/EnotifNotifyJob.php',
	'Job' => 'includes/job/JobQueue.php',
	'RefreshLinksJob' => 'includes/job/RefreshLinksJob.php',
	'RefreshLinksJob2' => 'includes/job/RefreshLinksJob.php',
	'UploadFromUrlJob' => 'includes/job/UploadFromUrlJob.php',

	# includes/json
	'FormatJson' => 'includes/json/FormatJson.php',
	'Services_JSON' => 'includes/json/Services_JSON.php',
	'Services_JSON_Error' => 'includes/json/Services_JSON.php',

	# includes/libs
	'CSSJanus' => 'includes/libs/CSSJanus.php',
	'CSSMin' => 'includes/libs/CSSMin.php',
	'HttpStatus' => 'includes/libs/HttpStatus.php',
	'IEContentAnalyzer' => 'includes/libs/IEContentAnalyzer.php',
	'IEUrlExtension' => 'includes/libs/IEUrlExtension.php',
	'JavaScriptMinifier' => 'includes/libs/JavaScriptMinifier.php',
	'JSMinPlus' => 'includes/libs/jsminplus.php',
	'JSParser' => 'includes/libs/jsminplus.php',

	# includes/logging
	'DatabaseLogEntry' => 'includes/logging/LogEntry.php',
	'DeleteLogFormatter' => 'includes/logging/LogFormatter.php',
	'LegacyLogFormatter' => 'includes/logging/LogFormatter.php',
	'LogEntry' => 'includes/logging/LogEntry.php',
	'LogEventsList' => 'includes/logging/LogEventsList.php',
	'LogEntryBase' => 'includes/logging/LogEntry.php',
	'LogFormatter' => 'includes/logging/LogFormatter.php',
	'LogPage' => 'includes/logging/LogPage.php',
	'LogPager' => 'includes/logging/LogPager.php',
	'ManualLogEntry' => 'includes/logging/LogEntry.php',
	'MoveLogFormatter' => 'includes/logging/LogFormatter.php',
	'NewUsersLogFormatter' => 'includes/logging/LogFormatter.php',
	'PatrolLog' => 'includes/logging/PatrolLog.php',
	'PatrolLogFormatter' => 'includes/logging/LogFormatter.php',
	'RCDatabaseLogEntry' => 'includes/logging/LogEntry.php',

	# includes/media
	'BitmapHandler' => 'includes/media/Bitmap.php',
	'BitmapHandler_ClientOnly' => 'includes/media/Bitmap_ClientOnly.php',
	'BitmapMetadataHandler' => 'includes/media/BitmapMetadataHandler.php',
	'BmpHandler' => 'includes/media/BMP.php',
	'DjVuHandler' => 'includes/media/DjVu.php',
	'DjVuImage' => 'includes/media/DjVuImage.php',
	'Exif' => 'includes/media/Exif.php',
	'ExifBitmapHandler' => 'includes/media/ExifBitmap.php',
	'FormatExif' => 'includes/media/FormatMetadata.php',
	'FormatMetadata' => 'includes/media/FormatMetadata.php',
	'GIFHandler' => 'includes/media/GIF.php',
	'GIFMetadataExtractor' => 'includes/media/GIFMetadataExtractor.php',
	'ImageHandler' => 'includes/media/Generic.php',
	'IPTC' => 'includes/media/IPTC.php',
	'JpegHandler' => 'includes/media/Jpeg.php',
	'JpegMetadataExtractor' => 'includes/media/JpegMetadataExtractor.php',
	'MediaHandler' => 'includes/media/Generic.php',
	'MediaTransformError' => 'includes/media/MediaTransformOutput.php',
	'MediaTransformOutput' => 'includes/media/MediaTransformOutput.php',
	'PNGHandler' => 'includes/media/PNG.php',
	'PNGMetadataExtractor' => 'includes/media/PNGMetadataExtractor.php',
	'SvgHandler' => 'includes/media/SVG.php',
	'SVGMetadataExtractor' => 'includes/media/SVGMetadataExtractor.php',
	'ThumbnailImage' => 'includes/media/MediaTransformOutput.php',
	'TiffHandler' => 'includes/media/Tiff.php',
	'TransformParameterError' => 'includes/media/MediaTransformOutput.php',
	'XCFHandler' => 'includes/media/XCF.php',
	'XMPInfo' => 'includes/media/XMPInfo.php',
	'XMPReader' => 'includes/media/XMP.php',
	'XMPValidate' => 'includes/media/XMPValidate.php',

	# includes/normal
	'UtfNormal' => 'includes/normal/UtfNormal.php',

	# includes/objectcache
	'APCBagOStuff' => 'includes/objectcache/APCBagOStuff.php',
	'BagOStuff' => 'includes/objectcache/BagOStuff.php',
	'DBABagOStuff' => 'includes/objectcache/DBABagOStuff.php',
	'EhcacheBagOStuff' => 'includes/objectcache/EhcacheBagOStuff.php',
	'EmptyBagOStuff' => 'includes/objectcache/EmptyBagOStuff.php',
	'FakeMemCachedClient' => 'includes/objectcache/EmptyBagOStuff.php',
	'HashBagOStuff' => 'includes/objectcache/HashBagOStuff.php',
	'MediaWikiBagOStuff' => 'includes/objectcache/SqlBagOStuff.php',
	'MemCachedClientforWiki' => 'includes/objectcache/MemcachedClient.php',
	'MemcachedPhpBagOStuff' => 'includes/objectcache/MemcachedPhpBagOStuff.php',
	'MultiWriteBagOStuff' => 'includes/objectcache/MultiWriteBagOStuff.php',
	'MWMemcached' => 'includes/objectcache/MemcachedClient.php',
	'ObjectCache' => 'includes/objectcache/ObjectCache.php',
	'SqlBagOStuff' => 'includes/objectcache/SqlBagOStuff.php',
	'WinCacheBagOStuff' => 'includes/objectcache/WinCacheBagOStuff.php',
	'XCacheBagOStuff' => 'includes/objectcache/XCacheBagOStuff.php',

	# includes/parser
	'CacheTime' => 'includes/parser/ParserOutput.php',
	'CoreLinkFunctions' => 'includes/parser/CoreLinkFunctions.php',
	'CoreParserFunctions' => 'includes/parser/CoreParserFunctions.php',
	'CoreTagHooks' => 'includes/parser/CoreTagHooks.php',
	'DateFormatter' => 'includes/parser/DateFormatter.php',
	'LinkHolderArray' => 'includes/parser/LinkHolderArray.php',
	'LinkMarkerReplacer' => 'includes/parser/Parser_LinkHooks.php',
	'MWTidy' => 'includes/parser/Tidy.php',
	'PPCustomFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPCustomFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPCustomFrame_HipHop' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPDAccum_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDAccum_HipHop' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPDPart' => 'includes/parser/Preprocessor_DOM.php',
	'PPDPart_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDPart_HipHop' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPDStack' => 'includes/parser/Preprocessor_DOM.php',
	'PPDStackElement' => 'includes/parser/Preprocessor_DOM.php',
	'PPDStackElement_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDStackElement_HipHop' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPDStack_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDStack_HipHop' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPFrame' => 'includes/parser/Preprocessor.php',
	'PPFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPFrame_HipHop' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPNode' => 'includes/parser/Preprocessor.php',
	'PPNode_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPNode_Hash_Array' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Attr' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Text' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Tree' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_HipHop_Array' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPNode_HipHop_Attr' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPNode_HipHop_Text' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPNode_HipHop_Tree' => 'includes/parser/Preprocessor_HipHop.hphp',
	'PPTemplateFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPTemplateFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPTemplateFrame_HipHop' => 'includes/parser/Preprocessor_HipHop.hphp',
	'Parser' => 'includes/parser/Parser.php',
	'ParserCache' => 'includes/parser/ParserCache.php',
	'ParserOptions' => 'includes/parser/ParserOptions.php',
	'ParserOutput' => 'includes/parser/ParserOutput.php',
	'Parser_DiffTest' => 'includes/parser/Parser_DiffTest.php',
	'Parser_LinkHooks' => 'includes/parser/Parser_LinkHooks.php',
	'Preprocessor' => 'includes/parser/Preprocessor.php',
	'Preprocessor_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'Preprocessor_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'Preprocessor_HipHop' => 'includes/parser/Preprocessor_HipHop.hphp',
	'StripState' => 'includes/parser/StripState.php',

	# includes/profiler
	'Profiler' => 'includes/profiler/Profiler.php',
	'ProfilerSimple' => 'includes/profiler/ProfilerSimple.php',
	'ProfilerSimpleText' => 'includes/profiler/ProfilerSimpleText.php',
	'ProfilerSimpleTrace' => 'includes/profiler/ProfilerSimpleTrace.php',
	'ProfilerSimpleUDP' => 'includes/profiler/ProfilerSimpleUDP.php',
	'ProfilerStub' => 'includes/profiler/ProfilerStub.php',

	# includes/resourceloader
	'ResourceLoader' => 'includes/resourceloader/ResourceLoader.php',
	'ResourceLoaderContext' => 'includes/resourceloader/ResourceLoaderContext.php',
	'ResourceLoaderFileModule' => 'includes/resourceloader/ResourceLoaderFileModule.php',
	'ResourceLoaderFilePageModule' => 'includes/resourceloader/ResourceLoaderFilePageModule.php',
	'ResourceLoaderModule' => 'includes/resourceloader/ResourceLoaderModule.php',
	'ResourceLoaderNoscriptModule' => 'includes/resourceloader/ResourceLoaderNoscriptModule.php',
	'ResourceLoaderSiteModule' => 'includes/resourceloader/ResourceLoaderSiteModule.php',
	'ResourceLoaderStartUpModule' => 'includes/resourceloader/ResourceLoaderStartUpModule.php',
	'ResourceLoaderUserCSSPrefsModule' => 'includes/resourceloader/ResourceLoaderUserCSSPrefsModule.php',
	'ResourceLoaderUserGroupsModule' => 'includes/resourceloader/ResourceLoaderUserGroupsModule.php',
	'ResourceLoaderUserModule' => 'includes/resourceloader/ResourceLoaderUserModule.php',
	'ResourceLoaderUserOptionsModule' => 'includes/resourceloader/ResourceLoaderUserOptionsModule.php',
	'ResourceLoaderUserTokensModule' => 'includes/resourceloader/ResourceLoaderUserTokensModule.php',
	'ResourceLoaderWikiModule' => 'includes/resourceloader/ResourceLoaderWikiModule.php',

	# includes/revisiondelete
	'RevDel_ArchivedFileItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_ArchivedFileList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_ArchiveItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_ArchiveList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_FileItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_FileList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_Item' => 'includes/revisiondelete/RevisionDeleteAbstracts.php',
	'RevDel_List' => 'includes/revisiondelete/RevisionDeleteAbstracts.php',
	'RevDel_LogItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_LogList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_RevisionItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_RevisionList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevisionDelete' => 'includes/revisiondelete/RevisionDelete.php',
	'RevisionDeleter' => 'includes/revisiondelete/RevisionDeleter.php',
	'RevisionDeleteUser' => 'includes/revisiondelete/RevisionDeleteUser.php',

	# includes/search
	'MySQLSearchResultSet' => 'includes/search/SearchMySQL.php',
	'PostgresSearchResult' => 'includes/search/SearchPostgres.php',
	'PostgresSearchResultSet' => 'includes/search/SearchPostgres.php',
	'SearchEngine' => 'includes/search/SearchEngine.php',
	'SearchEngineDummy' => 'includes/search/SearchEngine.php',
	'SearchHighlighter' => 'includes/search/SearchEngine.php',
	'SearchIBM_DB2' => 'includes/search/SearchIBM_DB2.php',
	'SearchMssql' => 'includes/search/SearchMssql.php',
	'SearchMySQL' => 'includes/search/SearchMySQL.php',
	'SearchOracle' => 'includes/search/SearchOracle.php',
	'SearchPostgres' => 'includes/search/SearchPostgres.php',
	'SearchResult' => 'includes/search/SearchEngine.php',
	'SearchResultSet' => 'includes/search/SearchEngine.php',
	'SearchResultTooMany' => 'includes/search/SearchEngine.php',
	'SearchSqlite' => 'includes/search/SearchSqlite.php',
	'SearchUpdate' => 'includes/search/SearchUpdate.php',
	'SearchUpdateMyISAM' => 'includes/search/SearchUpdate.php',
	'SqliteSearchResultSet' => 'includes/search/SearchSqlite.php',
	'SqlSearchResultSet' => 'includes/search/SearchEngine.php',

	# includes/specials
	'ActiveUsersPager' => 'includes/specials/SpecialActiveusers.php',
	'AllmessagesTablePager' => 'includes/specials/SpecialAllmessages.php',
	'AncientPagesPage' => 'includes/specials/SpecialAncientpages.php',
	'BlockListPager' => 'includes/specials/SpecialBlockList.php',
	'BrokenRedirectsPage' => 'includes/specials/SpecialBrokenRedirects.php',
	'ContribsPager' => 'includes/specials/SpecialContributions.php',
	'DBLockForm' => 'includes/specials/SpecialLockdb.php',
	'DBUnlockForm' => 'includes/specials/SpecialUnlockdb.php',
	'DeadendPagesPage' => 'includes/specials/SpecialDeadendpages.php',
	'DeletedContribsPager' => 'includes/specials/SpecialDeletedContributions.php',
	'DeletedContributionsPage' => 'includes/specials/SpecialDeletedContributions.php',
	'DisambiguationsPage' => 'includes/specials/SpecialDisambiguations.php',
	'DoubleRedirectsPage' => 'includes/specials/SpecialDoubleRedirects.php',
	'EmailConfirmation' => 'includes/specials/SpecialConfirmemail.php',
	'EmailInvalidation' => 'includes/specials/SpecialConfirmemail.php',
	'FewestrevisionsPage' => 'includes/specials/SpecialFewestrevisions.php',
	'FileDuplicateSearchPage' => 'includes/specials/SpecialFileDuplicateSearch.php',
	'HTMLBlockedUsersItemSelect' => 'includes/specials/SpecialBlockList.php',
	'ImportReporter' => 'includes/specials/SpecialImport.php',
	'IPBlockForm' => 'includes/specials/SpecialBlock.php',
	'LinkSearchPage' => 'includes/specials/SpecialLinkSearch.php',
	'ListredirectsPage' => 'includes/specials/SpecialListredirects.php',
	'LoginForm' => 'includes/specials/SpecialUserlogin.php',
	'LonelyPagesPage' => 'includes/specials/SpecialLonelypages.php',
	'LongPagesPage' => 'includes/specials/SpecialLongpages.php',
	'MIMEsearchPage' => 'includes/specials/SpecialMIMEsearch.php',
	'MostcategoriesPage' => 'includes/specials/SpecialMostcategories.php',
	'MostimagesPage' => 'includes/specials/SpecialMostimages.php',
	'MostlinkedCategoriesPage' => 'includes/specials/SpecialMostlinkedcategories.php',
	'MostlinkedPage' => 'includes/specials/SpecialMostlinked.php',
	'MostlinkedTemplatesPage' => 'includes/specials/SpecialMostlinkedtemplates.php',
	'MostrevisionsPage' => 'includes/specials/SpecialMostrevisions.php',
	'MovePageForm' => 'includes/specials/SpecialMovepage.php',
	'NewPagesPager' => 'includes/specials/SpecialNewpages.php',
	'PageArchive' => 'includes/specials/SpecialUndelete.php',
	'PopularPagesPage' => 'includes/specials/SpecialPopularpages.php',
	'RandomPage' => 'includes/specials/SpecialRandompage.php',
	'ShortPagesPage' => 'includes/specials/SpecialShortpages.php',
	'SpecialActiveUsers' => 'includes/specials/SpecialActiveusers.php',
	'SpecialAllmessages' => 'includes/specials/SpecialAllmessages.php',
	'SpecialAllpages' => 'includes/specials/SpecialAllpages.php',
	'SpecialBlankpage' => 'includes/specials/SpecialBlankpage.php',
	'SpecialBlock' => 'includes/specials/SpecialBlock.php',
	'SpecialBlockList' => 'includes/specials/SpecialBlockList.php',
	'SpecialBlockme' => 'includes/specials/SpecialBlockme.php',
	'SpecialBookSources' => 'includes/specials/SpecialBooksources.php',
	'SpecialCategories' => 'includes/specials/SpecialCategories.php',
	'SpecialChangeEmail' => 'includes/specials/SpecialChangeEmail.php',
	'SpecialChangePassword' => 'includes/specials/SpecialChangePassword.php',
	'SpecialComparePages' => 'includes/specials/SpecialComparePages.php',
	'SpecialContributions' => 'includes/specials/SpecialContributions.php',
	'SpecialEditWatchlist' => 'includes/specials/SpecialEditWatchlist.php',
	'SpecialEmailUser' => 'includes/specials/SpecialEmailuser.php',
	'SpecialExport' => 'includes/specials/SpecialExport.php',
	'SpecialFilepath' => 'includes/specials/SpecialFilepath.php',
	'SpecialImport' => 'includes/specials/SpecialImport.php',
	'SpecialJavaScriptTest' => 'includes/specials/SpecialJavaScriptTest.php',
	'SpecialListFiles' => 'includes/specials/SpecialListfiles.php',
	'SpecialListGroupRights' => 'includes/specials/SpecialListgrouprights.php',
	'SpecialListUsers' => 'includes/specials/SpecialListusers.php',
	'SpecialLockdb' => 'includes/specials/SpecialLockdb.php',
	'SpecialLog' => 'includes/specials/SpecialLog.php',
	'SpecialMergeHistory' => 'includes/specials/SpecialMergeHistory.php',
	'SpecialMostlinkedtemplates' => 'includes/specials/SpecialMostlinkedtemplates.php',
	'SpecialNewFiles' => 'includes/specials/SpecialNewimages.php',
	'SpecialNewpages' => 'includes/specials/SpecialNewpages.php',
	'SpecialPasswordReset' => 'includes/specials/SpecialPasswordReset.php',
	'SpecialPermanentLink' => 'includes/SpecialPage.php',
	'SpecialPreferences' => 'includes/specials/SpecialPreferences.php',
	'SpecialPrefixindex' => 'includes/specials/SpecialPrefixindex.php',
	'SpecialProtectedpages' => 'includes/specials/SpecialProtectedpages.php',
	'SpecialProtectedtitles' => 'includes/specials/SpecialProtectedtitles.php',
	'SpecialRandomredirect' => 'includes/specials/SpecialRandomredirect.php',
	'SpecialRecentChanges' => 'includes/specials/SpecialRecentchanges.php',
	'SpecialRecentchangeslinked' => 'includes/specials/SpecialRecentchangeslinked.php',
	'SpecialRevisionDelete' => 'includes/specials/SpecialRevisiondelete.php',
	'SpecialSearch' => 'includes/specials/SpecialSearch.php',
	'SpecialSpecialpages' => 'includes/specials/SpecialSpecialpages.php',
	'SpecialStatistics' => 'includes/specials/SpecialStatistics.php',
	'SpecialTags' => 'includes/specials/SpecialTags.php',
	'SpecialUnblock' => 'includes/specials/SpecialUnblock.php',
	'SpecialUndelete' => 'includes/specials/SpecialUndelete.php',
	'SpecialUnlockdb' => 'includes/specials/SpecialUnlockdb.php',
	'SpecialUpload' => 'includes/specials/SpecialUpload.php',
	'SpecialUploadStash' => 'includes/specials/SpecialUploadStash.php',
	'SpecialUserlogout' => 'includes/specials/SpecialUserlogout.php',
	'SpecialVersion' => 'includes/specials/SpecialVersion.php',
	'SpecialWatchlist' => 'includes/specials/SpecialWatchlist.php',
	'SpecialWhatlinkshere' => 'includes/specials/SpecialWhatlinkshere.php',
	'UncategorizedCategoriesPage' => 'includes/specials/SpecialUncategorizedcategories.php',
	'UncategorizedImagesPage' => 'includes/specials/SpecialUncategorizedimages.php',
	'UncategorizedPagesPage' => 'includes/specials/SpecialUncategorizedpages.php',
	'UncategorizedTemplatesPage' => 'includes/specials/SpecialUncategorizedtemplates.php',
	'UnusedCategoriesPage' => 'includes/specials/SpecialUnusedcategories.php',
	'UnusedimagesPage' => 'includes/specials/SpecialUnusedimages.php',
	'UnusedtemplatesPage' => 'includes/specials/SpecialUnusedtemplates.php',
	'UnwatchedpagesPage' => 'includes/specials/SpecialUnwatchedpages.php',
	'UploadForm' => 'includes/specials/SpecialUpload.php',
	'UploadSourceField' => 'includes/specials/SpecialUpload.php',
	'UserrightsPage' => 'includes/specials/SpecialUserrights.php',
	'UsersPager' => 'includes/specials/SpecialListusers.php',
	'WantedCategoriesPage' => 'includes/specials/SpecialWantedcategories.php',
	'WantedFilesPage' => 'includes/specials/SpecialWantedfiles.php',
	'WantedPagesPage' => 'includes/specials/SpecialWantedpages.php',
	'WantedTemplatesPage' => 'includes/specials/SpecialWantedtemplates.php',
	'WatchlistEditor' => 'includes/specials/SpecialEditWatchlist.php',
	'WithoutInterwikiPage' => 'includes/specials/SpecialWithoutinterwiki.php',

	# includes/templates
	'UserloginTemplate' => 'includes/templates/Userlogin.php',
	'UsercreateTemplate' => 'includes/templates/Usercreate.php',

	# includes/upload
	'UploadBase' => 'includes/upload/UploadBase.php',
	'UploadFromFile' => 'includes/upload/UploadFromFile.php',
	'UploadFromChunks' => 'includes/upload/UploadFromChunks.php',
	'UploadFromStash' => 'includes/upload/UploadFromStash.php',
	'UploadFromUrl' => 'includes/upload/UploadFromUrl.php',
	'UploadStash' => 'includes/upload/UploadStash.php',
	'UploadStashBadPathException' => 'includes/upload/UploadStash.php',
	'UploadStashBadVersionException' => 'includes/upload/UploadStash.php',
	'UploadStashFile' => 'includes/upload/UploadStash.php',
	'UploadStashFileException' => 'includes/upload/UploadStash.php',
	'UploadStashFileNotFoundException' => 'includes/upload/UploadStash.php',
	'UploadStashNotAvailableException' => 'includes/upload/UploadStash.php',
	'UploadStashZeroLengthFileException' => 'includes/upload/UploadStash.php',
	'UploadStashNotLoggedInException' => 'includes/upload/UploadStash.php',
	'UploadStashWrongOwnerException' => 'includes/upload/UploadStash.php',
	'UploadStashNoSuchKeyException' => 'includes/upload/UploadStash.php',

	# languages
	'FakeConverter' => 'languages/Language.php',
	'Language' => 'languages/Language.php',
	'LanguageConverter' => 'languages/LanguageConverter.php',

	# maintenance
	'ConvertLinks' => 'maintenance/convertLinks.php',
	'DeleteArchivedFilesImplementation' => 'maintenance/deleteArchivedFiles.inc',
	'DeleteArchivedRevisionsImplementation' => 'maintenance/deleteArchivedRevisions.inc',
	'DeleteDefaultMessages' => 'maintenance/deleteDefaultMessages.php',
	'FakeMaintenance' => 'maintenance/Maintenance.php',
	'LoggedUpdateMaintenance' => 'maintenance/Maintenance.php',
	'Maintenance' => 'maintenance/Maintenance.php',
	'FixExtLinksProtocolRelative' => 'maintenance/fixExtLinksProtocolRelative.php',
	'PopulateCategory' => 'maintenance/populateCategory.php',
	'PopulateImageSha1' => 'maintenance/populateImageSha1.php',
	'PopulateLogSearch' => 'maintenance/populateLogSearch.php',
	'PopulateLogUsertext' => 'maintenance/populateLogUsertext.php',
	'PopulateParentId' => 'maintenance/populateParentId.php',
	'PopulateRevisionLength' => 'maintenance/populateRevisionLength.php',
	'PopulateRevisionSha1' => 'maintenance/populateRevisionSha1.php',
	'RefreshLinks' => 'maintenance/refreshLinks.php',
	'SevenZipStream' => 'maintenance/7zip.inc',
	'Sqlite' => 'maintenance/sqlite.inc',
	'UpdateCollation' => 'maintenance/updateCollation.php',
	'UpdateRestrictions' => 'maintenance/updateRestrictions.php',
	'UserDupes' => 'maintenance/userDupes.inc',

	# maintenance/language
	'csvStatsOutput' => 'maintenance/language/StatOutputs.php',
	'languages' => 'maintenance/language/languages.inc',
	'MessageWriter' => 'maintenance/language/writeMessagesArray.inc',
	'statsOutput' => 'maintenance/language/StatOutputs.php',
	'textStatsOutput' => 'maintenance/language/StatOutputs.php',
	'wikiStatsOutput' => 'maintenance/language/StatOutputs.php',

	# maintenance/term
	'AnsiTermColorer'  => 'maintenance/term/MWTerm.php',
	'DummyTermColorer' => 'maintenance/term/MWTerm.php',

	# tests
	'DbTestPreviewer' => 'tests/testHelpers.inc',
	'DbTestRecorder' => 'tests/testHelpers.inc',
	'TestFileIterator' => 'tests/testHelpers.inc',
	'TestRecorder' => 'tests/testHelpers.inc',

	# tests/parser
	'ParserTest' => 'tests/parser/parserTest.inc',
	'ParserTestParserHook' => 'tests/parser/parserTestsParserHook.php',
	'ParserTestStaticParserHook' => 'tests/parser/parserTestsStaticParserHook.php',

	# tests/selenium
	'Selenium' => 'tests/selenium/Selenium.php',
	'SeleniumLoader' => 'tests/selenium/SeleniumLoader.php',
	'SeleniumTestCase' => 'tests/selenium/SeleniumTestCase.php',
	'SeleniumTestConsoleLogger' => 'tests/selenium/SeleniumTestConsoleLogger.php',
	'SeleniumTestHTMLLogger' => 'tests/selenium/SeleniumTestHTMLLogger.php',
	'SeleniumTestListener' => 'tests/selenium/SeleniumTestListener.php',
	'SeleniumTestSuite' => 'tests/selenium/SeleniumTestSuite.php',
	'SeleniumConfig' => 'tests/selenium/SeleniumConfig.php',
);

class AutoLoader {
	/**
	 * autoload - take a class name and attempt to load it
	 *
	 * @param $className String: name of class we're looking for.
	 * @return bool Returning false is important on failure as
	 * it allows Zend to try and look in other registered autoloaders
	 * as well.
	 */
	static function autoload( $className ) {
		global $wgAutoloadClasses, $wgAutoloadLocalClasses;

		if ( isset( $wgAutoloadLocalClasses[$className] ) ) {
			$filename = $wgAutoloadLocalClasses[$className];
		} elseif ( isset( $wgAutoloadClasses[$className] ) ) {
			$filename = $wgAutoloadClasses[$className];
		} else {
			# Try a different capitalisation
			# The case can sometimes be wrong when unserializing PHP 4 objects
			$filename = false;
			$lowerClass = strtolower( $className );

			foreach ( $wgAutoloadLocalClasses as $class2 => $file2 ) {
				if ( strtolower( $class2 ) == $lowerClass ) {
					$filename = $file2;
				}
			}

			if ( !$filename ) {
				if ( function_exists( 'wfDebug' ) ) {
					wfDebug( "Class {$className} not found; skipped loading\n" );
				}

				# Give up
				return false;
			}
		}

		# Make an absolute path, this improves performance by avoiding some stat calls
		if ( substr( $filename, 0, 1 ) != '/' && substr( $filename, 1, 1 ) != ':' ) {
			global $IP;
			$filename = "$IP/$filename";
		}

		require( $filename );

		return true;
	}

	/**
	 * Force a class to be run through the autoloader, helpful for things like
	 * Sanitizer that have define()s outside of their class definition. Of course
	 * this wouldn't be necessary if everything in MediaWiki was class-based. Sigh.
	 *
	 * @return Boolean Return the results of class_exists() so we know if we were successful
	 */
	static function loadClass( $class ) {
		return class_exists( $class );
	}
}

if ( function_exists( 'spl_autoload_register' ) ) {
	spl_autoload_register( array( 'AutoLoader', 'autoload' ) );
} else {
	function __autoload( $class ) {
		AutoLoader::autoload( $class );
	}

	ini_set( 'unserialize_callback_func', '__autoload' );
}
