/*
 * Decompiled with CFR 0.152.
 */
package railo.loader.engine;

import com.intergral.fusiondebug.server.FDControllerFactory;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import railo.Version;
import railo.loader.TP;
import railo.loader.classloader.RailoClassLoader;
import railo.loader.engine.CFMLEngine;
import railo.loader.engine.CFMLEngineWrapper;
import railo.loader.engine.EngineChangeListener;
import railo.loader.util.ExtensionFilter;
import railo.loader.util.Util;

public class CFMLEngineFactory {
    private static CFMLEngineFactory factory;
    private static File railoServerRoot;
    private static CFMLEngineWrapper engineListener;
    private CFMLEngine engine;
    private ClassLoader mainClassLoader = new TP().getClass().getClassLoader();
    private int version;
    private ArrayList listeners = new ArrayList();
    private File resourceRoot;

    protected CFMLEngineFactory() {
    }

    public static CFMLEngine getInstance(ServletConfig config) throws ServletException {
        if (engineListener != null) {
            if (factory == null) {
                factory = engineListener.getCFMLEngineFactory();
            }
            return engineListener;
        }
        if (factory == null) {
            factory = new CFMLEngineFactory();
        }
        factory.setInitParam(config);
        CFMLEngine engine = factory.getEngine();
        engine.addServletConfig(config);
        engineListener = new CFMLEngineWrapper(engine);
        factory.addListener(engineListener);
        return engineListener;
    }

    public static CFMLEngine getInstance() throws RuntimeException {
        if (engineListener != null) {
            return engineListener;
        }
        throw new RuntimeException("engine is not initalized, you must first call getInstance(ServletConfig)");
    }

    public static void registerInstance(CFMLEngine engine) throws RuntimeException {
        if (factory == null) {
            factory = engine.getCFMLEngineFactory();
        }
        if (engineListener != null) {
            if (engineListener.equalTo(engine, true)) {
                return;
            }
            engineListener.onUpdate(engine);
            factory.removeListener(engineListener);
        }
        engineListener = engine instanceof CFMLEngineWrapper ? (CFMLEngineWrapper)engine : new CFMLEngineWrapper(engine);
        factory.addListener(engineListener);
    }

    public static CFMLEngine getInstance(ServletConfig config, EngineChangeListener listener) throws ServletException {
        CFMLEngineFactory.getInstance(config);
        factory.addListener(listener);
        factory.setInitParam(config);
        CFMLEngine e = factory.getEngine();
        e.addServletConfig(config);
        FDControllerFactory.makeVisible();
        return e;
    }

    void setInitParam(ServletConfig config) {
        if (railoServerRoot != null) {
            return;
        }
        String initParam = config.getInitParameter("railo-server-directory");
        if (Util.isEmpty(initParam)) {
            initParam = config.getInitParameter("railo-server-root");
        }
        if (Util.isEmpty(initParam)) {
            initParam = config.getInitParameter("railo-server-dir");
        }
        if (Util.isEmpty(initParam)) {
            initParam = config.getInitParameter("railo-server");
        }
        initParam = Util.parsePlaceHolder(initParam);
        try {
            if (!Util.isEmpty(initParam)) {
                File root = new File(initParam);
                if (!root.exists()) {
                    if (root.mkdirs()) {
                        railoServerRoot = root.getCanonicalFile();
                        return;
                    }
                } else if (root.canWrite()) {
                    railoServerRoot = root.getCanonicalFile();
                    return;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addListener(EngineChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void removeListener(EngineChangeListener listener) {
        this.listeners.remove(listener);
    }

    private CFMLEngine getEngine() throws ServletException {
        if (this.engine == null) {
            this.initEngine();
        }
        return this.engine;
    }

    private void initEngine() throws ServletException {
        int coreVersion = Version.getIntVersion();
        long coreCreated = Version.getCreateTime();
        File patcheDir = null;
        try {
            patcheDir = this.getPatchDirectory();
            System.out.println("railo-server-root:" + patcheDir.getParent());
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        File[] patches = patcheDir.listFiles(new ExtensionFilter(new String[]{"." + this.getCoreExtension()}));
        File railo = null;
        if (patches != null) {
            int i = 0;
            while (i < patches.length) {
                if (patches[i].getName().startsWith("tmp.rc")) {
                    patches[i].delete();
                } else if (patches[i].lastModified() < coreCreated) {
                    patches[i].delete();
                } else if (railo == null || this.isNewerThan(Util.toInVersion(patches[i].getName()), Util.toInVersion(railo.getName()))) {
                    railo = patches[i];
                }
                ++i;
            }
        }
        if (railo != null && this.isNewerThan(coreVersion, Util.toInVersion(railo.getName()))) {
            railo = null;
        }
        try {
            if (railo == null) {
                String coreExt = this.getCoreExtension();
                this.engine = this.getCore(coreExt);
                railo = new File(patcheDir, String.valueOf(this.engine.getVersion()) + "." + coreExt);
                InputStream bis = new TP().getClass().getResourceAsStream("/core/core." + coreExt);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(railo));
                Util.copy(bis, bos);
                Util.closeEL(bis, bos);
            } else {
                try {
                    this.engine = this.getEngine(new RailoClassLoader(railo, this.mainClassLoader));
                }
                catch (EOFException e) {
                    System.err.println("Railo patch file " + railo + " is invalid, please delete it");
                    this.engine = this.getCore(this.getCoreExtension());
                }
            }
            this.version = Util.toInVersion(this.engine.getVersion());
            this.tlog("Loaded Railo Version " + this.engine.getVersion());
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new ServletException(e.getTargetException());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        String updateType = this.engine.getUpdateType();
        if (updateType == null || updateType.length() == 0) {
            updateType = "manuell";
        }
        if (updateType.equalsIgnoreCase("auto")) {
            new UpdateChecker(this).start();
        }
    }

    private String getCoreExtension() throws ServletException {
        URL res = new TP().getClass().getResource("/core/core.rcs");
        if (res != null) {
            return "rcs";
        }
        res = new TP().getClass().getResource("/core/core.rc");
        if (res != null) {
            return "rc";
        }
        throw new ServletException("missing core file");
    }

    private CFMLEngine getCore(String ext) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        CFMLEngine cFMLEngine;
        InputStream is = null;
        try {
            is = new TP().getClass().getResourceAsStream("/core/core." + ext);
            RailoClassLoader classLoader = new RailoClassLoader(is, this.mainClassLoader, ext.equalsIgnoreCase("rcs"));
            cFMLEngine = this.getEngine(classLoader);
        }
        catch (Throwable throwable) {
            Util.closeEL(is);
            throw throwable;
        }
        Util.closeEL(is);
        return cFMLEngine;
    }

    public boolean update(String password) throws IOException, ServletException {
        if (!this.engine.can(0, password)) {
            throw new IOException("access denied to update CFMLEngine");
        }
        return this.update();
    }

    public boolean restart(String password) throws IOException, ServletException {
        if (!this.engine.can(1, password)) {
            throw new IOException("access denied to restart CFMLEngine");
        }
        return this._restart();
    }

    public boolean restart(String configId, String password) throws IOException, ServletException {
        if (!this.engine.can(2, password)) {
            throw new IOException("access denied to restart CFML Context (configId:" + configId + ")");
        }
        return this._restart();
    }

    private synchronized boolean _restart() throws ServletException {
        this.engine.reset();
        this.initEngine();
        CFMLEngineFactory.registerInstance(this.engine);
        this.callListeners(this.engine);
        System.gc();
        System.gc();
        return true;
    }

    private boolean update() throws IOException, ServletException {
        URL hostUrl = this.getEngine().getUpdateLocation();
        if (hostUrl == null) {
            hostUrl = new URL("http://www.getrailo.org");
        }
        URL infoUrl = new URL(hostUrl, "/railo/remote/version/info.cfm?ext=" + this.getCoreExtension() + "&version=" + this.version);
        this.tlog("Check for update at " + hostUrl);
        String availableVersion = Util.toString((InputStream)infoUrl.getContent()).trim();
        if (availableVersion.length() != 9) {
            throw new IOException("can't get update info from [" + infoUrl + "]");
        }
        if (!this.isNewerThan(Util.toInVersion(availableVersion), this.version)) {
            this.tlog("There is no newer Version available");
            return false;
        }
        this.tlog("Found a newer Version \n - current Version " + Util.toStringVersion(this.version) + "\n - available Version " + availableVersion);
        URL updateUrl = new URL(hostUrl, "/railo/remote/version/update.cfm?ext=" + this.getCoreExtension() + "&version=" + availableVersion);
        System.out.println("updateurl:" + updateUrl);
        File patchDir = this.getPatchDirectory();
        File newRailo = new File(patchDir, String.valueOf(availableVersion) + "." + this.getCoreExtension());
        if (!newRailo.createNewFile()) {
            this.tlog("File for new Version already exists, dont copy new one");
            return false;
        }
        Util.copy((InputStream)updateUrl.getContent(), new FileOutputStream(newRailo));
        try {
            this.engine.reset();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        RailoClassLoader classLoader = new RailoClassLoader(newRailo, this.mainClassLoader);
        String v = "";
        try {
            CFMLEngine e = this.getEngine(classLoader);
            if (e == null) {
                throw new IOException("can't load engine");
            }
            v = e.getVersion();
            this.engine = e;
            this.version = Util.toInVersion(v);
            this.callListeners(e);
        }
        catch (Exception e) {
            classLoader = null;
            System.gc();
            try {
                newRailo.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tlog("There was a Problem with the new Version, can't install (" + e + ":" + e.getMessage() + ")");
            e.printStackTrace();
            return false;
        }
        this.tlog("Version (" + v + ")installed");
        return true;
    }

    public boolean removeUpdate(String password) throws IOException, ServletException {
        if (!this.engine.can(0, password)) {
            throw new IOException("access denied to update CFMLEngine");
        }
        return this.removeUpdate();
    }

    public boolean removeLatestUpdate(String password) throws IOException, ServletException {
        if (!this.engine.can(0, password)) {
            throw new IOException("access denied to update CFMLEngine");
        }
        return this.removeLatestUpdate();
    }

    private boolean removeUpdate() throws IOException, ServletException {
        File patchDir = this.getPatchDirectory();
        File[] patches = patchDir.listFiles(new ExtensionFilter(new String[]{"railo", "rc", "rcs"}));
        int i = 0;
        while (i < patches.length) {
            if (!patches[i].delete()) {
                patches[i].deleteOnExit();
            }
            ++i;
        }
        this._restart();
        return true;
    }

    private boolean removeLatestUpdate() throws IOException, ServletException {
        File patchDir = this.getPatchDirectory();
        File[] patches = patchDir.listFiles(new ExtensionFilter(new String[]{"." + this.getCoreExtension()}));
        File patch = null;
        int i = 0;
        while (i < patches.length) {
            if (patch == null || this.isNewerThan(Util.toInVersion(patches[i].getName()), Util.toInVersion(patch.getName()))) {
                patch = patches[i];
            }
            ++i;
        }
        if (patch != null && !patch.delete()) {
            patch.deleteOnExit();
        }
        this._restart();
        return true;
    }

    public String[] getInstalledPatches() throws ServletException, IOException {
        File patchDir = this.getPatchDirectory();
        File[] patches = patchDir.listFiles(new ExtensionFilter(new String[]{"." + this.getCoreExtension()}));
        ArrayList<String> list = new ArrayList<String>();
        int extLen = this.getCoreExtension().length() + 1;
        int i = 0;
        while (i < patches.length) {
            String name = patches[i].getName();
            name = name.substring(0, name.length() - extLen);
            list.add(name);
            ++i;
        }
        Object[] arr = list.toArray(new String[list.size()]);
        Arrays.sort(arr);
        return arr;
    }

    private void callListeners(CFMLEngine engine) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((EngineChangeListener)it.next()).onUpdate(engine);
        }
    }

    private File getPatchDirectory() throws IOException {
        File pd = new File(this.getResourceRoot(), "patches");
        if (!pd.exists()) {
            pd.mkdirs();
        }
        return pd;
    }

    public File getResourceRoot() throws IOException {
        if (this.resourceRoot == null) {
            this.resourceRoot = new File(this.getRuningContextRoot(), "railo-server");
            if (!this.resourceRoot.exists()) {
                this.resourceRoot.mkdirs();
            }
        }
        return this.resourceRoot;
    }

    private File getRuningContextRoot() throws IOException {
        if (railoServerRoot != null) {
            return railoServerRoot;
        }
        File dir = CFMLEngineFactory.getClassLoaderRoot(this.mainClassLoader);
        dir.mkdirs();
        if (dir.exists() && dir.isDirectory()) {
            return dir;
        }
        throw new IOException("can't create/write to directory [" + dir + "], set \"init-param\" \"railo-server-directory\" with path to writable directory");
    }

    public static File getClassLoaderRoot(ClassLoader cl) {
        File file;
        String path = "railo/loader/engine/CFMLEngine.class";
        URL res = cl.getResource(path);
        String strFile = null;
        try {
            strFile = URLDecoder.decode(res.getFile().trim(), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int index = strFile.indexOf(33);
        if (index != -1) {
            strFile = strFile.substring(0, index);
        }
        if ((index = strFile.lastIndexOf(path)) != -1) {
            strFile = strFile.substring(0, index);
        }
        if (strFile.startsWith("file:")) {
            strFile = strFile.substring(5);
        }
        if (strFile.endsWith("railo.jar")) {
            strFile = strFile.substring(0, strFile.length() - 9);
        }
        if ((file = new File(strFile)).isFile()) {
            file = file.getParentFile();
        }
        return file;
    }

    private boolean isNewerThan(int left, int right) {
        return left > right;
    }

    private CFMLEngine getEngine(ClassLoader classLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass("railo.runtime.engine.CFMLEngineImpl");
        Method m = clazz.getMethod("getInstance", CFMLEngineFactory.class);
        return (CFMLEngine)m.invoke(null, this);
    }

    public void tlog(Object obj) {
        System.out.println(new Date() + " " + obj);
    }

    public void log(Object obj) {
        System.out.println(obj.toString());
    }

    private class UpdateChecker
    extends Thread {
        private CFMLEngineFactory factory;

        private UpdateChecker(CFMLEngineFactory factory) {
            this.factory = factory;
        }

        @Override
        public void run() {
            long time = 10000L;
            while (true) {
                try {
                    while (true) {
                        UpdateChecker.sleep(time);
                        time = 86400000L;
                        this.factory.update();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

