/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.command.Generator;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.TableLink;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class LinkedIndex
extends Index {
    private TableLink link;
    private String originalTable;

    public LinkedIndex(TableLink table, int id, Column[] columns, IndexType indexType) {
        super(table, id, null, columns, indexType);
        this.link = table;
        this.originalTable = this.link.getOriginalTable();
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) throws SQLException {
    }

    public void add(Session session, Row row) throws SQLException {
        StringBuffer buff = new StringBuffer("INSERT INTO ");
        buff.append(Generator.quoteIdentifierAlways(this.originalTable));
        buff.append(" VALUES(");
        int j = 0;
        for (int i = 0; i < row.getColumnCount(); ++i) {
            Value v = row.getValue(i);
            if (v == null || v == ValueNull.INSTANCE) continue;
            if (j > 0) {
                buff.append(',');
            }
            ++j;
            buff.append('?');
        }
        buff.append(')');
        PreparedStatement prep = this.link.getPreparedStatement(buff.toString());
        int j2 = 0;
        for (int i = 0; i < row.getColumnCount(); ++i) {
            Value v = row.getValue(i);
            if (v == null || v == ValueNull.INSTANCE) continue;
            v.set(prep, j2 + 1);
            ++j2;
        }
        prep.executeUpdate();
        ++this.rowCount;
    }

    public void remove(Session session, Row row) throws SQLException {
        StringBuffer buff = new StringBuffer("DELETE FROM ");
        buff.append(Generator.quoteIdentifierAlways(this.originalTable));
        buff.append(" WHERE ");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            if (i > 0) {
                buff.append("AND ");
            }
            buff.append(this.table.getColumn(i).getSQL());
            buff.append("=? ");
        }
        PreparedStatement prep = this.link.getPreparedStatement(buff.toString());
        int j = 0;
        for (int i = 0; i < row.getColumnCount(); ++i) {
            Value v = row.getValue(i);
            if (v == null) continue;
            v.set(prep, j + 1);
            ++j;
        }
        prep.executeUpdate();
        --this.rowCount;
    }

    public Cursor find(Session session, Row first, Row last) throws SQLException {
        Value v;
        int i;
        Value v2;
        int i2;
        StringBuffer buff = new StringBuffer();
        for (i2 = 0; first != null && i2 < first.getColumnCount(); ++i2) {
            v2 = first.getValue(i2);
            if (v2 == null) continue;
            if (buff.length() != 0) {
                buff.append(" AND ");
            }
            buff.append(this.table.getColumn(i2).getSQL());
            buff.append(">=?");
        }
        for (i2 = 0; last != null && i2 < last.getColumnCount(); ++i2) {
            v2 = last.getValue(i2);
            if (v2 == null) continue;
            if (buff.length() != 0) {
                buff.append(" AND ");
            }
            buff.append(this.table.getColumn(i2).getSQL());
            buff.append("<=?");
        }
        if (buff.length() > 0) {
            buff.insert(0, " WHERE ");
        }
        buff.insert(0, "SELECT * FROM " + Generator.quoteIdentifierAlways(this.originalTable));
        PreparedStatement prep = this.link.getPreparedStatement(buff.toString());
        int j = 0;
        for (i = 0; first != null && i < first.getColumnCount(); ++i) {
            v = first.getValue(i);
            if (v == null) continue;
            v.set(prep, j + 1);
            ++j;
        }
        for (i = 0; last != null && i < last.getColumnCount(); ++i) {
            v = last.getValue(i);
            if (v == null) continue;
            v.set(prep, j + 1);
            ++j;
        }
        ResultSet rs = prep.executeQuery();
        return new LinkedCursor(this.table, rs, session);
    }

    public int getLookupCost(int rowCount) {
        int i = 0;
        int j = 1;
        while ((j *= 10) <= rowCount) {
            ++i;
        }
        return i + 1;
    }

    public int getCost(int[] masks) throws SQLException {
        return 100 + this.getCostRangeIndex(masks, this.rowCount + 1000);
    }

    public void remove(Session session) throws SQLException {
    }

    public void truncate(Session session) throws SQLException {
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }
}

