/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.tools.FileBase;
import org.h2.util.ByteUtils;
import org.h2.util.RandomUtils;
import org.h2.value.Value;

public class Recover
implements DataHandler {
    private String databaseName;
    private boolean textStorage;
    private PrintWriter writer;
    private int block;
    private int blockCount;
    private int storageId;
    private int recordLength;
    private int valueId;

    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-dir <dir>] [-db <database>]");
    }

    public static void main(String[] args) throws Exception {
        new Recover().run(args);
    }

    private void run(String[] args) throws Exception {
        String dir = ".";
        String db = null;
        boolean removePassword = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-dir".equals(args[i])) {
                dir = args[++i];
                continue;
            }
            if ("-db".equals(args[i])) {
                db = args[++i];
                continue;
            }
            if ("-removePassword".equals(args[i])) {
                removePassword = true;
                continue;
            }
            this.showUsage();
            return;
        }
        if (removePassword) {
            this.removePassword(dir, db);
        } else {
            Recover.execute(dir, db);
        }
    }

    private void removePassword(String dir, String db) throws Exception {
        ArrayList list = FileBase.getDatabaseFiles(dir, db, true);
        for (int i = 0; i < list.size(); ++i) {
            String fileName = (String)list.get(i);
            if (!fileName.endsWith(".data.db")) continue;
            this.removePassword(fileName);
        }
    }

    private void removePassword(String fileName) throws Exception {
        this.databaseName = fileName.substring(fileName.length() - ".data.db".length());
        this.textStorage = Database.isTextStorage(fileName, false);
        byte[] magic = Database.getMagic(this.textStorage);
        FileStore store = FileStore.open(null, fileName, magic, null, null);
        long length = store.length();
        int offset = 48;
        int blockSize = 128;
        int blocks = (int)(length / (long)blockSize);
        this.blockCount = 1;
        for (int block = 0; block < blocks; block += this.blockCount) {
            Value[] data;
            store.seek((long)offset + (long)block * (long)blockSize);
            byte[] bytes = new byte[blockSize];
            DataPage s = DataPage.create((DataHandler)this, bytes);
            long start = store.getFilePointer();
            store.readFully(bytes, 0, blockSize);
            this.blockCount = s.readInt();
            this.storageId = -1;
            this.recordLength = -1;
            this.valueId = -1;
            if (this.blockCount == 0) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount < 0) {
                this.blockCount = 1;
                continue;
            }
            try {
                s.checkCapacity(this.blockCount * blockSize);
            }
            catch (OutOfMemoryError e) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount > 1) {
                store.readFully(s.getBytes(), blockSize, this.blockCount * blockSize - blockSize);
            }
            try {
                s.check(this.blockCount * blockSize);
            }
            catch (SQLException e) {
                this.blockCount = 1;
                continue;
            }
            this.storageId = s.readInt();
            if (this.storageId != 0) continue;
            this.recordLength = s.readInt();
            if (this.recordLength <= 0) continue;
            try {
                data = new Value[this.recordLength];
            }
            catch (Throwable e) {
                continue;
            }
            this.valueId = 0;
            while (this.valueId < this.recordLength) {
                try {
                    data[this.valueId] = s.readValue();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                ++this.valueId;
            }
            if (this.storageId != 0) continue;
            try {
                int idx;
                String sql = data[3].getString();
                if (!sql.startsWith("CREATE USER ") || (idx = sql.indexOf("SALT")) < 0) continue;
                String userName = sql.substring("CREATE USER ".length(), idx - 1);
                if (userName.startsWith("\"")) {
                    userName = userName.substring(1, userName.length() - 1);
                }
                SHA256 sha = new SHA256();
                byte[] userPasswordHash = sha.getKeyPasswordHash(userName, "".toCharArray());
                byte[] salt = RandomUtils.getSecureBytes(8);
                byte[] passwordHash = sha.getHashWithSalt(userPasswordHash, salt);
                boolean admin = sql.indexOf("ADMIN") >= 0;
                StringBuffer buff = new StringBuffer();
                buff.append("CREATE USER ");
                buff.append(Parser.quoteIdentifier(userName));
                buff.append(" SALT '");
                buff.append(ByteUtils.convertBytesToString(salt));
                buff.append("' HASH '");
                buff.append(ByteUtils.convertBytesToString(passwordHash));
                buff.append("'");
                if (admin) {
                    buff.append(" ADMIN");
                }
                byte[] replacement = buff.toString().getBytes();
                int at = ByteUtils.indexOf(s.getBytes(), "CREATE USER ".getBytes(), 0);
                System.arraycopy(replacement, 0, s.getBytes(), at, replacement.length);
                s.fillAligned();
                s.updateChecksum();
                store.seek(start);
                store.write(s.getBytes(), 0, s.length());
                System.out.println("User: " + userName);
                break;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        store.close();
    }

    public static void execute(String dir, String db) throws Exception {
        new Recover().process(dir, db);
    }

    private void process(String dir, String db) throws Exception {
        ArrayList list = FileBase.getDatabaseFiles(dir, db, true);
        for (int i = 0; i < list.size(); ++i) {
            String fileName = (String)list.get(i);
            if (fileName.endsWith(".data.db")) {
                this.dumpData(fileName);
                continue;
            }
            if (fileName.endsWith(".log.db")) {
                this.dumpLog(fileName);
                continue;
            }
            if (!fileName.endsWith(".lob.db")) continue;
        }
    }

    private static PrintWriter getWriter(String fileName) throws IOException {
        fileName = fileName.substring(0, fileName.length() - 3);
        return new PrintWriter(new BufferedWriter(new FileWriter(fileName + ".txt")));
    }

    private void writeDataError(String error, byte[] data, int dumpBlocks) throws IOException {
        int x;
        int i;
        this.writer.println("-- ERROR:" + error + " block:" + this.block + " blockCount:" + this.blockCount + " storageId:" + this.storageId + " recordLength: " + this.recordLength + " valudId:" + this.valueId);
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < dumpBlocks * 128; ++i) {
            x = data[i] & 0xFF;
            if (x >= 32 && x < 128) {
                sb.append((char)x);
                continue;
            }
            sb.append('?');
        }
        for (i = 0; i < dumpBlocks * 128; ++i) {
            x = data[i] & 0xFF;
            sb.append(' ');
            if (x < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(x));
        }
        this.writer.println("-- dump: " + sb.toString());
    }

    private void dumpLog(String fileName) throws Exception {
    }

    private void dumpData(String fileName) throws Exception {
        this.databaseName = fileName.substring(fileName.length() - ".data.db".length());
        this.writer = Recover.getWriter(fileName);
        this.textStorage = Database.isTextStorage(fileName, false);
        byte[] magic = Database.getMagic(this.textStorage);
        FileStore store = FileStore.open(null, fileName, magic, null, null);
        long length = store.length();
        int offset = 48;
        int blockSize = 128;
        int blocks = (int)(length / (long)blockSize);
        this.blockCount = 1;
        int[] pageOwners = new int[blocks / 64];
        for (int block = 0; block < blocks; block += this.blockCount) {
            Value[] data;
            store.seek((long)offset + (long)block * (long)blockSize);
            byte[] buff = new byte[blockSize];
            DataPage s = DataPage.create((DataHandler)this, buff);
            store.readFully(buff, 0, blockSize);
            this.blockCount = s.readInt();
            this.storageId = -1;
            this.recordLength = -1;
            this.valueId = -1;
            if (this.blockCount == 0) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount < 0) {
                this.writeDataError("blockCount<0", s.getBytes(), 1);
                this.blockCount = 1;
                continue;
            }
            try {
                s.checkCapacity(this.blockCount * blockSize);
            }
            catch (OutOfMemoryError e) {
                this.writeDataError("out of memory", s.getBytes(), 1);
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount > 1) {
                store.readFully(s.getBytes(), blockSize, this.blockCount * blockSize - blockSize);
            }
            try {
                s.check(this.blockCount * blockSize);
            }
            catch (SQLException e) {
                this.writeDataError("wrong checksum", s.getBytes(), 1);
                this.blockCount = 1;
                continue;
            }
            this.storageId = s.readInt();
            if (this.storageId < 0) {
                this.writeDataError("storageId<0", s.getBytes(), this.blockCount);
                continue;
            }
            int page = block / 64;
            if (pageOwners[page] != 0 && pageOwners[page] != this.storageId) {
                this.writeDataError("double allocation, previous=" + pageOwners[page] + " now=" + this.storageId, s.getBytes(), this.blockCount);
            } else {
                pageOwners[page] = this.storageId;
            }
            this.recordLength = s.readInt();
            if (this.recordLength <= 0) {
                this.writeDataError("recordLength<0", s.getBytes(), this.blockCount);
                continue;
            }
            try {
                data = new Value[this.recordLength];
            }
            catch (OutOfMemoryError e) {
                this.writeDataError("out of memory", s.getBytes(), this.blockCount);
                continue;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("INSERT INTO O_" + this.storageId + " VALUES(");
            this.valueId = 0;
            while (this.valueId < this.recordLength) {
                try {
                    data[this.valueId] = s.readValue();
                    if (this.valueId > 0) {
                        sb.append(", ");
                    }
                    sb.append(data[this.valueId].getSQL());
                }
                catch (Exception e) {
                    this.writeDataError("exception " + e, s.getBytes(), this.blockCount);
                }
                catch (OutOfMemoryError e) {
                    this.writeDataError("out of memory", s.getBytes(), this.blockCount);
                }
                ++this.valueId;
            }
            sb.append(");");
            this.writer.println(sb.toString());
            if (this.storageId != 0) continue;
            try {
                int objectId = data[0].getInt();
                String sql = data[3].getString();
                this.writer.println("/* O_" + objectId + " */ " + sql + ";");
                continue;
            }
            catch (Exception e) {
                this.writer.println("-- ERROR in metadata: " + e.toString());
            }
        }
        store.close();
        this.writer.close();
    }

    public boolean getTextStorage() {
        return this.textStorage;
    }

    public String getDatabasePath() {
        return this.databaseName;
    }

    public FileStore openFile(String name) throws SQLException {
        return null;
    }

    public int getChecksum(byte[] data, int start, int end) {
        int x = 0;
        while (start < end) {
            x += data[start++];
        }
        return x;
    }

    public void checkPowerOff() throws SQLException {
    }

    public void checkWritingAllowed() throws SQLException {
    }

    public void freeUpDiskSpace() throws SQLException {
    }

    public void handleInvalidChecksum() throws SQLException {
    }
}

