/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MemoryStoreEvictionPolicy
implements Serializable {
    public static final MemoryStoreEvictionPolicy LRU = new MemoryStoreEvictionPolicy("LRU");
    public static final MemoryStoreEvictionPolicy LFU = new MemoryStoreEvictionPolicy("LFU");
    public static final MemoryStoreEvictionPolicy FIFO = new MemoryStoreEvictionPolicy("FIFO");
    private static final Logger LOG = Logger.getLogger(MemoryStoreEvictionPolicy.class.getName());
    private final String myName;

    private MemoryStoreEvictionPolicy(String policy) {
        this.myName = policy;
    }

    public String toString() {
        return this.myName;
    }

    public static MemoryStoreEvictionPolicy fromString(String policy) {
        if (policy != null) {
            if (policy.equalsIgnoreCase("LRU")) {
                return LRU;
            }
            if (policy.equalsIgnoreCase("LFU")) {
                return LFU;
            }
            if (policy.equalsIgnoreCase("FIFO")) {
                return FIFO;
            }
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("The memoryStoreEvictionPolicy of " + policy + " cannot be resolved. The policy will be" + " set to LRU");
        }
        return LRU;
    }
}

