/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDMatrix;
import org.pdfbox.pdmodel.font.PDSimpleFont;
import org.pdfbox.pdmodel.font.Type3StreamParser;

public class PDType3Font
extends PDSimpleFont {
    private static Logger log = Logger.getLogger((Class)(class$org$pdfbox$pdmodel$font$PDType3Font == null ? (class$org$pdfbox$pdmodel$font$PDType3Font = PDType3Font.class$("org.pdfbox.pdmodel.font.PDType3Font")) : class$org$pdfbox$pdmodel$font$PDType3Font));
    private Map images = new HashMap();
    static /* synthetic */ Class class$org$pdfbox$pdmodel$font$PDType3Font;

    public PDType3Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.getPDFName("Type3"));
    }

    public PDType3Font(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    private Image createImageIfNecessary(char character) throws IOException {
        Character c = new Character(character);
        Image retval = (Image)this.images.get(c);
        if (retval == null) {
            COSDictionary charProcs = (COSDictionary)this.font.getDictionaryObject(COSName.getPDFName("CharProcs"));
            COSStream stream = (COSStream)charProcs.getDictionaryObject(COSName.getPDFName("" + character));
            if (stream != null) {
                Type3StreamParser parser = new Type3StreamParser();
                retval = parser.createImage(stream);
                this.images.put(c, retval);
            } else {
                log.warn((Object)"Error font type 3 image stream is null");
            }
        }
        return retval;
    }

    public void drawString(String string, Graphics g, float fontSize, float x, float y) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            Image image = this.createImageIfNecessary(c);
            if (image == null) continue;
            int newWidth = (int)(0.12 * (double)image.getWidth(null));
            int newHeight = (int)(0.12 * (double)image.getHeight(null));
            if (newWidth <= 0 || newHeight <= 0) continue;
            image = image.getScaledInstance(newWidth, newHeight, 4);
            g.drawImage(image, (int)x, (int)y, null);
            x += (float)newWidth;
        }
    }

    public void setFontMatrix(PDMatrix matrix) {
        this.font.setItem("FontMatrix", (COSObjectable)matrix);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

