/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.StringUtils;

public class JdbcDatabaseMetaData
extends TraceObject
implements DatabaseMetaData {
    private JdbcConnection conn;

    public int getDriverMajorVersion() {
        this.infoCodeCall("getDriverMajorVersion");
        return 0;
    }

    public int getDriverMinorVersion() {
        this.infoCodeCall("getDriverMinorVersion");
        return 9;
    }

    public String getDatabaseProductName() {
        this.infoCodeCall("getDatabaseProductName");
        return "H2";
    }

    public String getDatabaseProductVersion() {
        this.infoCodeCall("getDatabaseProductVersion");
        return Constants.getVersion();
    }

    public String getDriverName() {
        this.infoCodeCall("getDriverName");
        return "H2 JDBC Driver";
    }

    public String getDriverVersion() {
        this.infoCodeCall("getDriverVersion");
        return Constants.getVersion();
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getTables(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(tableNamePattern) + ", " + this.quoteArray(types) + ");");
            }
            this.checkClosed();
            String tableType = "";
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    String type = StringUtils.quoteStringSQL(types[i]);
                    if (tableType.length() > 0) {
                        tableType = tableType + " OR ";
                    }
                    tableType = tableType + "TABLE_TYPE=" + type;
                }
            }
            if (tableType.length() == 0) {
                tableType = "1=1";
            }
            PreparedStatement prep = this.conn.prepareStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, '' REMARKS, SQL FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME LIKE ? AND (" + tableType + ") " + "ORDER BY TABLE_TYPE, TABLE_SCHEMA, TABLE_NAME");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schemaPattern));
            prep.setString(3, this.getPattern(tableNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getColumns(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(tableNamePattern) + ", " + this.quote(columnNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, CHARACTER_MAXIMUM_LENGTH COLUMN_SIZE, CHARACTER_MAXIMUM_LENGTH BUFFER_LENGTH, NUMERIC_SCALE DECIMAL_DIGITS, 10 NUM_PREC_RADIX, NULLABLE, '' REMARKS, COLUMN_DEFAULT COLUMN_DEF, DATA_TYPE SQL_DATA_TYPE, 0 SQL_DATETIME_SUB, CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE IS_NULLABLE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME LIKE ? AND COLUMN_NAME LIKE ? ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schemaPattern));
            prep.setString(3, this.getPattern(tableNamePattern));
            prep.setString(4, this.getPattern(columnNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getIndexInfo(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ", " + unique + ", " + approximate + ");");
            }
            String uniqueCondition = unique ? "NON_UNIQUE=FALSE" : "1=1";
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, NON_UNIQUE, TABLE_CATALOG INDEX_QUALIFIER, INDEX_NAME, CAST(3 AS SMALLINT) TYPE, CAST(ORDINAL_POSITION AS SMALLINT) ORDINAL_POSITION, COLUMN_NAME, 'A' ASC_OR_DESC, CARDINALITY, 0 PAGES, '' FILTER_CONDITION FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND (" + uniqueCondition + ") " + "AND TABLE_NAME = ? " + "ORDER BY NON_UNIQUE, TYPE, TABLE_SCHEM, INDEX_NAME, ORDINAL_POSITION");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String tableName) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getPrimaryKeys(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, CAST(ORDINAL_POSITION AS SMALLINT) KEY_SEQ, INDEX_NAME PK_NAME FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME = ? AND PRIMARY_KEY='TRUE' ORDER BY COLUMN_NAME");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean allProceduresAreCallable() {
        this.infoCodeCall("allProceduresAreCallable");
        return true;
    }

    public boolean allTablesAreSelectable() {
        this.infoCodeCall("allTablesAreSelectable");
        return true;
    }

    public String getURL() throws SQLException {
        try {
            this.infoCodeCall("getURL");
            return this.conn.getURL();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getUserName() throws SQLException {
        try {
            this.infoCodeCall("getUserName");
            return this.conn.getUser();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.infoCodeCall("isReadOnly");
            return this.conn.isReadOnly();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean nullsAreSortedHigh() {
        this.infoCodeCall("nullsAreSortedHigh");
        return false;
    }

    public boolean nullsAreSortedLow() {
        this.infoCodeCall("nullsAreSortedLow");
        return true;
    }

    public boolean nullsAreSortedAtStart() {
        this.infoCodeCall("nullsAreSortedAtStart");
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        this.infoCodeCall("nullsAreSortedAtEnd");
        return false;
    }

    public Connection getConnection() {
        this.infoCodeCall("getConnection");
        return this.conn;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getProcedures(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(procedureNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT '' PROCEDURE_CAT, '' PROCEDURE_SCHEM, '' PROCEDURE_NAME, CAST(0 AS INT) NUM_INPUT_PARAMS, CAST(0 AS INT) NUM_OUTPUT_PARAMS, CAST(0 AS INT) NUM_RESULT_SETS, '' REMARKS, CAST(0 AS SMALLINT) PROCEDURE_TYPE FROM INFORMATION_SCHEMA.TABLES WHERE 1=0");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getProcedureColumns(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(procedureNamePattern) + ", " + this.quote(columnNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT '' PROCEDURE_CAT, '' PROCEDURE_SCHEM, '' PROCEDURE_NAME, '' COLUMN_NAME, CAST(0 AS SMALLINT) COLUMN_TYPE, CAST(0 AS SMALLINT) DATA_TYPE, '' TYPE_NAME, CAST(0 AS INT) PRECISION, CAST(0 AS INT) LENGTH, CAST(0 AS SMALLINT) SCALE, CAST(0 AS INT) RADIX, CAST(0 AS SMALLINT) NULLABLE, '' REMARKSFROM INFORMATION_SCHEMA.TABLES WHERE 1=0");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getSchemas() throws SQLException {
        try {
            this.infoCodeCall("getSchemas");
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT SCHEMA_NAME TABLE_SCHEM, CATALOG_NAME TABLE_CATALOG,  IS_DEFAULT FROM INFORMATION_SCHEMA.SCHEMATA ORDER BY SCHEMA_NAME");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getCatalogs() throws SQLException {
        try {
            this.infoCodeCall("getCatalogs");
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT CATALOG_NAME TABLE_CAT FROM INFORMATION_SCHEMA.CATALOGS");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getTableTypes() throws SQLException {
        try {
            this.infoCodeCall("getTableTypes");
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT TYPE TABLE_TYPE FROM INFORMATION_SCHEMA.TABLE_TYPES ORDER BY TABLE_TYPE");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getColumnPrivileges(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(table) + ", " + this.quote(columnNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME = ? AND COLUMN_NAME LIKE ? ORDER BY COLUMN_NAME, PRIVILEGE");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schema));
            prep.setString(3, table);
            prep.setString(4, this.getPattern(columnNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getTablePrivileges(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(tableNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME LIKE ? ORDER BY TABLE_SCHEM, TABLE_NAME, PRIVILEGE");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schemaPattern));
            prep.setString(3, this.getPattern(tableNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String tableName, int scope, boolean nullable) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getBestRowIdentifier(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ", " + scope + ", " + nullable + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT CAST(2 AS SMALLINT) SCOPE, C.COLUMN_NAME, C.DATA_TYPE, C.TYPE_NAME, C.CHARACTER_MAXIMUM_LENGTH COLUMN_SIZE, C.CHARACTER_MAXIMUM_LENGTH BUFFER_LENGTH, CAST(C.NUMERIC_SCALE AS SMALLINT) DECIMAL_DIGITS, CAST(1 AS SMALLINT) PSEUDO_COLUMN FROM INFORMATION_SCHEMA.INDEXES I,  INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME = I.TABLE_NAME AND C.COLUMN_NAME = I.COLUMN_NAME AND C.TABLE_CATALOG LIKE ? AND C.TABLE_SCHEMA LIKE ? AND C.TABLE_NAME = ? AND I.PRIMARY_KEY='TRUE' ORDER BY SCOPE");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getVersionColumns(String catalog, String schema, String tableName) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getVersionColumns(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT CAST(0 AS INT) SCOPE, '' COLUMN_NAME, CAST(0 AS INT) DATA_TYPE, '' TYPE_NAME, CAST(0 AS INT) COLUMN_SIZE, CAST(0 AS INT) BUFFER_LENGTH, CAST(0 AS INT) DECIMAL_DIGITS, CAST(0 AS INT) PSEUDO_COLUMN FROM INFORMATION_SCHEMA.TABLES WHERE 1=0");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getImportedKeys(String catalog, String schema, String tableName) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getImportedKeys(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, CAST(ORDINAL_POSITION  AS SMALLINT) KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, CAST(7 AS SMALLINT) DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE FKTABLE_CATALOG LIKE ? AND FKTABLE_SCHEMA LIKE ? AND FKTABLE_NAME = ? ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, FK_NAME, KEY_SEQ");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getExportedKeys(String catalog, String schema, String tableName) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getExportedKeys(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, CAST(ORDINAL_POSITION  AS SMALLINT) KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, CAST(7 AS SMALLINT) DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE PKTABLE_CATALOG LIKE ? AND PKTABLE_SCHEMA LIKE ? AND PKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FK_NAME, KEY_SEQ");
            prep.setString(1, this.getPattern(catalog));
            prep.setString(2, this.getPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getCrossReference(" + this.quote(primaryCatalog) + ", " + this.quote(primarySchema) + ", " + this.quote(primaryTable) + ", " + this.quote(foreignCatalog) + ", " + this.quote(foreignSchema) + ", " + this.quote(foreignTable) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, CAST(ORDINAL_POSITION  AS SMALLINT) KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, CAST(7 AS SMALLINT) DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE PKTABLE_CATALOG LIKE ? AND PKTABLE_SCHEMA LIKE ? AND PKTABLE_NAME = ? AND FKTABLE_CATALOG LIKE ? AND FKTABLE_SCHEMA LIKE ? AND FKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FK_NAME, KEY_SEQ");
            prep.setString(1, this.getPattern(primaryCatalog));
            prep.setString(2, this.getPattern(primarySchema));
            prep.setString(3, primaryTable);
            prep.setString(4, this.getPattern(foreignCatalog));
            prep.setString(5, this.getPattern(foreignSchema));
            prep.setString(6, foreignTable);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getUDTs(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(typeNamePattern) + ", " + this.quoteIntArray(types) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT '' TYPE_CAT, '' TYPE_SCHEM, '' TYPE_NAME, '' CLASS_NAME, CAST(0  AS SMALLINT) DATA_TYPE, '' REMARKS, CAST(0 AS SMALLINT) BASE_TYPE FROM INFORMATION_SCHEMA.TABLES WHERE 1=0");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        try {
            this.infoCodeCall("getTypeInfo");
            this.checkClosed();
            return this.conn.createStatement().executeQuery("SELECT TYPE_NAME, DATA_TYPE, PRECISION, PREFIX LITERAL_PREFIX, SUFFIX LITERAL_SUFFIX, PARAMS CREATE_PARAMS, CAST(1 AS SMALLINT) NULLABLE, CASE_SENSITIVE, CAST(3 AS SMALLINT) SEARCHABLE, CAST('FALSE' AS BIT) UNSIGNED_ATTRIBUTE, CAST('FALSE' AS BIT) FIXED_PREC_SCALE, AUTO_INCREMENT, TYPE_NAME LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, DATA_TYPE SQL_DATA_TYPE, CAST(1 AS INT) SQL_DATETIME_SUB, RADIX NUM_PREC_RADIX FROM INFORMATION_SCHEMA.TYPE_INFO ORDER BY DATA_TYPE, POS");
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean usesLocalFiles() {
        this.infoCodeCall("usesLocalFiles");
        return true;
    }

    public boolean usesLocalFilePerTable() {
        this.infoCodeCall("usesLocalFilePerTable");
        return false;
    }

    public String getIdentifierQuoteString() {
        this.infoCodeCall("getIdentifierQuoteString");
        return "\"";
    }

    public String getSQLKeywords() {
        this.infoCodeCall("getSQLKeywords");
        return "";
    }

    public String getNumericFunctions() throws SQLException {
        this.infoCodeCall("getNumericFunctions");
        return this.getFunctions("Functions (Numeric)");
    }

    public String getStringFunctions() throws SQLException {
        this.infoCodeCall("getStringFunctions");
        return this.getFunctions("Functions (String)");
    }

    public String getSystemFunctions() throws SQLException {
        this.infoCodeCall("getSystemFunctions");
        return this.getFunctions("Functions (System)");
    }

    public String getTimeDateFunctions() throws SQLException {
        this.infoCodeCall("getTimeDateFunctions");
        return this.getFunctions("Functions (Time and Date)");
    }

    private String getFunctions(String section) throws SQLException {
        try {
            StringBuffer buff = new StringBuffer();
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareStatement("SELECT TOPIC FROM INFORMATION_SCHEMA.HELP WHERE SECTION = ?");
            prep.setString(1, section);
            ResultSet rs = prep.executeQuery();
            while (rs.next()) {
                String s = rs.getString(1).trim();
                String[] array = StringUtils.arraySplit(s, ',');
                for (int i = 0; i < array.length; ++i) {
                    String f;
                    if (buff.length() > 0) {
                        buff.append(",");
                    }
                    if ((f = array[i].trim()).indexOf(32) >= 0) {
                        f = f.substring(0, f.indexOf(32)).trim();
                    }
                    buff.append(f);
                }
            }
            rs.close();
            prep.close();
            return buff.toString();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getSearchStringEscape() {
        this.infoCodeCall("getSearchStringEscape");
        return "\\";
    }

    public String getExtraNameCharacters() {
        this.infoCodeCall("getExtraNameCharacters");
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() {
        this.infoCodeCall("supportsAlterTableWithAddColumn");
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() {
        this.infoCodeCall("supportsAlterTableWithDropColumn");
        return true;
    }

    public boolean supportsColumnAliasing() {
        this.infoCodeCall("supportsColumnAliasing");
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        this.infoCodeCall("nullPlusNonNullIsNull");
        return true;
    }

    public boolean supportsConvert() {
        this.infoCodeCall("supportsConvert");
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (this.info()) {
            this.infoCode("supportsConvert(" + fromType + ", " + fromType + ");");
        }
        return true;
    }

    public boolean supportsTableCorrelationNames() {
        this.infoCodeCall("supportsTableCorrelationNames");
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        this.infoCodeCall("supportsDifferentTableCorrelationNames");
        return false;
    }

    public boolean supportsExpressionsInOrderBy() {
        this.infoCodeCall("supportsExpressionsInOrderBy");
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        this.infoCodeCall("supportsOrderByUnrelated");
        return true;
    }

    public boolean supportsGroupBy() {
        this.infoCodeCall("supportsGroupBy");
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        this.infoCodeCall("supportsGroupByUnrelated");
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        this.infoCodeCall("supportsGroupByBeyondSelect");
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        this.infoCodeCall("supportsLikeEscapeClause");
        return true;
    }

    public boolean supportsMultipleResultSets() {
        this.infoCodeCall("supportsMultipleResultSets");
        return false;
    }

    public boolean supportsMultipleTransactions() {
        this.infoCodeCall("supportsMultipleTransactions");
        return true;
    }

    public boolean supportsNonNullableColumns() {
        this.infoCodeCall("supportsNonNullableColumns");
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        this.infoCodeCall("supportsMinimumSQLGrammar");
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        this.infoCodeCall("supportsCoreSQLGrammar");
        return true;
    }

    public boolean supportsExtendedSQLGrammar() {
        this.infoCodeCall("supportsExtendedSQLGrammar");
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        this.infoCodeCall("supportsANSI92EntryLevelSQL");
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() {
        this.infoCodeCall("supportsANSI92IntermediateSQL");
        return false;
    }

    public boolean supportsANSI92FullSQL() {
        this.infoCodeCall("supportsANSI92FullSQL");
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        this.infoCodeCall("supportsIntegrityEnhancementFacility");
        return true;
    }

    public boolean supportsOuterJoins() {
        this.infoCodeCall("supportsOuterJoins");
        return true;
    }

    public boolean supportsFullOuterJoins() {
        this.infoCodeCall("supportsFullOuterJoins");
        return false;
    }

    public boolean supportsLimitedOuterJoins() {
        this.infoCodeCall("supportsLimitedOuterJoins");
        return true;
    }

    public String getSchemaTerm() {
        this.infoCodeCall("getSchemaTerm");
        return "schema";
    }

    public String getProcedureTerm() {
        this.infoCodeCall("getProcedureTerm");
        return "procedure";
    }

    public String getCatalogTerm() {
        this.infoCodeCall("getCatalogTerm");
        return "catalog";
    }

    public boolean isCatalogAtStart() {
        this.infoCodeCall("isCatalogAtStart");
        return true;
    }

    public String getCatalogSeparator() {
        this.infoCodeCall("getCatalogSeparator");
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() {
        this.infoCodeCall("supportsSchemasInDataManipulation");
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() {
        this.infoCodeCall("supportsSchemasInProcedureCalls");
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() {
        this.infoCodeCall("supportsSchemasInTableDefinitions");
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        this.infoCodeCall("supportsSchemasInIndexDefinitions");
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        this.infoCodeCall("supportsSchemasInPrivilegeDefinitions");
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() {
        this.infoCodeCall("supportsCatalogsInDataManipulation");
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        this.infoCodeCall("supportsCatalogsInProcedureCalls");
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        this.infoCodeCall("supportsCatalogsInTableDefinitions");
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        this.infoCodeCall("supportsCatalogsInIndexDefinitions");
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        this.infoCodeCall("supportsCatalogsInPrivilegeDefinitions");
        return false;
    }

    public boolean supportsPositionedDelete() {
        this.infoCodeCall("supportsPositionedDelete");
        return true;
    }

    public boolean supportsPositionedUpdate() {
        this.infoCodeCall("supportsPositionedUpdate");
        return true;
    }

    public boolean supportsSelectForUpdate() {
        this.infoCodeCall("supportsSelectForUpdate");
        return true;
    }

    public boolean supportsStoredProcedures() {
        this.infoCodeCall("supportsStoredProcedures");
        return false;
    }

    public boolean supportsSubqueriesInComparisons() {
        this.infoCodeCall("supportsSubqueriesInComparisons");
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        this.infoCodeCall("supportsSubqueriesInExists");
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        this.infoCodeCall("supportsSubqueriesInIns");
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        this.infoCodeCall("supportsSubqueriesInQuantifieds");
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        this.infoCodeCall("supportsCorrelatedSubqueries");
        return true;
    }

    public boolean supportsUnion() {
        this.infoCodeCall("supportsUnion");
        return true;
    }

    public boolean supportsUnionAll() {
        this.infoCodeCall("supportsUnionAll");
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        this.infoCodeCall("supportsOpenCursorsAcrossCommit");
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        this.infoCodeCall("supportsOpenCursorsAcrossRollback");
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        this.infoCodeCall("supportsOpenStatementsAcrossCommit");
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        this.infoCodeCall("supportsOpenStatementsAcrossRollback");
        return true;
    }

    public boolean supportsTransactions() {
        this.infoCodeCall("supportsTransactions");
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) {
        this.infoCodeCall("supportsTransactionIsolationLevel");
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        this.infoCodeCall("supportsDataDefinitionAndDataManipulationTransactions");
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        this.infoCodeCall("supportsDataManipulationTransactionsOnly");
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        this.infoCodeCall("dataDefinitionCausesTransactionCommit");
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() {
        this.infoCodeCall("dataDefinitionIgnoredInTransactions");
        return false;
    }

    public boolean supportsResultSetType(int type) {
        this.infoCodeCall("supportsResultSetType", type);
        return type != 1005;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        if (this.info()) {
            this.infoCode("supportsResultSetConcurrency(" + type + ", " + concurrency + ");");
        }
        return type != 1005;
    }

    public boolean ownUpdatesAreVisible(int type) {
        this.infoCodeCall("ownUpdatesAreVisible", type);
        return false;
    }

    public boolean ownDeletesAreVisible(int type) {
        this.infoCodeCall("ownDeletesAreVisible", type);
        return false;
    }

    public boolean ownInsertsAreVisible(int type) {
        this.infoCodeCall("ownInsertsAreVisible", type);
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) {
        this.infoCodeCall("othersUpdatesAreVisible", type);
        return false;
    }

    public boolean othersDeletesAreVisible(int type) {
        this.infoCodeCall("othersDeletesAreVisible", type);
        return false;
    }

    public boolean othersInsertsAreVisible(int type) {
        this.infoCodeCall("othersInsertsAreVisible", type);
        return false;
    }

    public boolean updatesAreDetected(int type) {
        this.infoCodeCall("updatesAreDetected", type);
        return false;
    }

    public boolean deletesAreDetected(int type) {
        this.infoCodeCall("deletesAreDetected", type);
        return false;
    }

    public boolean insertsAreDetected(int type) {
        this.infoCodeCall("insertsAreDetected", type);
        return false;
    }

    public boolean supportsBatchUpdates() {
        this.infoCodeCall("supportsBatchUpdates");
        return true;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        this.infoCodeCall("doesMaxRowSizeIncludeBlobs");
        return false;
    }

    public int getDefaultTransactionIsolation() {
        this.infoCodeCall("getDefaultTransactionIsolation");
        return 2;
    }

    public boolean supportsMixedCaseIdentifiers() {
        this.infoCodeCall("supportsMixedCaseIdentifiers");
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        this.infoCodeCall("supportsMixedCaseQuotedIdentifiers");
        return true;
    }

    public boolean storesUpperCaseIdentifiers() {
        this.infoCodeCall("storesUpperCaseIdentifiers");
        return true;
    }

    public boolean storesLowerCaseIdentifiers() {
        this.infoCodeCall("storesLowerCaseIdentifiers");
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        this.infoCodeCall("storesMixedCaseIdentifiers");
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        this.infoCodeCall("storesUpperCaseQuotedIdentifiers");
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        this.infoCodeCall("storesLowerCaseQuotedIdentifiers");
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        this.infoCodeCall("storesMixedCaseQuotedIdentifiers");
        return true;
    }

    public int getMaxBinaryLiteralLength() {
        this.infoCodeCall("getMaxBinaryLiteralLength");
        return 0;
    }

    public int getMaxCharLiteralLength() {
        this.infoCodeCall("getMaxCharLiteralLength");
        return 0;
    }

    public int getMaxColumnNameLength() {
        this.infoCodeCall("getMaxColumnNameLength");
        return 0;
    }

    public int getMaxColumnsInGroupBy() {
        this.infoCodeCall("getMaxColumnsInGroupBy");
        return 0;
    }

    public int getMaxColumnsInIndex() {
        this.infoCodeCall("getMaxColumnsInIndex");
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        this.infoCodeCall("getMaxColumnsInOrderBy");
        return 0;
    }

    public int getMaxColumnsInSelect() {
        this.infoCodeCall("getMaxColumnsInSelect");
        return 0;
    }

    public int getMaxColumnsInTable() {
        this.infoCodeCall("getMaxColumnsInTable");
        return 0;
    }

    public int getMaxConnections() {
        this.infoCodeCall("getMaxConnections");
        return 0;
    }

    public int getMaxCursorNameLength() {
        this.infoCodeCall("getMaxCursorNameLength");
        return 0;
    }

    public int getMaxIndexLength() {
        this.infoCodeCall("getMaxIndexLength");
        return 0;
    }

    public int getMaxSchemaNameLength() {
        this.infoCodeCall("getMaxSchemaNameLength");
        return 0;
    }

    public int getMaxProcedureNameLength() {
        this.infoCodeCall("getMaxProcedureNameLength");
        return 0;
    }

    public int getMaxCatalogNameLength() {
        this.infoCodeCall("getMaxCatalogNameLength");
        return 0;
    }

    public int getMaxRowSize() {
        this.infoCodeCall("getMaxRowSize");
        return 0;
    }

    public int getMaxStatementLength() {
        this.infoCodeCall("getMaxStatementLength");
        return 0;
    }

    public int getMaxStatements() {
        this.infoCodeCall("getMaxStatements");
        return 0;
    }

    public int getMaxTableNameLength() {
        this.infoCodeCall("getMaxTableNameLength");
        return 0;
    }

    public int getMaxTablesInSelect() {
        this.infoCodeCall("getMaxTablesInSelect");
        return 0;
    }

    public int getMaxUserNameLength() {
        this.infoCodeCall("getMaxUserNameLength");
        return 0;
    }

    public boolean supportsSavepoints() {
        this.infoCodeCall("supportsSavepoints");
        return true;
    }

    public boolean supportsNamedParameters() {
        this.infoCodeCall("supportsNamedParameters");
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        this.infoCodeCall("supportsMultipleOpenResults");
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        this.infoCodeCall("supportsGetGeneratedKeys");
        return true;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getSuperTypes(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(typeNamePattern) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getSuperTables(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(tableNamePattern) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("getAttributes(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(typeNamePattern) + ", " + this.quote(attributeNamePattern) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean supportsResultSetHoldability(int holdability) {
        this.infoCodeCall("supportsResultSetHoldability", holdability);
        return holdability == 2;
    }

    public int getResultSetHoldability() {
        this.infoCodeCall("getResultSetHoldability");
        return 2;
    }

    public int getDatabaseMajorVersion() {
        this.infoCodeCall("getDatabaseMajorVersion");
        return 0;
    }

    public int getDatabaseMinorVersion() {
        this.infoCodeCall("getDatabaseMinorVersion");
        return 9;
    }

    public int getJDBCMajorVersion() throws SQLException {
        this.infoCodeCall("getJDBCMajorVersion");
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        this.infoCodeCall("getJDBCMinorVersion");
        return 0;
    }

    public int getSQLStateType() {
        this.infoCodeCall("getSQLStateType");
        return 2;
    }

    public boolean locatorsUpdateCopy() {
        this.infoCodeCall("locatorsUpdateCopy");
        return false;
    }

    public boolean supportsStatementPooling() {
        this.infoCodeCall("supportsStatementPooling");
        return false;
    }

    JdbcDatabaseMetaData(JdbcConnection conn, Trace trace, int id) {
        this.setTrace(trace, 2, id);
        this.conn = conn;
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
    }

    private String getPattern(String pattern) {
        return pattern == null ? "%" : pattern;
    }
}

