/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.CMap;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFont
implements FontFile {
    private static final Logger log = Logger.getLogger(OFont.class.toString());
    private Font awtFont;
    private Rectangle2D maxCharBounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    private HashMap<String, Point2D.Float> echarAdvanceCache;
    protected float[] widths;
    protected Map<Integer, Float> cidWidths;
    protected float missingWidth;
    protected int firstCh;
    protected float ascent;
    protected float descent;
    protected org.icepdf.core.pobjects.fonts.Encoding encoding;
    protected CMap toUnicode;
    protected char[] cMap;

    public OFont(Font font) {
        this.awtFont = font;
        this.maxCharBounds = new Rectangle2D.Double();
        this.echarAdvanceCache = new HashMap(256);
    }

    private OFont(OFont oFont) {
        this.echarAdvanceCache = oFont.echarAdvanceCache;
        this.awtFont = oFont.awtFont;
        this.encoding = oFont.encoding;
        this.toUnicode = oFont.toUnicode;
        this.missingWidth = oFont.missingWidth;
        this.firstCh = oFont.firstCh;
        this.ascent = oFont.ascent;
        this.descent = oFont.descent;
        this.widths = oFont.widths;
        this.cidWidths = oFont.cidWidths;
        this.cMap = oFont.cMap;
        this.maxCharBounds = oFont.maxCharBounds;
    }

    @Override
    public FontFile deriveFont(org.icepdf.core.pobjects.fonts.Encoding encoding, CMap cMap) {
        OFont oFont = new OFont(this);
        this.echarAdvanceCache.clear();
        oFont.encoding = encoding;
        oFont.toUnicode = cMap;
        return oFont;
    }

    @Override
    public FontFile deriveFont(float[] fArray, int n, float f, float f2, float f3, char[] cArray) {
        OFont oFont = new OFont(this);
        this.echarAdvanceCache.clear();
        oFont.missingWidth = this.missingWidth;
        oFont.firstCh = n;
        oFont.ascent = f2;
        oFont.descent = f3;
        oFont.widths = fArray;
        oFont.cMap = cArray;
        return oFont;
    }

    @Override
    public FontFile deriveFont(Map<Integer, Float> map, int n, float f, float f2, float f3, char[] cArray) {
        OFont oFont = new OFont(this);
        this.echarAdvanceCache.clear();
        oFont.missingWidth = this.missingWidth;
        oFont.firstCh = n;
        oFont.ascent = f2;
        oFont.descent = f3;
        oFont.cidWidths = map;
        oFont.cMap = cArray;
        return oFont;
    }

    @Override
    public FontFile deriveFont(AffineTransform affineTransform) {
        OFont oFont = new OFont(this);
        if (!oFont.getTransform().equals(this.awtFont.getTransform())) {
            this.echarAdvanceCache.clear();
        }
        oFont.awtFont = this.awtFont.deriveFont(affineTransform);
        oFont.maxCharBounds = this.maxCharBounds;
        return oFont;
    }

    @Override
    public boolean canDisplayEchar(char c) {
        return true;
    }

    @Override
    public FontFile deriveFont(float f) {
        OFont oFont = new OFont(this);
        if (oFont.getSize() != f) {
            this.echarAdvanceCache.clear();
        }
        oFont.awtFont = this.awtFont.deriveFont(f);
        oFont.maxCharBounds = this.maxCharBounds;
        return oFont;
    }

    @Override
    public Point2D echarAdvance(char c) {
        float f;
        float f2;
        String string = String.valueOf(c);
        Point2D.Float float_ = this.echarAdvanceCache.get(string);
        if (float_ == null) {
            char c2 = this.getCMapping(c);
            GlyphVector glyphVector = this.awtFont.createGlyphVector(new FontRenderContext(new AffineTransform(), true, true), String.valueOf(c2));
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
            TextLayout textLayout = new TextLayout(String.valueOf(c2), this.awtFont, fontRenderContext);
            this.maxCharBounds = this.awtFont.getMaxCharBounds(fontRenderContext);
            this.ascent = textLayout.getAscent();
            this.descent = textLayout.getDescent();
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
            f2 = glyphMetrics.getAdvanceX();
            f = glyphMetrics.getAdvanceY();
            this.echarAdvanceCache.put(string, new Point2D.Float(f2, f));
        } else {
            f2 = float_.x;
            f = float_.y;
        }
        if (this.widths != null && c - this.firstCh >= 0 && c - this.firstCh < this.widths.length) {
            f2 = this.widths[c - this.firstCh] * this.awtFont.getSize2D();
        } else if (this.cidWidths != null) {
            Float f3 = this.cidWidths.get(c);
            if (f3 != null) {
                f2 = this.cidWidths.get(c).floatValue() * this.awtFont.getSize2D();
            }
        } else if (this.missingWidth > 0.0f) {
            f2 = this.missingWidth / 1000.0f;
        }
        return new Point2D.Float(f2, f);
    }

    private char getCMapping(char c) {
        if (this.toUnicode != null) {
            return this.toUnicode.toSelector(c);
        }
        return c;
    }

    private char getCharDiff(char c) {
        if (this.cMap != null && c < this.cMap.length) {
            return this.cMap[c];
        }
        return c;
    }

    private char findAlternateSymbol(char c) {
        for (int i = 0; i < Encoding.symbolAlaises.length; ++i) {
            for (int j = 0; j < Encoding.symbolAlaises[i].length; ++j) {
                if (Encoding.symbolAlaises[i][j] != c) continue;
                return (char)Encoding.symbolAlaises[i][0];
            }
        }
        return c;
    }

    @Override
    public CMap getToUnicode() {
        return this.toUnicode;
    }

    @Override
    public int getStyle() {
        return this.awtFont.getStyle();
    }

    @Override
    public String getFamily() {
        return this.awtFont.getFamily();
    }

    @Override
    public float getSize() {
        return this.awtFont.getSize();
    }

    @Override
    public double getAscent() {
        return this.ascent;
    }

    @Override
    public double getDescent() {
        return this.descent;
    }

    @Override
    public Rectangle2D getMaxCharBounds() {
        return this.maxCharBounds;
    }

    @Override
    public AffineTransform getTransform() {
        return this.awtFont.getTransform();
    }

    @Override
    public int getRights() {
        return 0;
    }

    @Override
    public String getName() {
        return this.awtFont.getName();
    }

    @Override
    public boolean isHinted() {
        return false;
    }

    @Override
    public int getNumGlyphs() {
        return this.awtFont.getNumGlyphs();
    }

    @Override
    public char getSpaceEchar() {
        return ' ';
    }

    @Override
    public Rectangle2D getEstringBounds(String string, int n, int n2) {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public void drawEstring(Graphics2D graphics2D, String string, float f, float f2, long l, int n, Color color) {
        string = this.toUnicode(string);
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector glyphVector = this.awtFont.createGlyphVector(fontRenderContext, string);
        glyphVector.setGlyphPosition(0, new Point2D.Float(f, f2));
        if (0 == n || 2 == n || 4 == n || 6 == n) {
            graphics2D.fill(glyphVector.getOutline());
        }
        if (1 == n || 2 == n || 5 == n || 6 == n) {
            graphics2D.draw(glyphVector.getOutline());
        }
    }

    @Override
    public String toUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = this.toUnicode == null ? this.getCharDiff(c) : c;
            if (!this.awtFont.canDisplay(c2 = this.getCMapping(c2))) {
                c2 = (char)(c2 | 0xF000);
            }
            if (!this.awtFont.canDisplay(c2)) {
                c2 = this.findAlternateSymbol(c2);
            }
            if (log.isLoggable(Level.FINER) && !this.awtFont.canDisplay(c2)) {
                log.finer(c + " " + Character.toString(c) + " " + c2 + " " + c2 + " " + this.awtFont);
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

