/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.io;

import flashgateway.io.ASObject;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openamf.AMFBody;
import org.openamf.AMFMessage;
import org.openamf.config.OpenAMFConfig;
import org.openamf.util.XMLUtils;

public class AMFDeserializer {
    private static Log log = LogFactory.getLog((Class)(class$org$openamf$io$AMFDeserializer == null ? (class$org$openamf$io$AMFDeserializer = AMFDeserializer.class$("org.openamf.io.AMFDeserializer")) : class$org$openamf$io$AMFDeserializer));
    private List storedObjects = null;
    protected DataInputStream inputStream;
    protected int headerCount;
    protected List headers = new ArrayList();
    protected int bodyCount;
    protected List bodies = new ArrayList();
    protected AMFMessage message = new AMFMessage();
    static /* synthetic */ Class class$org$openamf$io$AMFDeserializer;

    public AMFDeserializer(DataInputStream inputStream) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Deserializing Message, for more info turn on debug level");
        }
        this.inputStream = inputStream;
        this.readHeaders();
        if (log.isDebugEnabled()) {
            log.debug((Object)"readHeader");
        }
        this.readBodies();
        if (log.isDebugEnabled()) {
            log.debug((Object)"readBody");
        }
    }

    public AMFMessage getAMFMessage() {
        return this.message;
    }

    protected void readHeaders() throws IOException {
        this.message.setVersion(this.inputStream.readUnsignedShort());
        this.headerCount = this.inputStream.readUnsignedShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)("headerCount = " + this.headerCount));
        }
        int i = 0;
        while (i < this.headerCount) {
            this.storedObjects = new ArrayList();
            String key = this.inputStream.readUTF();
            boolean required = this.inputStream.readBoolean();
            long length = this.inputStream.readInt();
            byte type = this.inputStream.readByte();
            Object value = this.readData(type);
            this.message.addHeader(key, required, value);
            ++i;
        }
    }

    protected void readBodies() throws IOException {
        this.bodyCount = this.inputStream.readUnsignedShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)("bodyCount = " + this.bodyCount));
        }
        int i = 0;
        while (i < this.bodyCount) {
            this.storedObjects = new ArrayList();
            String method = this.inputStream.readUTF();
            String target = this.inputStream.readUTF();
            long length = this.inputStream.readInt();
            byte type = this.inputStream.readByte();
            if (log.isDebugEnabled()) {
                log.debug((Object)("type = " + type));
            }
            Object data = this.readData(type);
            this.message.addBody(method, target, data, type);
            ++i;
        }
    }

    protected Object readCustomClass() throws IOException {
        String mappedJavaClass;
        String type = this.inputStream.readUTF();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading Custom Class: " + type));
        }
        if ((mappedJavaClass = OpenAMFConfig.getInstance().getJavaClassName(type)) != null) {
            type = mappedJavaClass;
        }
        ASObject aso = new ASObject(type);
        return this.readObject(aso);
    }

    protected ASObject readObject() throws IOException {
        ASObject aso = new ASObject();
        return this.readObject(aso);
    }

    protected ASObject readObject(ASObject aso) throws IOException {
        this.storeObject(aso);
        if (log.isDebugEnabled()) {
            log.debug((Object)"reading object");
        }
        String key = this.inputStream.readUTF();
        byte type = this.inputStream.readByte();
        while (type != 9) {
            Object value = this.readData(type);
            if (value == null) {
                log.info((Object)("Skipping NULL value for :" + key));
            } else {
                aso.put(key, value);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" adding {key=" + key + ", value=" + value + ", type=" + type + "}"));
                }
            }
            key = this.inputStream.readUTF();
            type = this.inputStream.readByte();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"finished reading object");
        }
        return aso;
    }

    protected List readArray() throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        this.storeObject(array);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading array");
        }
        long length = this.inputStream.readInt();
        if (log.isDebugEnabled()) {
            log.debug((Object)("array length = " + length));
        }
        long i = 0L;
        while (i < length) {
            byte type = this.inputStream.readByte();
            Object data = this.readData(type);
            array.add(data);
            ++i;
        }
        return array;
    }

    private void storeObject(Object o) {
        this.storedObjects.add(o);
        if (log.isDebugEnabled()) {
            log.debug((Object)("storedObjects.size: " + this.storedObjects.size()));
        }
    }

    protected Date readDate() throws IOException {
        long ms = (long)this.inputStream.readDouble();
        int timeoffset = this.inputStream.readShort() * 60000 * -1;
        TimeZone serverTimeZone = TimeZone.getDefault();
        GregorianCalendar sent = new GregorianCalendar();
        sent.setTime(new Date(ms - (long)serverTimeZone.getRawOffset() + (long)timeoffset));
        TimeZone sentTimeZone = ((Calendar)sent).getTimeZone();
        if (sentTimeZone.inDaylightTime(sent.getTime())) {
            sent.setTime(new Date(sent.getTime().getTime() - 3600000L));
        }
        return sent.getTime();
    }

    protected Object readFlushedSO() throws IOException {
        int index = this.inputStream.readUnsignedShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Object Index: " + index));
        }
        return this.storedObjects.get(index);
    }

    protected Object readASObject() {
        return null;
    }

    protected Object readData(byte type) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading data of type " + AMFBody.getObjectTypeDescription(type)));
        }
        switch (type) {
            case 0: {
                return new Double(this.inputStream.readDouble());
            }
            case 1: {
                return new Boolean(this.inputStream.readBoolean());
            }
            case 2: {
                return this.inputStream.readUTF();
            }
            case 3: {
                return this.readObject();
            }
            case 4: {
                throw new IOException("Unknown/unsupported object type " + AMFBody.getObjectTypeDescription(type));
            }
            case 5: 
            case 6: {
                return null;
            }
            case 7: {
                return this.readFlushedSO();
            }
            case 8: {
                long length = this.inputStream.readInt();
                return this.readObject();
            }
            case 9: {
                return null;
            }
            case 10: {
                return this.readArray();
            }
            case 11: {
                return this.readDate();
            }
            case 12: {
                return this.readLongUTF(this.inputStream);
            }
            case 13: {
                return this.readASObject();
            }
            case 14: {
                return null;
            }
            case 15: {
                return XMLUtils.convertToDOM(this.inputStream);
            }
            case 16: {
                return this.readCustomClass();
            }
        }
        throw new IOException("Unknown/unsupported object type " + AMFBody.getObjectTypeDescription(type));
    }

    private Object readLongUTF(DataInputStream in) throws IOException {
        int utflen = in.readInt();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        in.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(str);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

