# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "facets"
  s.version = "2.7.0"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["facets-universal@rubyforge.org", "Thomas Sawyer <transfire@gmail.com>"]
  s.date = "2009-08-21"
  s.description = "Ruby Facets is the single largest collection of general purpose method extensions and system additions for the Ruby programming language.  The CORE extensions is a large collection of methods which extend the core capabilities of Ruby's built-in classes and modules. This collection of extension methods are unique by virtue of their atomicity. The methods are generally stored in individual files so that each can be required independently. This gives developers the potential for much finer control over which extra methods to bring into their code.  The MORE additions are a collection of classes, modules and lightweight systems which constitute an ever improving source of reusable components. This set of libraries is kept light and focused on useful to a wide variety of usecases."
  s.email = "facets-universal@rubyforge.org"
  s.extra_rdoc_files = ["Rakefile", "HISTORY.rdoc", "MANIFEST", "NOTES", "TODO", "README.rdoc", "AUTHORS", "COPYING"]
  s.files = ["Rakefile", "HISTORY.rdoc", "MANIFEST", "NOTES", "TODO", "README.rdoc", "AUTHORS", "COPYING"]
  s.homepage = "http://facets.rubyforge.org"
  s.rdoc_options = ["--inline-source", "--title", "facets api"]
  s.require_paths = ["lib/core", "lib/more"]
  s.rubyforge_project = "facets"
  s.rubygems_version = "1.8.23"
  s.summary = "Premium Core Extensions and Standard Additions"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
    else
    end
  else
  end
end
