/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.util;

import com.sun.security.sasl.util.ServiceConfigurationError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public final class Service {
    private static final String prefix = "META-INF/services/";

    private Service() {
    }

    private static void fail(Class clazz, String string) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(String.valueOf(clazz.getName()) + ": " + string);
    }

    private static void fail(Class clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        Service.fail(clazz, String.valueOf(String.valueOf(uRL)) + ":" + n + ": " + string);
    }

    public static Iterator installedProviders(Class clazz) throws ServiceConfigurationError {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader != null) {
            classLoader = classLoader.getParent();
        }
        return Service.providers(clazz, classLoader);
    }

    private static Iterator parse(Class clazz, URL uRL, Set set) throws ServiceConfigurationError {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList arrayList = new ArrayList();
        try {
            try {
                inputStream = uRL.openStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
                int n = 1;
                while ((n = Service.parseLine(clazz, uRL, bufferedReader, n, arrayList, set)) >= 0) {
                }
            }
            catch (IOException iOException) {
                Service.fail(clazz, ": " + iOException);
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Service.fail(clazz, ": " + iOException);
            }
            throw throwable;
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Service.fail(clazz, ": " + iOException);
        }
        return ((AbstractList)arrayList).iterator();
    }

    private static int parseLine(Class clazz, URL uRL, BufferedReader bufferedReader, int n, List list, Set set) throws IOException, ServiceConfigurationError {
        int n2;
        String string = bufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                Service.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                Service.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            int n4 = 1;
            while (n4 < n2) {
                char c = string.charAt(n4);
                if (!Character.isJavaIdentifierPart(c) && c != '.') {
                    Service.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
                }
                ++n4;
            }
            if (!set.contains(string)) {
                list.add(string);
                set.add(string);
            }
        }
        return n + 1;
    }

    public static Iterator providers(Class clazz) throws ServiceConfigurationError {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Service.providers(clazz, classLoader);
    }

    public static Iterator providers(Class clazz, ClassLoader classLoader) throws ServiceConfigurationError {
        class Com_sun_security_sasl_util_Service$1 {
            /* synthetic */ Com_sun_security_sasl_util_Service$1() {
            }
        }
        return new LazyIterator(null, clazz, classLoader);
    }

    private static class LazyIterator
    implements Iterator {
        Class service;
        ClassLoader loader;
        Enumeration configs = null;
        Iterator pending = null;
        Set returned = new TreeSet();
        String nextName = null;

        /* synthetic */ LazyIterator(1 var1_1, Class clazz, ClassLoader classLoader) {
            this(clazz, classLoader);
        }

        private LazyIterator(Class clazz, ClassLoader classLoader) {
            this.service = clazz;
            this.loader = classLoader;
        }

        public boolean hasNext() throws ServiceConfigurationError {
            block7: {
                if (this.nextName != null) {
                    return true;
                }
                if (this.configs == null) {
                    try {
                        String string = Service.prefix + this.service.getName();
                        if (this.loader == null) {
                            this.configs = ClassLoader.getSystemResources(string);
                            break block7;
                        }
                        this.configs = this.loader.getResources(string);
                    }
                    catch (IOException iOException) {
                        Service.fail(this.service, ": " + iOException);
                    }
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = Service.parse(this.service, (URL)this.configs.nextElement(), this.returned);
            }
            this.nextName = (String)this.pending.next();
            return true;
        }

        public Object next() throws ServiceConfigurationError {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.nextName;
            this.nextName = null;
            try {
                return Class.forName(string, true, this.loader).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Service.fail(this.service, "Provider " + string + " not found");
            }
            catch (Exception exception) {
                Service.fail(this.service, "Provider " + string + " could not be instantiated: " + exception);
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

