/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.test.TestBase;

public class TestPreparedStatement
extends TestBase {
    static final int LOB_SIZE = 4000;
    static final int LOB_SIZE_BIG = 524288;

    public void test() throws Exception {
        this.deleteDb("preparedStatement");
        Connection conn = this.getConnection("preparedStatement");
        this.testLikeIndex(conn);
        this.testCasewhen(conn);
        this.testSubquery(conn);
        this.testObject(conn);
        if (this.config.jdk14) {
            this.testIdentity(conn);
        }
        this.testDataTypes(conn);
        this.testBlob(conn);
        this.testClob(conn);
        conn.close();
    }

    private void testLikeIndex(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        stat.execute("create index idxname on test(name);");
        PreparedStatement prep = conn.prepareStatement("EXPLAIN SELECT * FROM TEST WHERE NAME LIKE ?");
        PreparedStatement prepExe = conn.prepareStatement("SELECT * FROM TEST WHERE NAME LIKE ?");
        prep.setString(1, "%orld");
        prepExe.setString(1, "%orld");
        ResultSet rs = prep.executeQuery();
        rs.next();
        String plan = rs.getString(1);
        this.check(plan.indexOf("TABLE_SCAN") >= 0);
        rs = prepExe.executeQuery();
        rs.next();
        this.check(rs.getString(2), "World");
        this.checkFalse(rs.next());
        prep.setString(1, "H%");
        prepExe.setString(1, "H%");
        rs = prep.executeQuery();
        rs.next();
        String plan1 = rs.getString(1);
        this.check(plan1.indexOf("IDXNAME") >= 0);
        rs = prepExe.executeQuery();
        rs.next();
        this.check(rs.getString(2), "Hello");
        this.checkFalse(rs.next());
        stat.execute("DROP TABLE IF EXISTS TEST");
    }

    private void testCasewhen(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("INSERT INTO TEST VALUES(1),(2),(3)");
        PreparedStatement prep = conn.prepareStatement("EXPLAIN SELECT COUNT(*) FROM TEST WHERE CASEWHEN(ID=1, ID, ID)=? GROUP BY ID");
        prep.setInt(1, 1);
        ResultSet rs = prep.executeQuery();
        rs.next();
        String plan = rs.getString(1);
        this.trace(plan);
        rs.close();
        prep = conn.prepareStatement("EXPLAIN SELECT COUNT(*) FROM TEST WHERE CASE ID WHEN 1 THEN ID WHEN 2 THEN ID ELSE ID END=? GROUP BY ID");
        prep.setInt(1, 1);
        rs = prep.executeQuery();
        rs.next();
        plan = rs.getString(1);
        this.trace(plan);
        prep = conn.prepareStatement("SELECT COUNT(*) FROM TEST WHERE CASEWHEN(ID=1, ID, ID)=? GROUP BY ID");
        prep.setInt(1, 1);
        rs = prep.executeQuery();
        this.check(rs.next());
        this.check(rs.getInt(1), 1L);
        this.checkFalse(rs.next());
        prep = conn.prepareStatement("SELECT COUNT(*) FROM TEST WHERE CASE ID WHEN 1 THEN ID WHEN 2 THEN ID ELSE ID END=? GROUP BY ID");
        prep.setInt(1, 1);
        rs = prep.executeQuery();
        this.check(rs.next());
        this.check(rs.getInt(1), 1L);
        this.checkFalse(rs.next());
        prep = conn.prepareStatement("SELECT * FROM TEST WHERE ? IS NULL");
        prep.setString(1, "Hello");
        rs = prep.executeQuery();
        this.checkFalse(rs.next());
        prep = conn.prepareStatement("select ? from dual union select ? from dual");
        prep.setString(1, "a");
        prep.setString(2, "a");
        rs = prep.executeQuery();
        rs.next();
        this.check(rs.getString(1), "a");
        this.check(rs.getString(1), "a");
        this.checkFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }

    private void testSubquery(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("INSERT INTO TEST VALUES(1),(2),(3)");
        PreparedStatement prep = conn.prepareStatement("select x.id, ? from (select * from test where id in(?, ?)) x where x.id*2 <>  ?");
        prep.setInt(1, 0);
        prep.setInt(2, 1);
        prep.setInt(3, 2);
        prep.setInt(4, 4);
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getInt(2), 0L);
        this.checkFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }

    private void testDataTypes(Connection conn) throws Exception {
        conn.createStatement(1003, 1007);
        conn.createStatement(1005, 1008);
        Statement stat = conn.createStatement();
        this.trace("Create tables");
        stat.execute("CREATE TABLE T_INT(ID INT PRIMARY KEY,VALUE INT)");
        stat.execute("CREATE TABLE T_VARCHAR(ID INT PRIMARY KEY,VALUE VARCHAR(255))");
        stat.execute("CREATE TABLE T_DECIMAL_0(ID INT PRIMARY KEY,VALUE DECIMAL(30,0))");
        stat.execute("CREATE TABLE T_DECIMAL_10(ID INT PRIMARY KEY,VALUE DECIMAL(20,10))");
        stat.execute("CREATE TABLE T_DATETIME(ID INT PRIMARY KEY,VALUE DATETIME)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO T_INT VALUES(?,?)", 1003, 1007);
        prep.setInt(1, 1);
        prep.setInt(2, 0);
        prep.executeUpdate();
        prep.setInt(1, 2);
        prep.setInt(2, -1);
        prep.executeUpdate();
        prep.setInt(1, 3);
        prep.setInt(2, 3);
        prep.executeUpdate();
        prep.setInt(1, 4);
        prep.setNull(2, 4);
        prep.executeUpdate();
        prep.setInt(1, 5);
        prep.setBigDecimal(2, new BigDecimal("0"));
        prep.executeUpdate();
        prep.setInt(1, 6);
        prep.setString(2, "-1");
        prep.executeUpdate();
        prep.setInt(1, 7);
        prep.setObject(2, new Integer(3));
        prep.executeUpdate();
        prep.setObject(1, "8");
        prep.setObject(2, null);
        prep.executeUpdate();
        prep.setInt(1, 9);
        prep.setObject(2, (Object)new Integer(-4), 12);
        prep.executeUpdate();
        prep.setInt(1, 10);
        prep.setObject(2, (Object)"5", 4);
        prep.executeUpdate();
        prep.setInt(1, 11);
        prep.setObject(2, null, 4);
        prep.executeUpdate();
        prep.setInt(1, 12);
        prep.setBoolean(2, true);
        prep.executeUpdate();
        prep.setInt(1, 13);
        prep.setBoolean(2, false);
        prep.executeUpdate();
        prep.setInt(1, 14);
        prep.setByte(2, (byte)-20);
        prep.executeUpdate();
        prep.setInt(1, 15);
        prep.setByte(2, (byte)100);
        prep.executeUpdate();
        prep.setInt(1, 16);
        prep.setShort(2, (short)30000);
        prep.executeUpdate();
        prep.setInt(1, 17);
        prep.setShort(2, (short)-30000);
        prep.executeUpdate();
        prep.setInt(1, 18);
        prep.setLong(2, Integer.MAX_VALUE);
        prep.executeUpdate();
        prep.setInt(1, 19);
        prep.setLong(2, Integer.MIN_VALUE);
        prep.executeUpdate();
        this.check(stat.execute("SELECT * FROM T_INT ORDER BY ID"));
        ResultSet rs = stat.getResultSet();
        this.testResultSetOrdered(rs, new String[][]{{"1", "0"}, {"2", "-1"}, {"3", "3"}, {"4", null}, {"5", "0"}, {"6", "-1"}, {"7", "3"}, {"8", null}, {"9", "-4"}, {"10", "5"}, {"11", null}, {"12", "1"}, {"13", "0"}, {"14", "-20"}, {"15", "100"}, {"16", "30000"}, {"17", "-30000"}, {"18", "2147483647"}, {"19", "-2147483648"}});
        prep = conn.prepareStatement("INSERT INTO T_DECIMAL_0 VALUES(?,?)");
        prep.setInt(1, 1);
        prep.setLong(2, Long.MAX_VALUE);
        prep.executeUpdate();
        prep.setInt(1, 2);
        prep.setLong(2, Long.MIN_VALUE);
        prep.executeUpdate();
        prep.setInt(1, 3);
        prep.setFloat(2, 10.0f);
        prep.executeUpdate();
        prep.setInt(1, 4);
        prep.setFloat(2, -20.0f);
        prep.executeUpdate();
        prep.setInt(1, 5);
        prep.setFloat(2, 30.0f);
        prep.executeUpdate();
        prep.setInt(1, 6);
        prep.setFloat(2, -40.0f);
        prep.executeUpdate();
        rs = stat.executeQuery("SELECT VALUE FROM T_DECIMAL_0 ORDER BY ID");
        this.checkBigDecimal(rs, new String[]{"9223372036854775807", "-9223372036854775808", "10", "-20", "30", "-40"});
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("INSERT INTO TEST VALUES(1)");
        prep = conn.prepareStatement("SELECT * FROM TEST");
        prep.getMetaData();
        this.check(prep.execute());
        rs = prep.getResultSet();
        this.checkFalse(prep.getMoreResults());
        try {
            rs.next();
            this.error("getMoreResults didn't close this result set");
        }
        catch (SQLException e) {
            this.trace("no error - getMoreResults is supposed to close the result set");
        }
        this.check(prep.getUpdateCount() == -1);
        prep = conn.prepareStatement("DELETE FROM TEST");
        prep.executeUpdate();
        this.checkFalse(prep.getMoreResults());
        this.check(prep.getUpdateCount() == -1);
    }

    private void testObject(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        PreparedStatement prep = conn.prepareStatement("SELECT ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? FROM TEST");
        prep.setObject(1, new Boolean(true));
        prep.setObject(2, "Abc");
        prep.setObject(3, new BigDecimal("10.2"));
        prep.setObject(4, new Byte(-1));
        prep.setObject(5, new Short(Short.MAX_VALUE));
        prep.setObject(6, new Integer(Integer.MIN_VALUE));
        prep.setObject(7, new Long(Long.MAX_VALUE));
        prep.setObject(8, new Float(Float.MAX_VALUE));
        prep.setObject(9, new Double(Double.MAX_VALUE));
        prep.setObject(10, Date.valueOf("2001-02-03"));
        prep.setObject(11, Time.valueOf("04:05:06"));
        prep.setObject(12, Timestamp.valueOf("2001-02-03 04:05:06.123456789"));
        prep.setObject(13, new java.util.Date(Date.valueOf("2001-02-03").getTime()));
        prep.setObject(14, new byte[]{10, 20, 30});
        prep.setObject(15, new Character('a'));
        prep.setObject(16, (Object)"2001-01-02", 91);
        prep.setObject(17, (Object)"2001-01-02", 0);
        prep.setObject(18, (Object)"3.725", 8);
        prep.setObject(19, (Object)"23:22:21", 92);
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.check(rs.getObject(1).equals(new Boolean(true)));
        this.check(rs.getObject(2).equals("Abc"));
        this.check(rs.getObject(3).equals(new BigDecimal("10.2")));
        this.check(rs.getObject(4).equals(new Byte(-1)));
        this.check(rs.getObject(5).equals(new Short(Short.MAX_VALUE)));
        this.check(rs.getObject(6).equals(new Integer(Integer.MIN_VALUE)));
        this.check(rs.getObject(7).equals(new Long(Long.MAX_VALUE)));
        this.check(rs.getObject(8).equals(new Float(Float.MAX_VALUE)));
        this.check(rs.getObject(9).equals(new Double(Double.MAX_VALUE)));
        this.check(rs.getObject(10).equals(Date.valueOf("2001-02-03")));
        this.check(rs.getObject(11).toString(), "04:05:06");
        this.check(rs.getObject(11).equals(Time.valueOf("04:05:06")));
        this.check(rs.getObject(12).equals(Timestamp.valueOf("2001-02-03 04:05:06.123456789")));
        this.check(rs.getObject(13).equals(Date.valueOf("2001-02-03")));
        this.check(rs.getBytes(14), new byte[]{10, 20, 30});
        this.check(rs.getObject(15).equals(new Character('a')));
        this.check(rs.getObject(16).equals(Date.valueOf("2001-01-02")));
        this.check(rs.getObject(17) == null && rs.wasNull());
        this.check(rs.getObject(18).equals(new Double(3.725)));
        this.check(rs.getObject(19).equals(Time.valueOf("23:22:21")));
        stat.execute("DROP TABLE TEST");
    }

    private void testIdentity(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE SEQUENCE SEQ");
        stat.execute("CREATE TABLE TEST(ID INT)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)");
        prep.execute();
        ResultSet rs = prep.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.checkFalse(rs.next());
        prep = conn.prepareStatement("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", 1);
        prep.execute();
        rs = prep.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 2L);
        this.checkFalse(rs.next());
        prep = conn.prepareStatement("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", new int[]{1});
        prep.execute();
        rs = prep.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 3L);
        this.checkFalse(rs.next());
        prep = conn.prepareStatement("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", new String[]{"ID"});
        prep.execute();
        rs = prep.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 4L);
        this.checkFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }

    int getLength() throws Exception {
        return this.getSize(4000, 524288);
    }

    void testBlob(Connection conn) throws Exception {
        this.trace("testBlob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T_BLOB(ID INT PRIMARY KEY,V1 BLOB,V2 BLOB)");
        this.trace("table created");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO T_BLOB VALUES(?,?,?)");
        prep.setInt(1, 1);
        prep.setBytes(2, null);
        prep.setNull(3, -2);
        prep.executeUpdate();
        prep.setInt(1, 2);
        prep.setBinaryStream(2, (InputStream)null, 0);
        prep.setNull(3, 2004);
        prep.executeUpdate();
        int length = this.getLength();
        byte[] big1 = new byte[length];
        byte[] big2 = new byte[length];
        for (int i = 0; i < big1.length; ++i) {
            big1[i] = (byte)(i * 11 % 254);
            big2[i] = (byte)(i * 17 % 251);
        }
        prep.setInt(1, 3);
        prep.setBytes(2, big1);
        prep.setBytes(3, big2);
        prep.executeUpdate();
        prep.setInt(1, 4);
        ByteArrayInputStream buffer = new ByteArrayInputStream(big2);
        prep.setBinaryStream(2, (InputStream)buffer, big2.length);
        buffer = new ByteArrayInputStream(big1);
        prep.setBinaryStream(3, (InputStream)buffer, big1.length);
        prep.executeUpdate();
        try {
            buffer.close();
            this.trace("buffer not closed");
        }
        catch (IOException e) {
            this.trace("buffer closed");
        }
        prep.setInt(1, 5);
        buffer = new ByteArrayInputStream(big2);
        prep.setObject(2, (Object)buffer, 2004, 0);
        buffer = new ByteArrayInputStream(big1);
        prep.setObject(3, buffer);
        prep.executeUpdate();
        ResultSet rs = stat.executeQuery("SELECT ID, V1, V2 FROM T_BLOB ORDER BY ID");
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getBytes(2) == null && rs.wasNull());
        this.check(rs.getBytes(3) == null && rs.wasNull());
        rs.next();
        this.check(rs.getInt(1), 2L);
        this.check(rs.getBytes(2) == null && rs.wasNull());
        this.check(rs.getBytes(3) == null && rs.wasNull());
        rs.next();
        this.check(rs.getInt(1), 3L);
        this.check(rs.getBytes(2), big1);
        this.check(rs.getBytes(3), big2);
        rs.next();
        this.check(rs.getInt(1), 4L);
        this.check(rs.getBytes(2), big2);
        this.check(rs.getBytes(3), big1);
        rs.next();
        this.check(rs.getInt(1), 5L);
        this.check(rs.getBytes(2), big2);
        this.check(rs.getBytes(3), big1);
        this.checkFalse(rs.next());
    }

    void testClob(Connection conn) throws Exception {
        this.trace("testClob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T_CLOB(ID INT PRIMARY KEY,V1 CLOB,V2 CLOB)");
        StringBuffer asciibuffer = new StringBuffer();
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            asciibuffer.append((char)(97 + i % 20));
        }
        String ascii1 = asciibuffer.toString();
        String ascii2 = "Number2 " + ascii1;
        PreparedStatement prep = conn.prepareStatement("INSERT INTO T_CLOB VALUES(?,?,?)");
        prep.setInt(1, 1);
        prep.setString(2, null);
        prep.setNull(3, 2005);
        prep.executeUpdate();
        prep.clearParameters();
        prep.setInt(1, 2);
        prep.setAsciiStream(2, (InputStream)null, 0);
        prep.setCharacterStream(3, (Reader)null, 0);
        prep.executeUpdate();
        prep.clearParameters();
        prep.setInt(1, 3);
        prep.setCharacterStream(2, (Reader)new StringReader(ascii1), ascii1.length());
        prep.setCharacterStream(3, (Reader)null, 0);
        prep.setAsciiStream(3, (InputStream)new ByteArrayInputStream(ascii2.getBytes()), ascii2.length());
        prep.executeUpdate();
        prep.clearParameters();
        prep.setInt(1, 4);
        prep.setNull(2, 2005);
        prep.setString(2, ascii2);
        prep.setCharacterStream(3, (Reader)null, 0);
        prep.setNull(3, 2005);
        prep.setString(3, ascii1);
        prep.executeUpdate();
        prep.clearParameters();
        prep.setInt(1, 5);
        prep.setObject(2, new StringReader(ascii1));
        prep.setObject(3, (Object)new StringReader(ascii2), 2005, 0);
        prep.executeUpdate();
        ResultSet rs = stat.executeQuery("SELECT ID, V1, V2 FROM T_CLOB ORDER BY ID");
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getCharacterStream(2) == null && rs.wasNull());
        this.check(rs.getAsciiStream(3) == null && rs.wasNull());
        rs.next();
        this.check(rs.getInt(1), 2L);
        this.check(rs.getString(2) == null && rs.wasNull());
        this.check(rs.getString(3) == null && rs.wasNull());
        rs.next();
        this.check(rs.getInt(1), 3L);
        this.check(rs.getString(2), ascii1);
        this.check(rs.getString(3), ascii2);
        rs.next();
        this.check(rs.getInt(1), 4L);
        this.check(rs.getString(2), ascii2);
        this.check(rs.getString(3), ascii1);
        rs.next();
        this.check(rs.getInt(1), 5L);
        this.check(rs.getString(2), ascii1);
        this.check(rs.getString(3), ascii2);
        this.checkFalse(rs.next());
        this.check(prep.getWarnings() == null);
        prep.clearWarnings();
        this.check(prep.getWarnings() == null);
        this.check(conn == prep.getConnection());
    }

    void checkBigDecimal(ResultSet rs, String[] value) throws Exception {
        for (int i = 0; i < value.length; ++i) {
            String v = value[i];
            this.check(rs.next());
            BigDecimal x = rs.getBigDecimal(1);
            this.trace("v=" + v + " x=" + x);
            if (v == null) {
                this.check(x == null);
                continue;
            }
            this.check(x.compareTo(new BigDecimal(v)) == 0);
        }
        this.check(!rs.next());
    }
}

