/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.phonegap.api.PhonegapActivity;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import org.json.JSONArray;

public class NetworkManager
extends Plugin {
    public static int NOT_REACHABLE = 0;
    public static int REACHABLE_VIA_CARRIER_DATA_NETWORK = 1;
    public static int REACHABLE_VIA_WIFI_NETWORK = 2;
    public static final String WIFI = "wifi";
    public static final String WIMAX = "wimax";
    public static final String MOBILE = "mobile";
    public static final String GSM = "gsm";
    public static final String GPRS = "gprs";
    public static final String EDGE = "edge";
    public static final String CDMA = "cdma";
    public static final String UMTS = "umts";
    public static final String HSPA = "hspa";
    public static final String HSUPA = "hsupa";
    public static final String HSDPA = "hsdpa";
    public static final String ONEXRTT = "1xrtt";
    public static final String EHRPD = "ehrpd";
    public static final String LTE = "lte";
    public static final String UMB = "umb";
    public static final String HSPA_PLUS = "hspa+";
    public static final String TYPE_UNKNOWN = "unknown";
    public static final String TYPE_ETHERNET = "ethernet";
    public static final String TYPE_WIFI = "wifi";
    public static final String TYPE_2G = "2g";
    public static final String TYPE_3G = "3g";
    public static final String TYPE_4G = "4g";
    public static final String TYPE_NONE = "none";
    private static final String LOG_TAG = "NetworkManager";
    private String connectionCallbackId;
    ConnectivityManager sockMan;
    BroadcastReceiver receiver = null;

    public void setContext(PhonegapActivity ctx) {
        super.setContext(ctx);
        this.sockMan = (ConnectivityManager)ctx.getSystemService("connectivity");
        this.connectionCallbackId = null;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    NetworkManager.this.updateConnectionInfo((NetworkInfo)intent.getParcelableExtra("networkInfo"));
                }
            };
            ctx.registerReceiver(this.receiver, intentFilter);
        }
    }

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.INVALID_ACTION;
        String result = "Unsupported Operation: " + action;
        if (action.equals("getConnectionInfo")) {
            this.connectionCallbackId = callbackId;
            NetworkInfo info = this.sockMan.getActiveNetworkInfo();
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, this.getConnectionInfo(info));
            pluginResult.setKeepCallback(true);
            return pluginResult;
        }
        return new PluginResult(status, result);
    }

    public boolean isSynch(String action) {
        return false;
    }

    public void onDestroy() {
        if (this.receiver != null) {
            try {
                this.ctx.unregisterReceiver(this.receiver);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("Error unregistering network receiver: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void updateConnectionInfo(NetworkInfo info) {
        this.sendUpdate(this.getConnectionInfo(info));
    }

    private String getConnectionInfo(NetworkInfo info) {
        String type = TYPE_NONE;
        if (info != null) {
            type = !info.isConnected() ? TYPE_NONE : this.getType(info);
        }
        return type;
    }

    private void sendUpdate(String type) {
        PluginResult result = new PluginResult(PluginResult.Status.OK, type);
        result.setKeepCallback(true);
        this.success(result, this.connectionCallbackId);
        this.ctx.postMessage("networkconnection", type);
    }

    private String getType(NetworkInfo info) {
        if (info != null) {
            String type = info.getTypeName();
            if (type.toLowerCase().equals("wifi")) {
                return "wifi";
            }
            if (type.toLowerCase().equals(MOBILE)) {
                type = info.getSubtypeName();
                if (type.toLowerCase().equals(GSM) || type.toLowerCase().equals(GPRS) || type.toLowerCase().equals(EDGE)) {
                    return TYPE_2G;
                }
                if (type.toLowerCase().startsWith(CDMA) || type.toLowerCase().equals(UMTS) || type.toLowerCase().equals(ONEXRTT) || type.toLowerCase().equals(EHRPD) || type.toLowerCase().equals(HSUPA) || type.toLowerCase().equals(HSDPA) || type.toLowerCase().equals(HSPA)) {
                    return TYPE_3G;
                }
                if (type.toLowerCase().equals(LTE) || type.toLowerCase().equals(UMB) || type.toLowerCase().equals(HSPA_PLUS)) {
                    return TYPE_4G;
                }
            }
        } else {
            return TYPE_NONE;
        }
        return TYPE_UNKNOWN;
    }
}

